/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.nexus.client.beans;

import java.util.Set;
import javax.xml.bind.annotation.XmlType;
import org.glassfish.nexus.client.NexusClientException;
import org.glassfish.nexus.client.NexusClientImpl;
import org.glassfish.nexus.client.StagingAggregation;
import org.glassfish.nexus.client.StagingOperation;
import org.glassfish.nexus.client.beans.MavenArtifactInfo;
import org.glassfish.nexus.client.beans.StagingProfileRepo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType
public final class Repo
implements StagingOperation {
    private String id;
    private String name;
    private String repoType;
    private String writePolicy;

    public Repo() {
    }

    public Repo(StagingProfileRepo repo) {
        this.id = repo.getRepositoryId();
        this.name = repo.getRepositoryName();
        this.repoType = repo.getProfileType();
        this.writePolicy = repo.isOpen() ? "ALLOW_WRITE" : "READ_ONLY";
    }

    public String getWritePolicy() {
        return this.writePolicy;
    }

    public void setWritePolicy(String writePolicy) {
        this.writePolicy = writePolicy;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRepoType() {
        return this.repoType;
    }

    public void setRepoType(String repoType) {
        this.repoType = repoType;
    }

    public String toString() {
        return "Repository{id=" + this.id + ", name=" + this.name + '}';
    }

    public boolean isOpen() {
        return this.writePolicy.equals("ALLOW_WRITE");
    }

    @Override
    public void close(String msg) throws NexusClientException {
        Repo.getNexusClient().closeStagingRepo(msg, this.getIds());
    }

    @Override
    public void drop(String msg) throws NexusClientException {
        Repo.getNexusClient().dropStagingRepo(msg, this.getIds());
    }

    @Override
    public Repo promote(String profile, String msg) throws NexusClientException {
        return Repo.getNexusClient().promoteStagingRepo(profile, msg, this.getIds());
    }

    @Override
    public StagingAggregation aggregate(StagingOperation repo) throws NexusClientException {
        return new StagingAggregation(this).aggregate(repo);
    }

    @Override
    public String[] getIds() {
        return new String[]{this.getId()};
    }

    public Set<MavenArtifactInfo> getContent() {
        return Repo.getNexusClient().getArtifactsInRepo(this.getId());
    }

    private StagingProfileRepo getProfileRepo() {
        return Repo.getNexusClient().getStagingProfileRepo(this.getId());
    }

    private static NexusClientImpl getNexusClient() {
        return (NexusClientImpl)NexusClientImpl.getInstance();
    }

    public Repo getParent() {
        Repo parent = null;
        StagingProfileRepo profileRepo = this.getProfileRepo();
        if (profileRepo != null && profileRepo.getParentGroupId() != null) {
            return new Repo(Repo.getNexusClient().getStagingProfileRepo(profileRepo.getParentGroupId()));
        }
        return parent;
    }

    public String getProfileName() {
        StagingProfileRepo profileRepo = Repo.getNexusClient().getStagingProfileRepo(this.getId());
        if (profileRepo != null) {
            return profileRepo.getProfileName();
        }
        return null;
    }

    public boolean isGroup() {
        StagingProfileRepo profileRepo = this.getProfileRepo();
        if (profileRepo != null) {
            return profileRepo.getProfileType().equals("group");
        }
        return false;
    }

    public Set<Repo> getGroupTree() {
        if (this.isGroup()) {
            return Repo.getNexusClient().getGroupTree(this.getId());
        }
        return null;
    }
}

