/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="merge-copyright-headers")
public final class MergeCopyrightHeadersMojo
extends AbstractMojo {
    private static final String PROPERTY_PREFIX = "merge.copyright.headers.outputFile";
    @Parameter(property="merge.copyright.headers.outputFileoutputFile", defaultValue="${project.build.directory}/merged.properties")
    private File outputFile;
    @Parameter(property="merge.copyright.headers.outputFileinputFiles")
    private File[] inputFiles;
    @Parameter(property="merge.copyright.headers.outputFileskip", defaultValue="false")
    private Boolean skip;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        block18: {
            if (this.skip.booleanValue()) {
                this.getLog().info((CharSequence)"Skipping file merge ...");
                return;
            }
            BufferedReader br1 = null;
            BufferedReader br2 = null;
            BufferedWriter writer = null;
            try {
                String line;
                StringBuilder sb = new StringBuilder();
                if (this.inputFiles == null || this.inputFiles.length <= 1) break block18;
                File file1 = this.inputFiles[0];
                this.getLog().info((CharSequence)("Reading input file:" + file1.getAbsolutePath()));
                try {
                    br1 = new BufferedReader(new FileReader(file1));
                    while ((line = br1.readLine()) != null) {
                        sb.append(line);
                        sb.append(System.lineSeparator());
                    }
                }
                finally {
                    if (br1 != null) {
                        br1.close();
                    }
                }
                for (int i = 1; i < this.inputFiles.length; ++i) {
                    File file2 = this.inputFiles[i];
                    this.getLog().info((CharSequence)("Reading input file:" + file2.getAbsolutePath()));
                    try {
                        br2 = new BufferedReader(new FileReader(file2));
                        while ((line = br2.readLine()) != null) {
                            if ((line = line.trim()).startsWith("#")) continue;
                            sb.append(line);
                            sb.append(System.lineSeparator());
                        }
                        continue;
                    }
                    finally {
                        if (br2 != null) {
                            br2.close();
                        }
                    }
                }
                try {
                    writer = new BufferedWriter(new FileWriter(this.outputFile));
                    writer.write(sb.toString());
                    writer.flush();
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (IOException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
        }
    }
}

