/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.spec;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.glassfish.spec.Artifact;
import org.glassfish.spec.Metadata;

public class Spec {
    private Artifact artifact;
    private Metadata metadata;
    private JarFile jar;
    private String specVersion;
    private String newSpecVersion;
    private String specImplVersion;
    private String implVersion;
    private String newImplVersion;
    private String specBuild;
    private String implBuild;
    private String apiPackage;
    private String implNamespace;
    private boolean nonFinal = false;
    private JarType jarType = null;
    private List<String> errors = new LinkedList<String>();
    private static final String NONFINAL_BUILD_SEPARATOR_SPEC = ".99.";
    private static final String NONFINAL_BUILD_SEPARATOR = ".99.b";
    private static final String JCP_VERSION_RULE = "JCP spec version number must be of the form <major>.<minor>";
    public static final String API_SUFFIX = "-api";

    public void read(JarFile _jar) throws IOException {
        this.jar = _jar;
        this.artifact = Artifact.fromJar(this.jar);
        this.metadata = Metadata.fromJar(this.jar);
        this.errors.clear();
        this.errors.addAll(this.metadata.getErrors());
    }

    private void checkClasses(JarFile jf, String ... pkgs) {
        Enumeration<JarEntry> e = jf.entries();
        HashSet<String> badPackages = new HashSet<String>();
        block0: while (e.hasMoreElements()) {
            String name;
            JarEntry je = e.nextElement();
            if (je.isDirectory() || !(name = je.getName()).endsWith(".class")) continue;
            name = name.substring(0, name.length() - 6);
            name = name.replace('/', '.');
            for (String p : pkgs) {
                if (name.startsWith(p) && name.charAt(p.length()) == '.') continue block0;
            }
            int i = name.lastIndexOf(46);
            if (i > 0) {
                name = name.substring(0, i);
            }
            if (badPackages.contains(name)) continue;
            badPackages.add(name);
            if (!name.startsWith("javax.")) continue;
            this.errors.add(String.format("ERROR: jar file includes class in wrong package (%s)", name));
        }
    }

    public void verify() {
        String symbolicName;
        this.errors.clear();
        this.errors.addAll(this.getMetadata().getErrors());
        StringBuilder configIssues = new StringBuilder();
        if (this.jarType == null) {
            configIssues.append(" jarType?");
        }
        if (this.specVersion == null || this.specVersion.isEmpty()) {
            configIssues.append(" spec-version");
        }
        if (this.apiPackage == null || this.apiPackage.isEmpty()) {
            configIssues.append(" api-package");
        }
        if (this.nonFinal && (this.newSpecVersion == null || this.newSpecVersion.isEmpty())) {
            configIssues.append(" new-spec-version");
        }
        if (this.jarType != null) {
            if (this.jarType.equals((Object)JarType.impl)) {
                if (this.implNamespace == null || this.implNamespace.isEmpty()) {
                    configIssues.append(" impl-namespace");
                }
                if (this.implVersion == null || this.implVersion.isEmpty()) {
                    configIssues.append(" impl-version");
                }
                if (this.nonFinal && (this.newImplVersion == null || this.newImplVersion.isEmpty())) {
                    configIssues.append(" new-impl-version");
                }
            } else if (!this.nonFinal && (this.specImplVersion == null || this.specImplVersion.isEmpty())) {
                configIssues.append(" spec-impl-version");
            }
        }
        if (configIssues.length() > 0) {
            configIssues.insert(0, "ERROR: missing configuration (");
            configIssues.append(" )");
            this.errors.add(configIssues.toString());
            return;
        }
        if (!this.specVersion.matches("[0-9]+\\.[0-9]+")) {
            this.errors.add(String.format("WARNING: spec-version (%s) is invalid, %s", this.specVersion, JCP_VERSION_RULE));
        }
        if (!this.getMetadata().getjarImplementationVersion().isEmpty() && !this.getMetadata().getjarImplementationVersion().equals(this.artifact.getVersion().toString())) {
            this.errors.add(String.format("WARNING: %s (%s) should be equal to Maven-Version (%s)", "Implementation-Version", this.getMetadata().getjarImplementationVersion(), this.artifact.getVersion().toString()));
        }
        if (!this.nonFinal) {
            if (!this.getMetadata().getBundleVersion().equals(this.artifact.getVersion().toString())) {
                this.errors.add(String.format("WARNING: %s (%s) should be %s", "Bundle-Version", this.metadata.getBundleVersion(), this.artifact.getVersion().toString()));
            }
        } else {
            DefaultArtifactVersion av = new DefaultArtifactVersion(this.specVersion);
            String bundleVersion = av.getMajorVersion() + "." + av.getMinorVersion() + NONFINAL_BUILD_SEPARATOR + (this.jarType.equals((Object)JarType.impl) ? this.implBuild : this.specBuild);
            if (!this.getMetadata().getBundleVersion().equals(bundleVersion)) {
                this.errors.add(String.format("WARNING: %s (%s) should be %s", "Bundle-Version", this.metadata.getBundleVersion(), bundleVersion));
            }
        }
        if (this.jarType.equals((Object)JarType.api)) {
            if (!this.artifact.getGroupId().startsWith("javax.")) {
                this.errors.add(String.format("WARNING: groupId (%s) must start with \"javax\"", this.artifact.getGroupId()));
            }
            if (!this.artifact.getArtifactId().endsWith(API_SUFFIX)) {
                this.errors.add(String.format("WARNING: artifactId (%s) should en with %s", this.artifact.getArtifactId(), API_SUFFIX));
            }
            if (!this.apiPackage.startsWith("javax.")) {
                this.errors.add(String.format("WARNING: API packages (%s) must start with \"javax\"", this.apiPackage));
            }
            symbolicName = this.apiPackage.concat(API_SUFFIX);
            if (!this.getMetadata().getBundleSymbolicName().isEmpty() && !symbolicName.equals(this.getMetadata().getBundleSymbolicName())) {
                this.errors.add(String.format("WARNING: %s (%s) should be %s", "Bundle-SymbolicName", this.getMetadata().getBundleSymbolicName(), symbolicName));
            }
            if (!this.getMetadata().getJarExtensionName().isEmpty() && !this.getMetadata().getJarExtensionName().equals(this.apiPackage)) {
                this.errors.add(String.format("WARNING: %s (%s) should be %s", "Extension-Name", this.getMetadata().getJarExtensionName(), this.apiPackage));
            }
            if (this.jar != null) {
                this.checkClasses(this.jar, this.apiPackage);
            }
            if (this.nonFinal) {
                if (!this.newSpecVersion.matches("[0-9]+\\.[0-9]+")) {
                    this.errors.add(String.format("WARNING: new-spec-version (%s) is invalid, %s", this.newSpecVersion, JCP_VERSION_RULE));
                }
                if (this.specVersion.equals(this.newSpecVersion)) {
                    this.errors.add(String.format("WARNING: spec-version (%s) can't be equal to new-spec-version (%s) for non final artifacts", this.specVersion, this.newSpecVersion));
                } else {
                    DefaultArtifactVersion specAV = new DefaultArtifactVersion(this.specVersion);
                    DefaultArtifactVersion newSpecAV = new DefaultArtifactVersion(this.newSpecVersion);
                    if (specAV.compareTo((Object)newSpecAV) > 0) {
                        this.errors.add(String.format("WARNING: new-spec-version (%s) must be greater than spec-version (%s)", this.newSpecVersion, this.specVersion));
                    } else if (newSpecAV.getMajorVersion() - specAV.getMajorVersion() > 1 || newSpecAV.getMinorVersion() - specAV.getMinorVersion() > 1) {
                        this.errors.add(String.format("WARNING offset between new-spec-version (%s) and spec-version (%s) can't be greater than 1", this.newSpecVersion, this.specVersion));
                    }
                }
            } else if (!(this.specImplVersion.equals(this.specVersion) || this.specImplVersion.startsWith(this.specVersion + ".") || this.specImplVersion.startsWith(this.specVersion + "-"))) {
                this.errors.add(String.format("WARNING: spec-impl-version (%s) must start with JCP spec-version number (%s)", this.specImplVersion, this.specVersion));
            }
        } else {
            if (this.artifact.getGroupId().startsWith("javax.")) {
                this.errors.add(String.format("WARNING: groupId (%s) should not start with \"javax.\"", this.artifact.getGroupId()));
            }
            if (this.artifact.getArtifactId().endsWith(API_SUFFIX)) {
                this.errors.add(String.format("WARNING: artifactId (%s) should not end with %s", this.artifact.getArtifactId(), API_SUFFIX));
            }
            if (!this.getMetadata().getJarExtensionName().equals(this.apiPackage)) {
                this.errors.add(String.format("WARNING: %s (%s) should be %s", "Extension-Name", this.getMetadata().getJarExtensionName(), this.apiPackage));
            }
            if (!this.apiPackage.startsWith("javax.")) {
                this.errors.add(String.format("WARNING: API packages (%s) must start with \"javax\"", this.apiPackage));
            }
            symbolicName = this.implNamespace + '.' + this.apiPackage;
            if (!this.getMetadata().getBundleSymbolicName().equals(symbolicName)) {
                this.errors.add(String.format("WARNING: %s (%s) should be %s", "Bundle-SymbolicName", this.getMetadata().getBundleSymbolicName(), symbolicName));
            }
            if (this.jar != null) {
                this.checkClasses(this.jar, this.apiPackage, this.implNamespace);
            }
            if (this.nonFinal) {
                if (this.implVersion.equals(this.newImplVersion)) {
                    this.errors.add(String.format("WARNING: impl-version (%s) can't be equal to new-impl-version (%s) for non final artifacts", this.implVersion, this.newImplVersion));
                } else {
                    DefaultArtifactVersion implAV = new DefaultArtifactVersion(this.implVersion);
                    DefaultArtifactVersion newImplAV = new DefaultArtifactVersion(this.newImplVersion);
                    if (implAV.compareTo((Object)newImplAV) > 0) {
                        this.errors.add(String.format("WARNING: new-impl-version (%s) must be greater than impl-version (%s)", this.newImplVersion, this.implVersion));
                    } else if (newImplAV.getMajorVersion() - implAV.getMajorVersion() > 1 || newImplAV.getMinorVersion() - implAV.getMinorVersion() > 1) {
                        this.errors.add(String.format("WARNING: offset between new-impl-version (%s) and impl-version (%s) can't be greater than 1", this.newImplVersion, this.implVersion));
                    }
                }
            }
        }
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Metadata getMetadata() {
        if (this.metadata != null) {
            return this.metadata;
        }
        if (this.jarType.equals((Object)JarType.api)) {
            if (!this.nonFinal) {
                this.metadata = new Metadata(this.apiPackage + API_SUFFIX, this.specVersion, this.specImplVersion, this.apiPackage, this.specVersion, this.specImplVersion);
            } else {
                String osgiVersion = this.specVersion + NONFINAL_BUILD_SEPARATOR + this.specBuild;
                this.metadata = new Metadata(this.apiPackage + API_SUFFIX, osgiVersion, osgiVersion, this.apiPackage, this.specVersion + NONFINAL_BUILD_SEPARATOR_SPEC + this.specBuild, this.artifact.getVersion().toString());
            }
        } else {
            String symbolicName = this.implNamespace + "." + this.apiPackage;
            if (!this.nonFinal) {
                this.metadata = new Metadata(symbolicName, this.specVersion, this.implVersion, this.apiPackage, this.specVersion, this.artifact.getVersion().toString());
            } else {
                DefaultArtifactVersion implAv = new DefaultArtifactVersion(this.implVersion);
                this.metadata = new Metadata(symbolicName, this.specVersion + NONFINAL_BUILD_SEPARATOR + this.implBuild, implAv.getMajorVersion() + "." + implAv.getMinorVersion() + NONFINAL_BUILD_SEPARATOR + this.implBuild, this.apiPackage, this.specVersion + NONFINAL_BUILD_SEPARATOR_SPEC + this.implBuild, this.artifact.getVersion().toString());
            }
        }
        return this.metadata;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setApiPackage(String apiPackage) {
        this.apiPackage = apiPackage != null ? apiPackage : "";
    }

    public void setImplNamespace(String implNamespace) {
        this.implNamespace = implNamespace != null ? implNamespace : "";
    }

    public void setImplVersion(String implVersion) {
        this.implVersion = implVersion != null ? implVersion : "";
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion != null ? specVersion : "";
    }

    public void setNewImplVersion(String newImplVersion) {
        this.newImplVersion = newImplVersion != null ? newImplVersion : "";
    }

    public void setSpecBuild(String specBuild) {
        this.specBuild = specBuild != null ? specBuild : "";
    }

    public void setSpecImplVersion(String specImplVersion) {
        this.specImplVersion = specImplVersion != null ? specImplVersion : "";
    }

    public void setNewSpecVersion(String newSpecVersion) {
        this.newSpecVersion = newSpecVersion != null ? newSpecVersion : "";
    }

    public void setImplBuild(String implBuild) {
        this.implBuild = implBuild != null ? implBuild : "";
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public void setNonFinal(boolean nonFinal) {
        this.nonFinal = nonFinal;
    }

    public void setJarType(String jarType) {
        this.jarType = JarType.valueOf(jarType);
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.jarType == null) {
            return sb.toString();
        }
        sb.append("{");
        if (this.specVersion != null && !this.specVersion.isEmpty()) {
            sb.append(" spec-version=");
            sb.append(this.specVersion);
        }
        if (this.apiPackage != null && !this.apiPackage.isEmpty()) {
            sb.append(" apiPackage=");
            sb.append(this.apiPackage);
        }
        if (this.jarType.equals((Object)JarType.impl)) {
            sb.append(" standalone-impl");
            sb.append(" impl-namespace=");
            sb.append(this.implNamespace);
            if (this.nonFinal) {
                sb.append(" non-final");
                sb.append(" new-spec-version=");
                sb.append(this.newSpecVersion);
                sb.append(" new-impl-version=");
                sb.append(this.newSpecVersion);
                sb.append(" impl-build=");
                sb.append(this.implBuild);
            } else {
                sb.append(" final");
            }
            sb.append(" impl-version=");
            sb.append(this.implVersion);
        } else {
            sb.append(" API");
            if (this.nonFinal) {
                sb.append(" non-final");
                sb.append(" new-spec-version=");
                sb.append(this.newSpecVersion);
                sb.append(" spec-build=");
                sb.append(this.specBuild);
            } else {
                sb.append(" final");
                sb.append(" spec-impl-version=");
                sb.append(this.specImplVersion);
            }
        }
        sb.append(" }");
        return sb.toString();
    }

    public static enum JarType {
        api,
        impl;

    }
}

