/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.spec;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public final class Artifact {
    private String groupId;
    private String artifactId;
    private ArtifactVersion version;
    private static final String SNAPSHOT_QUALIFIER = "-SNAPSHOT";
    private static final String M_QUALIFIER = "-M";
    private static final String RC_QUALIFIER = "-RC";

    public static String stripApprovedQualifier(String version) {
        if (version == null) {
            return null;
        }
        if (version.endsWith(SNAPSHOT_QUALIFIER)) {
            return version.replace(SNAPSHOT_QUALIFIER, "");
        }
        if (version.contains(M_QUALIFIER)) {
            return version.substring(0, version.indexOf(M_QUALIFIER));
        }
        if (version.contains(RC_QUALIFIER)) {
            return version.substring(0, version.indexOf(RC_QUALIFIER));
        }
        return version;
    }

    public Artifact() {
    }

    public Artifact(String gId, String aId, String v) {
        this.groupId = gId;
        this.artifactId = aId;
        this.version = new DefaultArtifactVersion(v);
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public ArtifactVersion getVersion() {
        return this.version;
    }

    public String getAbsoluteVersion() {
        return Artifact.stripApprovedQualifier(this.version.toString());
    }

    public void setArtifactId(String aId) {
        this.artifactId = aId;
    }

    public void setGroupId(String gId) {
        this.groupId = gId;
    }

    public void setVersion(String v) {
        this.version = new DefaultArtifactVersion(v);
    }

    private static ZipEntry getPomPropertiesFile(JarFile jar) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith("pom.properties")) continue;
            return entry;
        }
        return null;
    }

    public static Artifact fromJar(JarFile jar) throws IOException {
        ZipEntry entry = Artifact.getPomPropertiesFile(jar);
        if (entry == null) {
            throw new RuntimeException("unable to find pom.properties files inside " + jar.getName());
        }
        InputStream is = jar.getInputStream(entry);
        Properties pomProps = new Properties();
        pomProps.load(is);
        return new Artifact(pomProps.getProperty("groupId"), pomProps.getProperty("artifactId"), pomProps.getProperty("version"));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        sb.append(this.groupId);
        sb.append(':');
        sb.append(this.artifactId);
        sb.append(':');
        sb.append(this.version);
        sb.append(" ]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Artifact other = (Artifact)obj;
        if (this.groupId == null && other.groupId != null) {
            return false;
        }
        if (this.groupId != null && !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.artifactId == null && other.artifactId != null) {
            return false;
        }
        if (this.artifactId != null && !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.version == null && other.version != null) {
            return false;
        }
        return this.version == null || this.version.equals(other.version);
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (this.groupId != null ? this.groupId.hashCode() : 0);
        hash = 71 * hash + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        hash = 71 * hash + (this.version != null ? this.version.hashCode() : 0);
        return hash;
    }
}

