/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.spec.maven;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.JarFile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.glassfish.spec.Artifact;
import org.glassfish.spec.Spec;

@Mojo(name="cli", requiresProject=true, defaultPhase=LifecyclePhase.VALIDATE)
public final class CommandLineMojo
extends AbstractMojo {
    @Parameter(property="isFinal", defaultValue="false")
    private boolean isFinal;
    @Parameter(property="isApi", defaultValue="true")
    private String jarType;
    @Parameter(property="apijar")
    private String apiJar;
    @Parameter(property="impljar")
    private String implJar;
    @Parameter(property="implnamespace")
    private String implNamespace;
    @Parameter(property="specMode", defaultValue="jakarta")
    private String specMode;
    @Parameter(property="apipackage")
    private String apiPackage;
    @Parameter(property="specversion")
    private String specVersion;
    @Parameter(property="specimplversion")
    private String specImplVersion;
    @Parameter(property="implversion")
    private String implVersion;
    @Parameter(property="newimplversion")
    private String newImplVersion;
    @Parameter(property="newspecversion")
    private String newSpecVersion;
    @Parameter(property="specbuild")
    private String specBuild;
    @Parameter(property="implbuild")
    private String implBuild;
    @Parameter(property="properties")
    private File properties;
    @Parameter(property="help", defaultValue="true")
    private boolean help;
    private static Console cons;

    private static String prompt(String msg) {
        if (cons == null) {
            return null;
        }
        String s = cons.readLine("%s: ", msg);
        if (s == null || s.length() == 0) {
            return null;
        }
        return s;
    }

    private static void fail(String msg) {
        System.err.println("ERROR: " + msg);
        System.exit(1);
    }

    private static void printParam(String arg, String desc) {
        StringBuilder sb = new StringBuilder("\t-D");
        System.out.println(sb.append(arg).append(' ').append(desc).toString());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.help) {
            CommandLineMojo.printParam("help", "\t\t\tprint usage (this message)");
            CommandLineMojo.printParam("properties", "file\tread settings from property file");
            CommandLineMojo.printParam("nonfinal", "\t\tnon-final specification");
            CommandLineMojo.printParam("standalone", "\t\tAPI has a standalone implementation");
            CommandLineMojo.printParam("apijar", "api.jar\tAPI jar file");
            CommandLineMojo.printParam("impljar", "impl.jar\timplementation jar file");
            CommandLineMojo.printParam("apipackage", "package\tAPI package");
            CommandLineMojo.printParam("implpackage", "package\timplementation package");
            CommandLineMojo.printParam("specversion", "version\tversion number of the JCP specification");
            CommandLineMojo.printParam("specimplversion", "vers\tversion number of the API classes");
            CommandLineMojo.printParam("implversion", "version\tversion number of the implementation");
            CommandLineMojo.printParam("newspecversion", "vers\tversion number of the spec under development");
            CommandLineMojo.printParam("specbuild", "num\t\tbuild number of spec API jar file");
            CommandLineMojo.printParam("newimplversion", "vers\tversion number of the implementation when final");
            CommandLineMojo.printParam("implbuild", "num\t\tbuild number of implementation jar file");
            CommandLineMojo.printParam("specMode", "specMode\t'javaee' or 'jakarta'");
            return;
        }
        Artifact artifact = null;
        if (this.properties != null) {
            FileInputStream fis = null;
            try {
                JarFile jar;
                Properties p = new Properties();
                fis = new FileInputStream(this.properties);
                p.load(fis);
                fis.close();
                this.specMode = p.getProperty("SPEC_MODE", this.specMode);
                this.apiPackage = p.getProperty("API_PACKAGE", this.apiPackage);
                this.implNamespace = p.getProperty("IMPL_NAMESPACE", this.implNamespace);
                this.jarType = p.getProperty("JAR_TYPE", this.jarType);
                if (this.jarType.equals(Spec.JarType.impl.toString())) {
                    this.implVersion = p.getProperty("SPEC_IMPL_VERSION", this.implVersion);
                    this.specBuild = p.getProperty("SPEC_BUILD", this.specBuild);
                    this.newSpecVersion = p.getProperty("NEW_SPEC_VERSION", this.newSpecVersion);
                    this.apiJar = p.getProperty("API_JAR", this.apiJar);
                    jar = new JarFile(this.apiJar);
                    try {
                        artifact = Artifact.fromJar(jar);
                    }
                    finally {
                        jar.close();
                    }
                }
                this.implVersion = p.getProperty("IMPL_VERSION", this.implVersion);
                this.implBuild = p.getProperty("IMPL_BUILD", this.implBuild);
                this.newImplVersion = p.getProperty("NEW_IMPL_VERSION", this.newImplVersion);
                this.implJar = p.getProperty("IMPL_JAR", this.implJar);
                jar = new JarFile(this.implJar);
                try {
                    artifact = Artifact.fromJar(jar);
                }
                finally {
                    jar.close();
                }
                this.specVersion = p.getProperty("SPEC_VERSION", this.specVersion);
                this.isFinal = this.newSpecVersion == null;
            }
            catch (FileNotFoundException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    this.getLog().warn((CharSequence)ex.getMessage());
                }
            }
        }
        if (this.jarType.equals(Spec.JarType.impl.toString())) {
            if (this.implJar != null) {
                CommandLineMojo.fail("--impljar must not be specified if no standalone implementation");
            }
            if (this.implNamespace != null) {
                CommandLineMojo.fail("--implpackage must not be specified if no standalone implementation");
            }
            if (this.implVersion != null) {
                CommandLineMojo.fail("--implversion must not be specified if no standalone implementation");
            }
            if (this.newImplVersion != null) {
                CommandLineMojo.fail("--newimplversion must not be specified if no standalone implementation");
            }
        }
        if (this.isFinal) {
            if (this.newSpecVersion != null) {
                CommandLineMojo.fail("--newspecversion must not be specified for final specification");
            }
            if (this.specBuild != null) {
                CommandLineMojo.fail("--specbuild must not be specified for final specification");
            }
            if (this.newImplVersion != null) {
                CommandLineMojo.fail("--newimplversion must not be specified for final specification");
            }
            if (this.implBuild != null) {
                CommandLineMojo.fail("--implbuild must not be specified for final specification");
            }
        }
        if (this.properties == null && this.apiJar == null && this.implJar == null && this.implNamespace == null && this.apiPackage == null && this.specVersion == null && this.specImplVersion == null && this.implVersion == null && this.newImplVersion == null && this.newSpecVersion == null && this.specBuild == null && this.implBuild == null) {
            cons = System.console();
            String s = CommandLineMojo.prompt("Is this a non-final specification?");
            this.isFinal = s.charAt(0) != 'y';
            s = CommandLineMojo.prompt("Is there a standalone implementation of this specification?");
            this.jarType = s.charAt(0) != 'y' ? Spec.JarType.impl.name() : Spec.JarType.api.name();
            this.specMode = CommandLineMojo.prompt("Enter the spec mode ('javaee' or 'jakarta')");
            this.apiPackage = CommandLineMojo.prompt("Enter the main API package (e.g., javax.wombat)");
            this.specVersion = CommandLineMojo.prompt("Enter the version number of the JCP specification");
            if (this.jarType.equals(Spec.JarType.impl.toString())) {
                this.specImplVersion = CommandLineMojo.prompt("Enter the version number of the API jar file");
                this.newSpecVersion = CommandLineMojo.prompt("Enter the version number of the implementation that will be used when the implementation is final");
                if (!this.isFinal) {
                    this.specBuild = CommandLineMojo.prompt("Enter the build number of the implementation jar file");
                }
                artifact = new Artifact(this.apiPackage, this.apiPackage + "-api", this.newSpecVersion);
            } else {
                this.implNamespace = CommandLineMojo.prompt("Enter the main implementation package (e.g., com.sun.wombat)");
                if (!this.isFinal) {
                    this.implBuild = CommandLineMojo.prompt("Enter the build number of the implementation jar file");
                }
                this.newImplVersion = CommandLineMojo.prompt("Enter the version number of the Impl jar file");
                artifact = new Artifact(this.implNamespace, this.apiPackage, this.newImplVersion);
            }
        }
        Spec spec = new Spec();
        spec.setSpecMode(this.specMode);
        spec.setArtifact(artifact);
        spec.setSpecVersion(this.specVersion);
        spec.setNewSpecVersion(this.newSpecVersion);
        spec.setSpecImplVersion(this.specImplVersion);
        spec.setImplVersion(this.implVersion);
        spec.setSpecBuild(this.specBuild);
        spec.setImplBuild(this.implBuild);
        spec.setApiPackage(this.apiPackage);
        spec.setImplNamespace(this.implNamespace);
        spec.setJarType(this.jarType);
        spec.setNonFinal(!this.isFinal);
        spec.verify();
        for (String error : spec.getErrors()) {
            System.out.println(error);
        }
    }
}

