/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.logging;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.admin.amx.logging.LogQueryEntry;
import org.glassfish.admin.amx.util.ArrayUtil;
import org.glassfish.admin.amx.util.ObjectUtil;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.EXPERIMENTAL)
public final class LogQueryEntryImpl
implements LogQueryEntry {
    private transient Map<String, String> mNameValuePairsMap;
    final long mRecordNumber;
    final Date mDate;
    final String mLevel;
    final String mProductName;
    final String mMessage;
    final String mMessageID;
    final String mModule;
    final String mNameValuePairs;
    private static final String NVP_PAIRS_DELIM = ";";
    private static final String PAIR_DELIM = "=";

    public LogQueryEntryImpl(long recordNumber, Date date, String level, String productName, String module, String nameValuePairs, String messageID, String message) {
        if (date == null || level == null || message == null || nameValuePairs == null) {
            throw new IllegalArgumentException();
        }
        this.mRecordNumber = recordNumber;
        this.mDate = date;
        this.mLevel = Level.parse(level).toString();
        this.mProductName = productName;
        this.mModule = module;
        this.mMessage = message;
        this.mMessageID = messageID;
        this.mNameValuePairs = nameValuePairs;
    }

    public LogQueryEntryImpl(Object[] values) {
        if (values.length != 8) {
            throw new IllegalArgumentException("wrong number of fields: " + values.length);
        }
        this.mRecordNumber = (Long)values[0];
        this.mDate = (Date)values[1];
        this.mLevel = Level.parse((String)values[2]).toString();
        this.mProductName = (String)values[3];
        this.mMessageID = (String)values[6];
        this.mModule = (String)values[4];
        this.mMessage = (String)values[7];
        this.mNameValuePairs = (String)values[5];
    }

    @Override
    public Object[] getFields() {
        Object[] fields = new Object[8];
        fields[0] = this.mRecordNumber;
        fields[1] = this.mDate;
        fields[2] = this.mLevel;
        fields[3] = this.mProductName;
        fields[6] = this.mMessageID;
        fields[4] = this.mModule;
        fields[7] = this.mMessage;
        fields[5] = this.mNameValuePairs;
        return fields;
    }

    @Override
    public long getRecordNumber() {
        return this.mRecordNumber;
    }

    @Override
    public Date getDate() {
        return this.mDate;
    }

    @Override
    public String getModule() {
        return this.mModule;
    }

    @Override
    public String getLevel() {
        return this.mLevel;
    }

    @Override
    public String getProductName() {
        return this.mProductName;
    }

    @Override
    public String getMessage() {
        return this.mMessage;
    }

    @Override
    public String getMessageID() {
        return this.mMessageID;
    }

    @Override
    public String getNameValuePairs() {
        return this.mNameValuePairs;
    }

    private Map<String, String> parseNameValuePairs() {
        String[] pairs;
        String src = this.getNameValuePairs();
        HashMap<String, String> m = new HashMap<String, String>();
        for (String pair : pairs = src.split(NVP_PAIRS_DELIM)) {
            int idx = pair.indexOf(PAIR_DELIM);
            if (idx < 0) {
                throw new IllegalArgumentException(src);
            }
            String name = pair.substring(0, idx).trim();
            String value = pair.substring(idx + 1, pair.length()).trim();
            m.put(name, value);
        }
        return m;
    }

    @Override
    public Map<String, String> getNameValuePairsMap() {
        if (this.mNameValuePairsMap == null) {
            this.mNameValuePairsMap = this.parseNameValuePairs();
        }
        return this.mNameValuePairsMap;
    }

    @Override
    public String getThreadID() {
        return this.getNameValuePairsMap().get("_ThreadID");
    }

    public String getObjectName() {
        return this.getNameValuePairsMap().get("_ObjectName");
    }

    public String toString() {
        String D = "|";
        return "[#" + this.getRecordNumber() + "|" + this.getDate() + "|" + this.getLevel() + "|" + this.getProductName() + "|" + this.getModule() + "|" + this.getNameValuePairs() + "|" + this.getMessage() + "|" + this.getMessageID() + "|" + "]";
    }

    public int hashCode() {
        return ObjectUtil.hashCode(this.mDate, this.mLevel, this.mProductName, this.mMessage, this.mMessageID, this.mModule, this.mNameValuePairs) ^ ObjectUtil.hashCode(this.mRecordNumber);
    }

    public boolean equals(Object rhs) {
        boolean equal = false;
        if (this == rhs) {
            equal = true;
        } else if (rhs instanceof LogQueryEntry) {
            LogQueryEntry e = (LogQueryEntry)rhs;
            equal = ArrayUtil.arraysEqual(this.getFields(), e.getFields());
        }
        return equal;
    }
}

