/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.appserv.server.util;

import org.glassfish.api.branding.Branding;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.component.PostConstruct;

/**
*
* This class provides static methods to make accessable the version 
* as well as the individual parts that make up the version
*
*/
@Service
@Scoped(Singleton.class)
public class Version implements PostConstruct {

    /**
     * version strings populated during build
     */
    private static final String product_name          = "GlassFish Server Open Source Edition";
    private static final String abbrev_product_name   = "glassfish";
    private static String full_version                = "3.1-b41";
    private static final String major_version         = "3";
    private static final String minor_version         = "1"; 
    private static final String update_version        = ""; 
    private static final String build_id              = "java_re-private";
    private static final String version_prefix        = "";
    private static final String version_suffix        = "";

    /**
     * Check if Branding implementation exists and set the value for
     * Branding interface variable
     */
    private static Branding br = null;

    @Inject
    private static Habitat mHabitat;

    public static void setBranding(Branding b) {
        // clients without HK2 can do it themselves.
        br = b;
    }

    public void postConstruct() {
        if (br == null) {
            if (mHabitat != null) {
                br = mHabitat.getByContract(Branding.class);
            }
        }

        // construct full version
        if ((minor_version != null) && (minor_version.length() > 0)) {
            try {
                if (Integer.parseInt(minor_version) > 0) {
                    if (update_version.length() > 0) {
                        if (Integer.parseInt(update_version) > 0) {
                            full_version = major_version + "." + minor_version
                                + "." + update_version;
                        }
                    }
                    else {
                        full_version = major_version + "." + minor_version;
                    }
                } else {
                    if (update_version.length() > 0) {
                        if (Integer.parseInt(update_version) > 0) {
                            full_version = major_version + "." + minor_version
                                + "." + update_version;
                        }
                    }
                    else {
                        full_version = major_version;
                    }
                }

            } catch (NumberFormatException nfe) {
                    full_version = major_version;
            }
        }
    }


    /**
    * Returns version
    */ 
    public static String getVersion() {
        if (br != null) {
            return br.getVersion();
        }
        if (product_name == null)
            return null;

        StringBuffer sb = new StringBuffer(product_name);
        if (ok(version_prefix))
            sb.append(" ").append(version_prefix);
        if (full_version != null) 
            sb.append(" ").append(full_version);
        if (ok(version_suffix))
            sb.append(" ").append(version_suffix);
        return sb.toString();
    }

    /**
    * Returns full version including build id
    */
    public static String getFullVersion() {
        if (br != null) {
            return br.getFullVersion();
        }
        return (getVersion() + " (build " + build_id + ")");
    }

    /**
    * Returns abbreviated version.
    */
    public static String getAbbreviatedVersion() {
        if (br != null) {
            return br.getAbbreviatedVersion();
        }
        return abbrev_product_name;
    }

    /**
    * Returns Major version
    */ 
    public static String getMajorVersion() {
        if (br != null) {
            return br.getMajorVersion();
        }
    	return major_version;
    }

    /**
    * Returns Minor version
    */ 
    public static String getMinorVersion() {
        if (br != null) {
            return br.getMinorVersion();
        }
    	return minor_version;
    }

    /**
    * Returns Update version
    */
    public static String getUpdateVersion() {
        if (br != null) {
            return br.getUpdateVersion();
        }
        return update_version;
    }

    /**
    * Returns Build version
    */ 
    public static String getBuildVersion() {
        if (br != null) {
            return br.getBuildVersion();
        }
    	return build_id;
    }

    /**
    * Returns version prefix
    */ 
    public static String getVersionPrefix() {
        if (br != null) {
            return br.getVersionPrefix();
        }
    	return version_prefix;
    }

    /**
    * Returns version suffix
    */ 
    public static String getVersionSuffix() {
        if (br != null) {
            return br.getVersionSuffix();
        }
    	return version_suffix;
    }

    /**
    * Returns Proper Product Name
    */
    public static String getProductName() {
        if (br != null) {
            return br.getProductName();
        }
    	return product_name;
    }

    /**
    * Returns Abbreviated Product Name
    */
    public static String getAbbrevProductName() {
        if (br != null) {
            return br.getAbbrevProductName();
        }
    	return abbrev_product_name;
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

}
