/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.copyright;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import org.glassfish.copyright.AbstractCopyright;
import org.glassfish.copyright.Copyright;

public abstract class CommonCopyright
extends AbstractCopyright {
    protected String commentStart;
    protected String commentEnd;
    protected String commentPrefix;
    protected boolean blankLines = true;
    protected boolean movePreamble = false;

    public CommonCopyright(Copyright c) {
        super(c);
    }

    @Override
    protected String readComment(BufferedReader r) throws IOException {
        int len;
        String line;
        StringBuilder comment = new StringBuilder();
        while ((line = r.readLine()) != null && (this.isPreamble(line = CommonCopyright.strip(line)) || line.length() == 0)) {
        }
        if (!this.isCommentStart(line)) {
            return null;
        }
        String prefix = null;
        while ((line = r.readLine()) != null) {
            if (line.indexOf("/*") >= 0) continue;
            if (prefix == null) {
                if (line.length() == 0) continue;
                prefix = CommonCopyright.findPrefix(line);
            }
            if (this.isCommentEnd(line) || line.indexOf("*/") >= 0) break;
            if (line.length() >= prefix.length()) {
                if (line.startsWith(prefix)) {
                    line = line.substring(prefix.length());
                }
            } else if (prefix.startsWith(line)) {
                line = "";
            }
            comment.append(CommonCopyright.strip(line)).append('\n');
        }
        if ((len = comment.length()) >= 2 && comment.charAt(len - 1) == '\n' && comment.charAt(len - 2) == '\n') {
            comment.setLength(len - 1);
        }
        return comment.toString();
    }

    protected boolean isPreamble(String line) {
        return false;
    }

    protected boolean isCommentStart(String line) {
        return line != null && line.indexOf(this.commentStart) >= 0;
    }

    protected boolean isCommentEnd(String line) {
        return line.indexOf(this.commentEnd.trim()) >= 0;
    }

    protected String commentTrailer(String line) {
        int i = line.indexOf(this.commentEnd.trim());
        if (i >= 0) {
            return line.substring(i += this.commentEnd.trim().length()).trim();
        }
        return "";
    }

    @Override
    protected void replaceCopyright(BufferedReader in, BufferedWriter out, String comment, String lastChanged) throws IOException {
        String line;
        StringBuilder header = new StringBuilder();
        while ((line = in.readLine()) != null) {
            if (this.isPreamble(line = CommonCopyright.strip(line))) {
                header.append(line).append('\n');
                continue;
            }
            if (line.length() == 0) continue;
        }
        if (header.length() > 0 && !this.movePreamble) {
            out.write(header.toString());
        }
        if (comment != null && this.isCommentStart(line)) {
            boolean sawCopyright = false;
            String trailer = "";
            while ((line = in.readLine()) != null) {
                Matcher m;
                if (!sawCopyright && line.indexOf("Copyright") >= 0 && (m = ypat.matcher(line)).find()) {
                    lastChanged = this.addCopyrightDate(m.group(2), lastChanged);
                    sawCopyright = true;
                }
                if (!this.isCommentEnd(line)) continue;
                trailer = this.commentTrailer(line);
                break;
            }
            this.writeCopyright(out, lastChanged, comment);
            out.write(trailer);
            out.write("\n\n");
            if (header.length() > 0 && this.movePreamble) {
                out.write(header.toString());
                out.write(10);
            }
        } else {
            this.writeCopyright(out, lastChanged, comment);
            out.write("\n\n");
            if (header.length() > 0 && this.movePreamble) {
                out.write(header.toString());
                out.write(10);
            }
            if (line != null) {
                out.write(line);
            }
            out.write(10);
            this.copy(in, out, false);
        }
    }

    @Override
    protected void updateCopyright(BufferedReader in, BufferedWriter out, String lastChanged) throws IOException {
        String line;
        StringBuilder header = new StringBuilder();
        while ((line = in.readLine()) != null) {
            if (this.isPreamble(line = CommonCopyright.strip(line))) {
                header.append(line).append('\n');
                continue;
            }
            if (line.length() == 0) continue;
        }
        if (line == null) {
            throw new IOException("NO CONTENT, repair failed");
        }
        if (header.length() > 0) {
            out.write(header.toString());
        }
        out.write(line);
        out.write(10);
        if (this.isCommentStart(line)) {
            boolean updated = false;
            while ((line = in.readLine()) != null) {
                Matcher m;
                if (!updated && line.indexOf("Copyright") >= 0 && (m = ypat.matcher(line)).find()) {
                    String y = this.addCopyrightDate(m.group(2), lastChanged);
                    line = line.substring(0, m.start(2)) + y + line.substring(m.end(2));
                    updated = true;
                }
                out.write(line);
                out.write(10);
                if (!this.isCommentEnd(line)) continue;
            }
            out.write(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String toComment(String comment) {
        BufferedReader r = new BufferedReader(new StringReader(comment));
        StringBuilder out = new StringBuilder();
        try {
            String line;
            out.append(this.commentStart).append("\n");
            if (this.blankLines) {
                out.append(CommonCopyright.strip(this.commentPrefix)).append("\n");
            }
            while ((line = r.readLine()) != null) {
                out.append(CommonCopyright.strip(this.commentPrefix + line)).append('\n');
            }
            if (this.blankLines) {
                out.append(CommonCopyright.strip(this.commentPrefix)).append("\n");
            }
            out.append(this.commentEnd);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
        return out.toString();
    }
}

