/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.copyright;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import org.glassfish.copyright.AbstractCopyright;
import org.glassfish.copyright.CRLFWriter;
import org.glassfish.copyright.Copyright;

public class BatCopyright
extends AbstractCopyright {
    public BatCopyright(Copyright c) {
        super(c);
    }

    @Override
    protected boolean supports(File file) {
        return file.getName().endsWith(".bat");
    }

    @Override
    protected String readComment(BufferedReader r) throws IOException {
        int len;
        String line;
        StringBuilder comment = new StringBuilder();
        while ((line = r.readLine()) != null && ((line = BatCopyright.strip(line)).startsWith("@echo") || line.equals("REM") || line.length() == 0)) {
        }
        if (line == null || !line.startsWith("REM")) {
            return null;
        }
        String prefix = "REM  ";
        while (line.length() != 0 && line.startsWith("REM")) {
            if (line.length() >= prefix.length()) {
                if (line.startsWith(prefix)) {
                    line = line.substring(prefix.length());
                }
            } else if (prefix.startsWith(line)) {
                line = "";
            }
            comment.append(BatCopyright.strip(line)).append('\n');
            line = r.readLine();
            if (line != null) continue;
        }
        if ((len = comment.length()) >= 2 && comment.charAt(len - 1) == '\n' && comment.charAt(len - 2) == '\n') {
            comment.setLength(len - 1);
        }
        return comment.toString();
    }

    @Override
    protected void replaceCopyright(BufferedReader in, BufferedWriter out, String comment, String lastChanged) throws IOException {
        String line;
        out = new BufferedWriter(new CRLFWriter(out));
        StringBuilder header = new StringBuilder();
        while ((line = in.readLine()) != null) {
            if ((line = BatCopyright.strip(line)).startsWith("@echo")) {
                header.append(line).append('\n');
                continue;
            }
            if (comment != null && line.equals("REM") || line.length() == 0) continue;
        }
        if (header.length() > 0) {
            out.write(header.toString());
        }
        if (comment != null && line != null && line.startsWith("REM")) {
            boolean sawCopyright = false;
            while (line.length() != 0 && line.startsWith("REM")) {
                Matcher m;
                if (!sawCopyright && line.indexOf("Copyright") >= 0 && (m = ypat.matcher(line)).find()) {
                    lastChanged = this.addCopyrightDate(m.group(3), lastChanged);
                    sawCopyright = true;
                }
                if ((line = in.readLine()) != null) continue;
            }
        }
        this.writeCopyright(out, lastChanged, comment);
        if (line != null) {
            if (line.length() > 0) {
                out.write(line);
                out.write(10);
            }
            this.copy(in, out, false);
        }
        out.flush();
    }

    @Override
    protected void updateCopyright(BufferedReader in, BufferedWriter out, String lastChanged) throws IOException {
        String line;
        out = new BufferedWriter(new CRLFWriter(out));
        StringBuilder header = new StringBuilder();
        while ((line = in.readLine()) != null) {
            if ((line = BatCopyright.strip(line)).startsWith("@echo")) {
                header.append(line).append('\n');
                continue;
            }
            if (line.equals("REM") || line.length() == 0) continue;
        }
        if (line == null) {
            throw new IOException("NO CONTENT, repair failed");
        }
        if (header.length() > 0) {
            out.write(header.toString());
        }
        out.write(line);
        out.write(10);
        if (line.startsWith("REM")) {
            boolean updated = false;
            do {
                Matcher m;
                if (!updated && line.indexOf("Copyright") >= 0 && (m = ypat.matcher(line)).find()) {
                    String y = this.addCopyrightDate(m.group(3), lastChanged);
                    line = line.substring(0, m.start(3)) + y + line.substring(m.end(3));
                    updated = true;
                }
                out.write(line);
                out.write(10);
            } while (line.length() != 0 && line.startsWith("REM") && (line = in.readLine()) != null);
        }
        if (line != null) {
            out.write(line);
            out.write(10);
            this.copy(in, out, false);
        }
        out.flush();
    }

    @Override
    protected String guessLineTerminator(Reader in) {
        return "\r\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String toComment(String comment) {
        BufferedReader r = new BufferedReader(new StringReader(comment));
        StringBuilder out = new StringBuilder();
        try {
            String line;
            out.append("REM\n");
            while ((line = r.readLine()) != null) {
                out.append(BatCopyright.strip("REM  " + line)).append('\n');
            }
            out.append("REM\n\n");
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
        return out.toString();
    }
}

