/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.doc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="book", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class BookMojo
extends AbstractMojo {
    @Parameter(property="book.startpage", defaultValue="title.adoc")
    protected String startPage;
    @Parameter(property="book.title")
    protected String title;
    @Parameter(property="book.book", defaultValue="book.adoc")
    protected String book;
    @Parameter
    protected List<String> exclude;
    @Parameter(property="book.dir", defaultValue="${project.basedir}/src/main/jbake/content")
    protected File sourceDirectory;
    @Parameter(property="book.attributes", defaultValue="${project.basedir}/src/main/jbake/content/book-attributes.conf")
    protected File attributesFile;
    @Parameter(property="book.outputdir", defaultValue="${project.build.directory}/book")
    protected File bookDirectory;
    protected Log log;
    private String next;
    private String prev;
    private Set<String> seen = new HashSet<String>();

    public void execute() throws MojoExecutionException {
        this.log = this.getLog();
        if (this.exclude == null) {
            this.exclude = new ArrayList<String>();
            this.exclude.add("toc.adoc");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("bookDirectory " + this.bookDirectory));
            this.log.debug((CharSequence)("startPage " + this.startPage));
            this.log.debug((CharSequence)("title " + this.title));
            this.log.debug((CharSequence)("book " + this.book));
            this.log.debug((CharSequence)("exclude " + this.exclude));
        }
        try {
            String line2;
            Object object;
            BufferedReader r;
            if (!this.bookDirectory.exists() && !this.bookDirectory.mkdirs()) {
                this.log.error((CharSequence)String.format("ERROR: can't create output directory %s", this.bookDirectory));
                throw new MojoExecutionException("Can't create output directory");
            }
            if (!this.bookDirectory.isDirectory()) {
                this.log.error((CharSequence)String.format("ERROR: %s is not a directory", this.bookDirectory));
                throw new MojoExecutionException("Book directory is not a directory");
            }
            if (this.title == null) {
                File in = new File(this.sourceDirectory, this.startPage);
                r = new BufferedReader(new FileReader(in));
                object = null;
                try {
                    while ((line2 = r.readLine()) != null) {
                        if (line2.startsWith("~")) {
                        } else {
                            if (!line2.startsWith("title=")) continue;
                            this.title = line2.substring(line2.indexOf("=") + 1);
                        }
                        break;
                    }
                }
                catch (Throwable line2) {
                    object = line2;
                    throw line2;
                }
                finally {
                    if (r != null) {
                        if (object != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable line2) {
                                ((Throwable)object).addSuppressed(line2);
                            }
                        } else {
                            r.close();
                        }
                    }
                }
            }
            PrintWriter tout = new PrintWriter(new File(this.bookDirectory, this.book));
            tout.printf("= %s%n", this.title);
            if (this.attributesFile != null && this.attributesFile.exists()) {
                r = new BufferedReader(new FileReader(this.attributesFile));
                object = null;
                try {
                    while ((line2 = r.readLine()) != null) {
                        tout.println(line2);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (r != null) {
                        if (object != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            r.close();
                        }
                    }
                }
            }
            tout.println();
            this.next = this.startPage;
            do {
                String file;
                if (!this.exclude.contains(file = this.next)) {
                    tout.printf("include::%s[]%n%n", file);
                }
                Object prevfile = null;
                this.seen.add(this.next);
                this.walk(this.next);
                if (this.prev != null && prevfile != null && !this.prev.equals(prevfile)) {
                    this.log.error((CharSequence)String.format("ERROR: prev wrong in %s - is %s, should be %s\n", file, this.prev, prevfile));
                }
                object = file;
            } while (this.next != null);
            for (String name : this.sourceDirectory.list()) {
                if (name.equals("toc.adoc") || name.equals(this.book) || this.seen.contains(name)) continue;
                this.copy(name);
            }
            tout.close();
        }
        catch (IOException ex) {
            this.log.error((Throwable)ex);
        }
    }

    private void walk(String file) throws IOException {
        this.prev = null;
        this.next = null;
        this.title = null;
        File in = new File(this.sourceDirectory, file);
        try (BufferedReader r = new BufferedReader(new FileReader(in));){
            String line;
            while ((line = r.readLine()) != null && !line.startsWith("~")) {
                if (line.startsWith("title=")) {
                    this.title = line.substring(line.indexOf("=") + 1);
                }
                if (line.startsWith("next=")) {
                    this.next = line.substring(line.indexOf("=") + 1).replace(".html", ".adoc");
                }
                if (!line.startsWith("prev=")) continue;
                this.prev = line.substring(line.indexOf("=") + 1).replace(".html", ".adoc");
            }
            if (this.exclude.contains(file)) {
                return;
            }
            File out = new File(this.bookDirectory, file);
            try (PrintWriter w = new PrintWriter(out);){
                boolean first = true;
                while ((line = r.readLine()) != null) {
                    if (first) {
                        String nline;
                        if (line.length() == 0) continue;
                        if (line.startsWith("include::") && line.endsWith("[]")) {
                            w.println(line);
                            continue;
                        }
                        first = false;
                        if (line.startsWith("= ") || (nline = r.readLine()) != null && nline.startsWith("=") && nline.length() == line.length()) continue;
                        w.println(line);
                        line = nline;
                    }
                    w.println(line);
                }
            }
        }
        catch (FileNotFoundException fex) {
            this.log.warn((CharSequence)(in.toString() + ": can not open"));
        }
    }

    private void copy(String file) throws IOException {
        File in = new File(this.sourceDirectory, file);
        File out = new File(this.bookDirectory, file);
        if (in.isDirectory()) {
            return;
        }
        try (BufferedInputStream bin = new BufferedInputStream(new FileInputStream(in));
             BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(out));){
            int n;
            byte[] buf = new byte[16384];
            while ((n = bin.read(buf)) > 0) {
                bout.write(buf, 0, n);
            }
        }
    }
}

