/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.doc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="toc", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class TocMojo
extends AbstractMojo {
    @Parameter(property="toc.titlepage", defaultValue="title.adoc")
    protected String titlePage;
    @Parameter(property="toc.title")
    protected String title;
    @Parameter(property="toc.toc", defaultValue="toc.adoc")
    protected String toc;
    @Parameter(property="toc.chapterpatterns", defaultValue="[0-9]+\\s.*")
    protected String chapterPatterns;
    @Parameter(property="toc.tagpatterns", defaultValue="")
    protected String ignoreTagPatterns;
    @Parameter(defaultValue="${project.basedir}")
    protected File baseDirectory;
    @Parameter(property="toc.dir", defaultValue="${project.basedir}/src/main/jbake/content")
    protected File sourceDirectory;
    @Parameter(property="toc.debug")
    protected boolean debug;
    protected Log log;
    private String next;
    private String prev;
    private PrintWriter tout;
    private Set<String> seen = new HashSet<String>();
    private String[] chapterList;
    private String[] tagList;
    private Pattern tagPattern;
    private String curfile;
    private String lastline;
    private int lineno;
    private static final int HEADER_SLOP = 5;

    public void execute() throws MojoExecutionException {
        this.log = this.getLog();
        this.chapterList = this.chapterPatterns.split(",");
        this.tagPattern = Pattern.compile("\\[\\[([-a-zA-Z0-9]+)]]");
        this.tagList = this.ignoreTagPatterns != null ? this.ignoreTagPatterns.split(",") : new String[0];
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("baseDirectory " + this.baseDirectory));
            this.log.debug((CharSequence)("sourceDirectory " + this.sourceDirectory));
            this.log.debug((CharSequence)("titlePage " + this.titlePage));
            this.log.debug((CharSequence)("title " + this.title));
            this.log.debug((CharSequence)("toc " + this.toc));
            for (String string : this.chapterList) {
                this.log.debug((CharSequence)("chapterPattern " + string));
            }
            for (String string : this.tagList) {
                this.log.debug((CharSequence)("ignoreTagPattern " + string));
            }
        }
        try {
            String includeLine = null;
            File in = new File(this.sourceDirectory, this.titlePage);
            Throwable throwable = null;
            try (BufferedReader r = new BufferedReader(new FileReader(in));){
                String line;
                while ((line = r.readLine()) != null && !line.startsWith("~")) {
                    if (this.title != null || !line.startsWith("title=")) continue;
                    this.title = line.substring(line.indexOf("=") + 1);
                }
                line = r.readLine();
                if (line != null && line.startsWith("include::")) {
                    includeLine = line;
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            this.tout = new PrintWriter(new File(this.sourceDirectory, this.toc));
            this.tout.println("type=page");
            this.tout.println("status=published");
            this.tout.println("title=" + this.title);
            this.tout.println("next=" + this.titlePage.replace(".adoc", ".html"));
            this.tout.println("~~~~~~");
            if (includeLine != null) {
                this.tout.println(includeLine);
            }
            this.tout.println(this.title);
            this.tout.println(TocMojo.headerLine('=', this.title.length()));
            this.tout.println();
            this.tout.println("[[contents]]");
            this.tout.println("Contents");
            this.tout.println("--------");
            this.tout.println();
            this.next = this.titlePage;
            do {
                String file = this.next;
                Object var4_13 = null;
                this.seen.add(this.next);
                this.walk(this.next);
                if (this.prev != null && var4_13 != null && !this.prev.equals(var4_13)) {
                    this.log.error((CharSequence)String.format("ERROR: prev wrong in %s - is %s, should be %s\n", file, this.prev, var4_13));
                }
                String string = file;
            } while (this.next != null);
            for (String name : this.sourceDirectory.list()) {
                if (!name.endsWith(".adoc") || name.equals("cpyr.adoc") || name.equals("toc.adoc") || name.equals(this.toc) || this.seen.contains(name)) continue;
                this.log.warn((CharSequence)("MISSED: " + name));
            }
            this.tout.close();
        }
        catch (IOException ex) {
            this.log.error((Throwable)ex);
        }
    }

    private void walk(String file) throws IOException {
        this.prev = null;
        this.next = null;
        this.title = null;
        this.curfile = file;
        this.lineno = 0;
        File in = new File(this.sourceDirectory, file);
        try (BufferedReader r = new BufferedReader(new FileReader(in));){
            String line;
            while ((line = r.readLine()) != null) {
                ++this.lineno;
                if (line.startsWith("~")) break;
                if (line.startsWith("title=")) {
                    this.title = line.substring(line.indexOf("=") + 1);
                }
                if (line.startsWith("next=")) {
                    this.next = line.substring(line.indexOf("=") + 1).replace(".html", ".adoc");
                }
                if (!line.startsWith("prev=")) continue;
                this.prev = line.substring(line.indexOf("=") + 1).replace(".html", ".adoc");
            }
            this.lastline = "";
            String biglink = "";
            String smalllink = "";
            String link = "";
            boolean seenNonEmpty = false;
            while ((line = r.readLine()) != null) {
                ++this.lineno;
                if (line.startsWith("[[") && line.endsWith("]]")) {
                    Matcher m = this.tagPattern.matcher(line);
                    while (m.find()) {
                        String tag = m.group(1);
                        if (this.ignoreTag(tag)) continue;
                        if (tag.matches("[A-Z0-9]+")) {
                            biglink = tag;
                            seenNonEmpty = false;
                            continue;
                        }
                        if (tag.matches("[a-zA-Z0-9]+")) {
                            smalllink = tag;
                            if (!seenNonEmpty) continue;
                            biglink = "";
                            continue;
                        }
                        link = tag;
                        if (!biglink.isEmpty() || !smalllink.isEmpty()) continue;
                        biglink = tag;
                    }
                } else if (this.lastline.length() >= 3) {
                    if (line.length() >= 5 && this.isHeader(line, "-", this.lastline.length())) {
                        if (biglink.isEmpty()) {
                            biglink = smalllink;
                        }
                        if (this.isChapter(this.lastline)) {
                            this.tout.println();
                            if (!link.isEmpty()) {
                                this.tout.printf("[[%s]]%n", link);
                            }
                            String linkline = String.format("link:%s#%s[%s]", file.replace(".adoc", ".html"), biglink, this.lastline);
                            this.tout.println(linkline);
                            this.tout.println(TocMojo.headerLine('~', linkline.length()));
                            this.tout.println();
                        } else {
                            this.tout.printf("* link:%s#%s[%s]\n", file.replace(".adoc", ".html"), biglink, this.lastline);
                        }
                        link = "";
                        biglink = "";
                        smalllink = "";
                        seenNonEmpty = false;
                    } else if (this.isHeader(line, "~", this.lastline.length())) {
                        if (biglink.isEmpty()) {
                            biglink = smalllink;
                        }
                        this.tout.printf("** link:%s#%s[%s]\n", file.replace(".adoc", ".html"), biglink, this.lastline);
                        link = "";
                        biglink = "";
                        smalllink = "";
                        seenNonEmpty = false;
                    } else if (this.isHeader(line, "\\^", this.lastline.length())) {
                        if (biglink.isEmpty()) {
                            biglink = smalllink;
                        }
                        this.tout.printf("*** link:%s#%s[%s]\n", file.replace(".adoc", ".html"), biglink, this.lastline);
                        link = "";
                        biglink = "";
                        smalllink = "";
                        seenNonEmpty = false;
                    } else if (!line.isEmpty()) {
                        seenNonEmpty = true;
                    }
                }
                this.lastline = line;
            }
        }
        catch (FileNotFoundException fex) {
            this.log.warn((CharSequence)(in.toString() + ": can not open"));
        }
    }

    private boolean ignoreTag(String tag) {
        for (String t : this.tagList) {
            if (!tag.matches(t)) continue;
            return true;
        }
        return false;
    }

    private boolean isHeader(String line, String hchar, int len) {
        if (line.length() == 0) {
            return false;
        }
        if (line.length() == len) {
            return line.matches(hchar + "{" + len + "}");
        }
        if (len > 5 && line.length() >= len - 5 && line.length() <= len + 5 && line.matches(hchar + "{" + (len - 5) + "," + (len + 5 + 1) + "}")) {
            this.log.warn((CharSequence)(this.curfile + ":" + this.lineno + ": header line length mismatch:"));
            this.log.warn((CharSequence)this.lastline);
            this.log.warn((CharSequence)line);
            return true;
        }
        return false;
    }

    private static String headerLine(char hchar, int len) {
        char[] c = new char[len];
        Arrays.fill(c, hchar);
        return new String(c);
    }

    private boolean isChapter(String s) {
        for (String p : this.chapterList) {
            if (!s.matches(p)) continue;
            return true;
        }
        return false;
    }
}

