/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.embed;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.impl.ModulesRegistryImpl;
import com.sun.enterprise.security.SecuritySniffer;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.admin.adapter.AdminConsoleAdapter;
import com.sun.enterprise.v3.data.ApplicationInfo;
import com.sun.enterprise.v3.deployment.DeploymentContextImpl;
import com.sun.enterprise.v3.server.ApplicationLifecycle;
import com.sun.enterprise.v3.server.DomainXml;
import com.sun.enterprise.v3.server.DomainXmlPersistence;
import com.sun.enterprise.v3.server.ServerEnvironment;
import com.sun.enterprise.v3.server.SnifferManager;
import com.sun.enterprise.v3.services.impl.LogManagerService;
import com.sun.enterprise.web.WebDeployer;
import com.sun.hk2.component.InhabitantsParser;
import com.sun.web.security.RealmAdapter;
import com.sun.web.server.DecoratorForJ2EEInstanceListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Startup;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.autodeploy.AutoDeployService;
import org.glassfish.embed.DomBuilder;
import org.glassfish.embed.GFApplication;
import org.glassfish.embed.GFException;
import org.glassfish.embed.GFHttpListener;
import org.glassfish.embed.GFVirtualServer;
import org.glassfish.embed.impl.DomainXml2;
import org.glassfish.embed.impl.DomainXmlHolder;
import org.glassfish.embed.impl.EntityResolverImpl;
import org.glassfish.embed.impl.ProxyModuleDefinition;
import org.glassfish.embed.impl.ScatteredWarHandler;
import org.glassfish.embed.impl.ServerEnvironment2;
import org.glassfish.embed.impl.SilentActionReport;
import org.glassfish.embed.impl.WebDeployer2;
import org.glassfish.internal.api.Init;
import org.glassfish.web.WebEntityResolver;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.Inhabitants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class GlassFish {
    private boolean started;
    protected Habitat habitat;
    private final Document domainXml;
    private final XPath xpath = XPathFactory.newInstance().newXPath();
    protected ApplicationLifecycle appLife;
    protected SnifferManager snifMan;
    protected ArchiveFactory archiveFactory;
    protected ServerEnvironment env;

    public GlassFish() throws GFException {
        try {
            this.domainXml = this.parseDefaultDomainXml();
        }
        catch (IOException e) {
            throw new GFException(e);
        }
        catch (SAXException e) {
            throw new GFException(e);
        }
        catch (ParserConfigurationException e) {
            throw new GFException(e);
        }
    }

    public GlassFish(int httpPort) throws GFException {
        this();
        this.createVirtualServer(this.createHttpListener(httpPort));
        this.start();
    }

    private Document parseDefaultDomainXml() throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        return dbf.newDocumentBuilder().parse(this.getClass().getResource("/org/glassfish/embed/domain.xml").toExternalForm());
    }

    public static void setLogLevel(Level level) {
        Logger.getLogger("javax.enterprise").setLevel(level);
    }

    protected InhabitantsParser decorateInhabitantsParser(InhabitantsParser parser) {
        Inhabitant swh = Inhabitants.create((Object)((Object)new ScatteredWarHandler()));
        parser.habitat.add(swh);
        parser.habitat.addIndex(swh, ArchiveHandler.class.getName(), null);
        parser.drop(LogManagerService.class);
        parser.drop(AdminConsoleAdapter.class);
        parser.drop(AutoDeployService.class);
        parser.replace(DomainXml.class, DomainXml2.class);
        parser.habitat.add(Inhabitants.create((Object)new DomainXmlHolder(this.domainXml)));
        parser.replace(DomainXmlPersistence.class, DomainXml2.class);
        parser.replace(ServerEnvironment.class, ServerEnvironment2.class);
        parser.drop(DecoratorForJ2EEInstanceListener.class);
        try {
            parser.drop(SecuritySniffer.class);
            parser.drop(RealmAdapter.class);
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        parser.replace(WebDeployer.class, WebDeployer2.class);
        parser.replace(WebEntityResolver.class, EntityResolverImpl.class);
        return parser;
    }

    protected File createTempDir() throws IOException {
        File dir = File.createTempFile("glassfish", "embedded");
        dir.delete();
        dir.mkdirs();
        return dir;
    }

    public GFVirtualServer createVirtualServer(GFHttpListener listener) {
        if (this.started) {
            throw new IllegalStateException();
        }
        DomBuilder db = this.onHttpService();
        db.element("virtual-server").attribute("id", "server").attribute("http-listeners", listener.getId()).attribute("hosts", "${com.sun.aas.hostName}").attribute("log-file", "").element("property").attribute("name", "docroot").attribute("value", ".");
        return new GFVirtualServer(null);
    }

    public GFHttpListener createHttpListener(int listenerPort) {
        if (this.started) {
            throw new IllegalStateException();
        }
        this.onHttpService().element("http-listener").attribute("id", listenerPort).attribute("address", "0.0.0.0").attribute("port", listenerPort).attribute("default-virtual-server", "server").attribute("server-name", "").attribute("enabled", true);
        return new GFHttpListener(String.valueOf(listenerPort), null);
    }

    private DomBuilder onHttpService() {
        try {
            return new DomBuilder((Element)this.xpath.evaluate("//http-service", this.domainXml, XPathConstants.NODE));
        }
        catch (XPathExpressionException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        try {
            final Module[] proxyMod = new Module[1];
            ModulesRegistryImpl mrs = new ModulesRegistryImpl(null){

                public Module find(Class clazz) {
                    Module m = super.find(clazz);
                    if (m == null) {
                        return proxyMod[0];
                    }
                    return m;
                }
            };
            proxyMod[0] = mrs.add((ModuleDefinition)new ProxyModuleDefinition(this.getClass().getClassLoader()));
            StartupContext startupContext = new StartupContext(this.createTempDir(), new String[0]);
            this.habitat = new Main(){

                protected InhabitantsParser createInhabitantsParser(Habitat habitat1) {
                    return GlassFish.this.decorateInhabitantsParser(super.createInhabitantsParser(habitat1));
                }
            }.launch((ModulesRegistry)mrs, startupContext);
            this.appLife = (ApplicationLifecycle)this.habitat.getComponent(ApplicationLifecycle.class);
            this.snifMan = (SnifferManager)this.habitat.getComponent(SnifferManager.class);
            this.archiveFactory = (ArchiveFactory)this.habitat.getComponent(ArchiveFactory.class);
            this.env = (ServerEnvironment)this.habitat.getComponent(ServerEnvironment.class);
        }
        catch (IOException e) {
            throw new GFException(e);
        }
        catch (BootException e) {
            throw new GFException(e);
        }
    }

    public GFApplication deploy(File archive) throws IOException {
        this.start();
        ReadableArchive a = this.archiveFactory.openArchive(archive);
        if (!archive.isDirectory()) {
            ArchiveHandler h = this.appLife.getArchiveHandler(a);
            File tmpDir = new File(a.getName());
            FileUtils.whack((File)tmpDir);
            tmpDir.mkdirs();
            h.expand(a, this.archiveFactory.createArchive(tmpDir));
            a.close();
            a = this.archiveFactory.openArchive(tmpDir);
        }
        return this.deploy(a);
    }

    public GFApplication deploy(ReadableArchive a) throws IOException {
        this.start();
        ArchiveHandler h = this.appLife.getArchiveHandler(a);
        ClassLoader parentCL = this.snifMan.createSnifferParentCL(null);
        ClassLoader cl = h.getClassLoader(parentCL, a);
        Collection activeSniffers = this.snifMan.getSniffers(a, cl);
        Properties params = new Properties();
        params.put("name", a.getName());
        params.put("enabled", "true");
        DeploymentContextImpl deploymentContext = new DeploymentContextImpl(Logger.getAnonymousLogger(), a, params, this.env);
        deploymentContext.setClassLoader(cl);
        SilentActionReport r = new SilentActionReport();
        ApplicationInfo appInfo = this.appLife.deploy((Iterable)activeSniffers, deploymentContext, (ActionReport)r);
        r.check();
        return new GFApplication(this, appInfo, (DeploymentContext)deploymentContext);
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        for (Inhabitant svc : this.habitat.getInhabitants(Startup.class)) {
            svc.release();
        }
        for (Inhabitant svc : this.habitat.getInhabitants(Init.class)) {
            svc.release();
        }
    }
}

