/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.glassfish.maven.PluginUtil;

public abstract class AbstractServerMojo
extends AbstractMojo {
    public static final String PLATFORM_KEY = "GlassFish_Platform";
    public static final String INSTANCE_ROOT_PROP_NAME = "com.sun.aas.instanceRoot";
    public static final String INSTALL_ROOT_PROP_NAME = "com.sun.aas.installRoot";
    public static final String CONFIG_FILE_URI_PROP_NAME = "org.glassfish.embeddable.configFileURI";
    private static final String NETWORK_LISTENER_KEY = "embedded-glassfish-config.server.network-config.network-listeners.network-listener.%s";
    public static String thisArtifactId = "org.glassfish.embedded:maven-embedded-glassfish-plugin";
    private static String SHELL_JAR = "lib/embedded/glassfish-embedded-static-shell.jar";
    private static String FELIX_JAR = "osgi/felix/bin/felix.jar";
    private static final String EMBEDDED_GROUP_ID = "org.glassfish.main.extras";
    private static final String EMBEDDED_ALL = "glassfish-embedded-all";
    private static final String EMBEDDED_ARTIFACT_PREFIX = "glassfish-embedded-";
    private static final String GF_API_GROUP_ID = "org.glassfish.main.common";
    private static final String GF_API_ARTIFACT_ID = "simple-glassfish-api";
    private static final String DEFAULT_GF_VERSION = "4.0";
    private static String gfVersion;
    protected List remoteRepositories;
    protected String serverID;
    protected int port;
    protected String installRoot;
    protected String instanceRoot;
    protected String configFile;
    protected Boolean configFileReadOnly;
    protected Map<String, String> ports;
    protected List<String> bootstrapProperties;
    protected File bootstrapPropertiesFile;
    protected List<String> glassfishProperties;
    protected File glassfishPropertiesFile;
    protected List<String> systemProperties;
    protected File systemPropertiesFile;
    protected Boolean autoDelete;
    protected MavenProject project;
    private List<Artifact> artifacts;
    protected MavenProjectBuilder projectBuilder;
    protected ArtifactRepository localRepository;
    protected ArtifactResolver resolver;
    protected ArtifactFactory factory;
    protected String containerType;
    protected static HashMap<String, ClassLoader> classLoaders;
    private static ClassLoader classLoader;
    private ArtifactMetadataSource artifactMetadataSource;

    public abstract void execute() throws MojoExecutionException, MojoFailureException;

    protected ClassLoader getClassLoader() throws MojoExecutionException {
        try {
            if (classLoader != null) {
                return classLoader;
            }
            classLoader = this.hasGlassFishInstallation() ? this.getInstalledGFClassLoader() : this.getUberGFClassLoader();
            this.printClassPaths("Created New Bootstrap ClassLoader. ServerId = " + this.serverID + ", ClassPaths = ", classLoader);
            return classLoader;
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    protected void cleanupClassLoader(String serverId) {
        ClassLoader cl = classLoaders.remove(this.serverID);
        if (cl != null) {
            System.out.println("Cleaned up ClassLoader for ServerID " + this.serverID);
        }
    }

    private void printClassPaths(String msg, ClassLoader classLoader) {
        System.out.println(msg);
        for (ClassLoader cl = classLoader; cl != null && cl instanceof URLClassLoader; cl = cl.getParent()) {
            for (URL u : ((URLClassLoader)cl).getURLs()) {
                System.out.println("ClassPath Element : " + u);
            }
        }
    }

    private boolean hasGlassFishInstallation() {
        return this.installRoot != null ? new File(this.installRoot, SHELL_JAR).exists() && new File(this.installRoot, FELIX_JAR).exists() : false;
    }

    private ClassLoader getInstalledGFClassLoader() throws Exception {
        File gfJar = new File(this.installRoot, SHELL_JAR);
        File felixJar = new File(this.installRoot, FELIX_JAR);
        URLClassLoader classLoader = new URLClassLoader(new URL[]{gfJar.toURI().toURL(), felixJar.toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader());
        return classLoader;
    }

    private Artifact getUberFromSpecifiedDependency() {
        if (this.artifacts != null) {
            for (Artifact artifact : this.artifacts) {
                if (!EMBEDDED_GROUP_ID.equals(artifact.getGroupId()) || !artifact.getArtifactId().startsWith(EMBEDDED_ARTIFACT_PREFIX)) continue;
                return artifact;
            }
        }
        return null;
    }

    private String getGlassfishVersion(Artifact gfMvnPlugin) throws Exception {
        if (gfVersion != null) {
            return gfVersion;
        }
        ResolutionGroup resGroup = this.artifactMetadataSource.retrieve(gfMvnPlugin, this.localRepository, this.remoteRepositories);
        MavenProject pomProject = this.projectBuilder.buildFromRepository(resGroup.getPomArtifact(), this.remoteRepositories, this.localRepository);
        List dependencies = pomProject.getOriginalModel().getDependencies();
        for (Dependency dependency : dependencies) {
            if (!GF_API_GROUP_ID.equals(dependency.getGroupId()) || !GF_API_ARTIFACT_ID.equals(dependency.getArtifactId())) continue;
            gfVersion = dependency.getVersion();
        }
        gfVersion = gfVersion != null ? gfVersion : DEFAULT_GF_VERSION;
        return gfVersion;
    }

    private ClassLoader getUberGFClassLoader() throws Exception {
        Artifact gfUber = this.getUberFromSpecifiedDependency();
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        if (gfUber == null) {
            Artifact gfMvnPlugin = (Artifact)this.project.getPluginArtifactMap().get(thisArtifactId);
            String gfVersion = this.getGlassfishVersion(gfMvnPlugin);
            gfUber = this.factory.createArtifact(EMBEDDED_GROUP_ID, EMBEDDED_ALL, gfVersion, "compile", "jar");
            this.resolver.resolve(gfUber, this.remoteRepositories, this.localRepository);
            cl = new URLClassLoader(new URL[]{gfUber.getFile().toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader());
        }
        return cl;
    }

    protected Properties getGlassFishProperties() {
        Properties props = new Properties();
        if (this.instanceRoot != null) {
            props.setProperty(INSTANCE_ROOT_PROP_NAME, new File(this.instanceRoot).getAbsolutePath());
        }
        if (this.configFile != null) {
            try {
                URI configFileURI = URI.create(this.configFile);
                String scheme = configFileURI.getScheme();
                if (scheme == null || "file".equalsIgnoreCase(scheme)) {
                    props.setProperty(CONFIG_FILE_URI_PROP_NAME, new File(configFileURI).toURI().toString());
                } else {
                    props.setProperty(CONFIG_FILE_URI_PROP_NAME, configFileURI.toString());
                }
            }
            catch (Exception ex) {
                props.setProperty(CONFIG_FILE_URI_PROP_NAME, new File(this.configFile).toURI().toString());
            }
        }
        if (!this.configFileReadOnly.booleanValue()) {
            props.setProperty("org.glassfish.embeddable.configFileReadOnly", "false");
        }
        if (this.port != -1 && this.configFile == null) {
            String httpListener = String.format(NETWORK_LISTENER_KEY, "http-listener");
            props.setProperty(httpListener + ".port", String.valueOf(this.port));
            props.setProperty(httpListener + ".enabled", "true");
        }
        if (this.ports != null) {
            for (String listenerName : this.ports.keySet()) {
                String portNumber = this.ports.get(listenerName);
                if (portNumber == null || portNumber.trim().length() <= 0) continue;
                String networkListener = String.format(NETWORK_LISTENER_KEY, listenerName);
                props.setProperty(networkListener + ".port", portNumber);
                props.setProperty(networkListener + ".enabled", "true");
            }
        }
        if (!this.autoDelete.booleanValue()) {
            props.setProperty("org.glassfish.embeddable.autoDelete", "false");
        }
        this.load(this.glassfishPropertiesFile, props);
        this.load(this.glassfishProperties, props);
        return props;
    }

    protected Properties getBootStrapProperties() {
        this.setSystemProperties();
        Properties props = new Properties();
        props.setProperty(PLATFORM_KEY, "Static");
        if (this.installRoot != null) {
            props.setProperty(INSTALL_ROOT_PROP_NAME, new File(this.installRoot).getAbsolutePath());
        }
        this.load(this.bootstrapPropertiesFile, props);
        this.load(this.bootstrapProperties, props);
        return props;
    }

    private void load(List<String> stringList, Properties p) {
        if (p == null || stringList == null) {
            return;
        }
        for (String prop : stringList) {
            try {
                p.load(new StringReader(prop));
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File propertiesFile, Properties p) {
        if (propertiesFile == null || p == null) {
            return;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(propertiesFile);
            p.load(stream);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
            }
        }
    }

    private void setSystemProperties() {
        Properties sysProps = new Properties();
        this.load(this.systemPropertiesFile, sysProps);
        this.load(this.systemProperties, sysProps);
        for (Object obj : sysProps.keySet()) {
            String value;
            String key = (String)obj;
            String currentVal = System.getProperty(key);
            if (currentVal != null || (value = sysProps.getProperty(key)) == null || value.trim().length() <= 0) continue;
            System.setProperty(key, value);
            System.out.println("Set system property [" + key + " = " + value + "]");
        }
    }

    public void startGlassFish(String serverId, ClassLoader cl, Properties bootstrapProperties, Properties glassfishProperties) throws Exception {
        Class<?> clazz = cl.loadClass(PluginUtil.class.getName());
        Method m = clazz.getMethod("startGlassFish", String.class, ClassLoader.class, Properties.class, Properties.class);
        m.invoke(null, serverId, cl, bootstrapProperties, glassfishProperties);
    }

    public void stopGlassFish(String serverId, ClassLoader cl) throws Exception {
        Class<?> clazz = cl.loadClass(PluginUtil.class.getName());
        Method m = clazz.getMethod("stopGlassFish", String.class);
        m.invoke(null, serverId);
    }

    static {
        classLoaders = new HashMap();
    }
}

