/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler.modules;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.AttributeInfo;
import org.apache.commons.modeler.ConstructorInfo;
import org.apache.commons.modeler.FieldInfo;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.NotificationInfo;
import org.apache.commons.modeler.OperationInfo;
import org.apache.commons.modeler.ParameterInfo;
import org.apache.commons.modeler.Registry;
import org.apache.commons.modeler.modules.ModelerSource;
import org.apache.commons.modeler.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MbeansDescriptorsDOMSource
extends ModelerSource {
    private static Log log = LogFactory.getLog(class$org$apache$commons$modeler$modules$MbeansDescriptorsDOMSource == null ? (class$org$apache$commons$modeler$modules$MbeansDescriptorsDOMSource = MbeansDescriptorsDOMSource.class$("org.apache.commons.modeler.modules.MbeansDescriptorsDOMSource")) : class$org$apache$commons$modeler$modules$MbeansDescriptorsDOMSource);
    Registry registry;
    String location;
    String type;
    Object source;
    List mbeans = new ArrayList();
    static /* synthetic */ Class class$org$apache$commons$modeler$modules$MbeansDescriptorsDOMSource;

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public void setLocation(String loc) {
        this.location = loc;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public List loadDescriptors(Registry registry, String location, String type, Object source) throws Exception {
        this.setRegistry(registry);
        this.setLocation(location);
        this.setType(type);
        this.setSource(source);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry();
        }
        try {
            InputStream stream = (InputStream)this.source;
            long t1 = System.currentTimeMillis();
            Document doc = DomUtil.readXml(stream);
            Element descriptorsN = doc.getDocumentElement();
            if (descriptorsN == null) {
                log.error("No descriptors found");
                return;
            }
            Node firstMbeanN = null;
            firstMbeanN = "mbean".equals(descriptorsN.getNodeName()) ? descriptorsN : DomUtil.getChild((Node)descriptorsN, "mbean");
            if (firstMbeanN == null) {
                log.error(" No mbean tags ");
                return;
            }
            Node mbeanN = firstMbeanN;
            while (mbeanN != null) {
                Node firstN;
                ManagedBean managed = new ManagedBean();
                DomUtil.setAttributes(managed, mbeanN);
                Node mbeanDescriptorN = DomUtil.getChild(mbeanN, "descriptor");
                if (mbeanDescriptorN != null) {
                    Node firstFieldN;
                    Node fieldN = firstFieldN = DomUtil.getChild(mbeanDescriptorN, "field");
                    while (fieldN != null) {
                        FieldInfo fi = new FieldInfo();
                        DomUtil.setAttributes(fi, fieldN);
                        managed.addField(fi);
                        fieldN = DomUtil.getNext(fieldN);
                    }
                }
                Node descN = firstN = DomUtil.getChild(mbeanN, "attribute");
                while (descN != null) {
                    AttributeInfo ai = new AttributeInfo();
                    DomUtil.setAttributes(ai, descN);
                    Node descriptorN = DomUtil.getChild(descN, "descriptor");
                    if (descriptorN != null) {
                        Node firstFieldN;
                        Node fieldN = firstFieldN = DomUtil.getChild(descriptorN, "field");
                        while (fieldN != null) {
                            FieldInfo fi = new FieldInfo();
                            DomUtil.setAttributes(fi, fieldN);
                            ai.addField(fi);
                            fieldN = DomUtil.getNext(fieldN);
                        }
                    }
                    managed.addAttribute(ai);
                    if (log.isTraceEnabled()) {
                        log.trace("Create attribute " + ai);
                    }
                    descN = DomUtil.getNext(descN);
                }
                Node descN2 = firstN = DomUtil.getChild(mbeanN, "constructor");
                while (descN2 != null) {
                    Node firstParamN;
                    ConstructorInfo ci = new ConstructorInfo();
                    DomUtil.setAttributes(ci, descN2);
                    Node firstDescriptorN = DomUtil.getChild(descN2, "descriptor");
                    if (firstDescriptorN != null) {
                        Node firstFieldN;
                        Node fieldN = firstFieldN = DomUtil.getChild(firstDescriptorN, "field");
                        while (fieldN != null) {
                            FieldInfo fi = new FieldInfo();
                            DomUtil.setAttributes(fi, fieldN);
                            ci.addField(fi);
                            fieldN = DomUtil.getNext(fieldN);
                        }
                    }
                    Node paramN = firstParamN = DomUtil.getChild(descN2, "parameter");
                    while (paramN != null) {
                        ParameterInfo pi = new ParameterInfo();
                        DomUtil.setAttributes(pi, paramN);
                        ci.addParameter(pi);
                        paramN = DomUtil.getNext(paramN);
                    }
                    managed.addConstructor(ci);
                    if (log.isTraceEnabled()) {
                        log.trace("Create constructor " + ci);
                    }
                    descN2 = DomUtil.getNext(descN2);
                }
                Node descN3 = firstN = DomUtil.getChild(mbeanN, "notification");
                while (descN3 != null) {
                    Node firstParamN;
                    NotificationInfo ni = new NotificationInfo();
                    DomUtil.setAttributes(ni, descN3);
                    Node firstDescriptorN = DomUtil.getChild(descN3, "descriptor");
                    if (firstDescriptorN != null) {
                        Node firstFieldN;
                        Node fieldN = firstFieldN = DomUtil.getChild(firstDescriptorN, "field");
                        while (fieldN != null) {
                            FieldInfo fi = new FieldInfo();
                            DomUtil.setAttributes(fi, fieldN);
                            ni.addField(fi);
                            fieldN = DomUtil.getNext(fieldN);
                        }
                    }
                    Node paramN = firstParamN = DomUtil.getChild(descN3, "notification-type");
                    while (paramN != null) {
                        ni.addNotifType(DomUtil.getContent(paramN));
                        paramN = DomUtil.getNext(paramN);
                    }
                    managed.addNotification(ni);
                    if (log.isTraceEnabled()) {
                        log.trace("Created notification " + ni);
                    }
                    descN3 = DomUtil.getNext(descN3);
                }
                Node descN4 = firstN = DomUtil.getChild(mbeanN, "operation");
                while (descN4 != null) {
                    Node firstParamN;
                    OperationInfo oi = new OperationInfo();
                    DomUtil.setAttributes(oi, descN4);
                    Node firstDescriptorN = DomUtil.getChild(descN4, "descriptor");
                    if (firstDescriptorN != null) {
                        Node firstFieldN;
                        Node fieldN = firstFieldN = DomUtil.getChild(firstDescriptorN, "field");
                        while (fieldN != null) {
                            FieldInfo fi = new FieldInfo();
                            DomUtil.setAttributes(fi, fieldN);
                            oi.addField(fi);
                            fieldN = DomUtil.getNext(fieldN);
                        }
                    }
                    Node paramN = firstParamN = DomUtil.getChild(descN4, "parameter");
                    while (paramN != null) {
                        ParameterInfo pi = new ParameterInfo();
                        DomUtil.setAttributes(pi, paramN);
                        if (log.isTraceEnabled()) {
                            log.trace("Add param " + pi.getName());
                        }
                        oi.addParameter(pi);
                        paramN = DomUtil.getNext(paramN);
                    }
                    managed.addOperation(oi);
                    if (log.isTraceEnabled()) {
                        log.trace("Create operation " + oi);
                    }
                    descN4 = DomUtil.getNext(descN4);
                }
                this.mbeans.add(managed);
                mbeanN = DomUtil.getNext(mbeanN);
            }
            long t2 = System.currentTimeMillis();
            log.debug("Reading descriptors ( dom ) " + (t2 - t1));
        }
        catch (Exception ex) {
            log.error("Error reading descriptors ", ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

