/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.Introspector;
import com.sun.jdmk.MBeanInstantiator;
import com.sun.jdmk.MetaDataImpl;
import com.sun.jdmk.ModifiableClassLoaderRepository;
import com.sun.jdmk.ObjectInputStreamWithLoader;
import com.sun.jdmk.internal.ClassLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class MBeanInstantiatorImpl
implements MBeanInstantiator {
    private final ModifiableClassLoaderRepository clr;
    private static final String dbgTag = "MBeanInstantiatorImpl";
    private final ClassLogger logger = new ClassLogger("com.sun.jdmk.mbeanserver", "MBeanInstantiatorImpl");

    public MBeanInstantiatorImpl(ModifiableClassLoaderRepository clr) {
        this.clr = clr;
    }

    public void testCreation(Class c) throws NotCompliantMBeanException {
        Introspector.testCreation(c);
    }

    public Class findClassWithDefaultLoaderRepository(String className) throws ReflectionException {
        Class<?> theClass;
        if (className == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occurred during object instantiation");
        }
        try {
            if (this.clr == null) {
                throw new ClassNotFoundException(className);
            }
            theClass = this.clr.loadClass(className);
        }
        catch (ClassNotFoundException ee) {
            throw new ReflectionException(ee, "The MBean class could not be loaded by the default loader repository");
        }
        return theClass;
    }

    public Class findClass(String className, ClassLoader loader) throws ReflectionException {
        Class<?> theClass = null;
        if (className == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occurred during object instantiation");
        }
        try {
            theClass = loader != null ? loader.loadClass(className) : Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e, "The MBean class could not be loaded by the MBean Interceptor's classloader");
        }
        return theClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findClass(String className, ObjectName aLoader) throws ReflectionException, InstanceNotFoundException {
        Class<?> theClass = null;
        if (aLoader == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null loader passed in parameter");
        }
        ClassLoader loader = null;
        MBeanInstantiatorImpl mBeanInstantiatorImpl = this;
        synchronized (mBeanInstantiatorImpl) {
            if (this.clr != null) {
                loader = this.clr.getClassLoader(aLoader);
            }
        }
        if (loader == null) {
            throw new InstanceNotFoundException("The loader named " + aLoader + " is not registered in the MBeanServer");
        }
        try {
            theClass = loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e, "The MBean class could not be loaded by the specified classloader");
        }
        return theClass;
    }

    public Class[] findSignatureClasses(String[] signature, ClassLoader loader) throws ReflectionException {
        if (signature == null) {
            return null;
        }
        ClassLoader aLoader = loader;
        int length = signature.length;
        Class[] tab = new Class[length];
        if (length == 0) {
            return tab;
        }
        try {
            for (int i = 0; i < length; ++i) {
                Class primCla = MetaDataImpl.findClassForPrim(signature[i]);
                if (primCla != null) {
                    tab[i] = primCla;
                    continue;
                }
                if (aLoader != null) {
                    Class<?> sclass = aLoader.loadClass(signature[i]);
                    if (sclass == null) continue;
                    tab[i] = sclass;
                    continue;
                }
                tab[i] = this.findClass(signature[i], this.getClass().getClassLoader());
            }
        }
        catch (ClassNotFoundException e) {
            this.logger.finest("findSignatureClasses", e);
            throw new ReflectionException(e, "The parameter class could not be found");
        }
        catch (RuntimeException e) {
            this.logger.finest("findSignatureClasses", e);
            throw e;
        }
        return tab;
    }

    public Object instantiate(Class theClass) throws ReflectionException, MBeanException {
        Object moi = null;
        Constructor cons = MetaDataImpl.findConstructor(theClass, null);
        if (cons == null) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor"));
        }
        try {
            moi = cons.newInstance(null);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t, "RuntimeException thrown in the MBean's empty constructor");
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t, "Error thrown in the MBean's empty constructor");
            }
            throw new MBeanException((Exception)t, "Exception thrown in the MBean's empty constructor");
        }
        catch (NoSuchMethodError error) {
            throw new ReflectionException(new NoSuchMethodException("No constructor"), "No such constructor");
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        return moi;
    }

    public Object instantiate(Class theClass, Object[] params, String[] signature, ClassLoader loader) throws ReflectionException, MBeanException {
        Class[] tab;
        Object moi = null;
        try {
            ClassLoader aLoader = theClass.getClassLoader();
            tab = signature == null ? null : this.findSignatureClasses(signature, aLoader);
            params = this.checkTransferParameters(aLoader, params);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e, "The constructor parameter classes could not be loaded");
        }
        Constructor cons = null;
        cons = MetaDataImpl.findConstructor(theClass, tab);
        if (cons == null) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor"));
        }
        try {
            moi = cons.newInstance(params);
        }
        catch (NoSuchMethodError error) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor found"), "No such constructor");
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e, "Exception thrown trying to invoke the MBean's constructor");
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, "Exception thrown trying to invoke the MBean's constructor");
        }
        catch (InvocationTargetException e) {
            Throwable th = e.getTargetException();
            if (th instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)th, "RuntimeException thrown in the MBean's constructor");
            }
            if (th instanceof Error) {
                throw new RuntimeErrorException((Error)th, "Error thrown in the MBean's constructor");
            }
            throw new MBeanException((Exception)th, "Exception thrown in the MBean's constructor");
        }
        return moi;
    }

    public final AttributeList checkTransferAttributeList(ClassLoader dest, AttributeList attributes) {
        ClassLoader aLoader = dest;
        if (aLoader == null || attributes == null) {
            return attributes;
        }
        int count = attributes.size();
        if (count == 0) {
            return attributes;
        }
        Attribute[] attrs = attributes.toArray(new Attribute[count]);
        for (int i = 0; i < count; ++i) {
            Attribute attr = attrs[i];
            Attribute newattr = this.checkTransferAttribute(aLoader, attr);
            if (attr == newattr) continue;
            attributes.set(i, newattr);
        }
        return attributes;
    }

    public Attribute checkTransferAttribute(ClassLoader dest, Attribute attribute) {
        ClassLoader aLoader = dest;
        if (aLoader == null || attribute == null) {
            return attribute;
        }
        Object v = attribute.getValue();
        if (v == null) {
            return attribute;
        }
        Object newval = this.checkTransferObject(dest, v);
        if (newval == v) {
            return attribute;
        }
        return new Attribute(attribute.getName(), newval);
    }

    public Object[] checkTransferParameters(ClassLoader dest, Object[] params) {
        Object[] values = params;
        if (values == null) {
            return params;
        }
        int len = values.length;
        if (len == 0) {
            return params;
        }
        for (int i = 0; i < len; ++i) {
            values[i] = this.checkTransferObject(dest, values[i]);
        }
        return values;
    }

    public Object checkTransferObject(ClassLoader targetLoader, Object value) {
        if (value == null) {
            return null;
        }
        ClassLoader t_loader = targetLoader;
        if (t_loader == null) {
            return value;
        }
        ClassLoader v_loader = value.getClass().getClassLoader();
        if (v_loader == null) {
            return value;
        }
        if (t_loader.equals(v_loader)) {
            return value;
        }
        return this.transferObject(value, t_loader);
    }

    public Object transferObject(Object obj, ClassLoader aloader) {
        ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(arrayOut);
            out.writeObject(obj);
            out.flush();
        }
        catch (Exception e) {
            return obj;
        }
        try {
            ByteArrayInputStream arrayIn = new ByteArrayInputStream(arrayOut.toByteArray());
            ObjectInputStreamWithLoader in = new ObjectInputStreamWithLoader(arrayIn, aloader);
            return in.readObject();
        }
        catch (Exception e) {
            return obj;
        }
    }

    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        ObjectInputStreamWithLoader objIn;
        if (data == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null data passed in parameter");
        }
        if (data.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Empty data passed in parameter");
        }
        ClassLoader loader = this.clr.getClassLoader(name);
        ByteArrayInputStream bIn = new ByteArrayInputStream(data);
        try {
            objIn = new ObjectInputStreamWithLoader(bIn, loader);
        }
        catch (IOException e) {
            throw new OperationsException("An IOException occurred trying to de-serialize the data");
        }
        return objIn;
    }

    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        ObjectInputStreamWithLoader objIn;
        if (data == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null data passed in parameter");
        }
        if (data.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Empty data passed in parameter");
        }
        if (className == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null className passed in parameter");
        }
        Class theClass = this.findClassWithDefaultLoaderRepository(className);
        ByteArrayInputStream bIn = new ByteArrayInputStream(data);
        try {
            objIn = new ObjectInputStreamWithLoader(bIn, theClass.getClassLoader());
        }
        catch (IOException e) {
            throw new OperationsException("An IOException occurred trying to de-serialize the data");
        }
        return objIn;
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data, ClassLoader loader) throws InstanceNotFoundException, OperationsException, ReflectionException {
        ObjectInputStreamWithLoader objIn;
        if (data == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null data passed in parameter");
        }
        if (data.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Empty data passed in parameter");
        }
        if (className == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null className passed in parameter");
        }
        Class<?> theClass = null;
        if (loaderName == null) {
            theClass = this.findClass(className, loader);
        } else {
            try {
                ClassLoader instance = null;
                if (this.clr != null) {
                    instance = this.clr.getClassLoader(loaderName);
                }
                if (instance == null) {
                    throw new ClassNotFoundException(className);
                }
                theClass = ((ClassLoader)instance).loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new ReflectionException(e, "The MBean class could not be loaded by the " + loaderName.toString() + " class loader");
            }
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(data);
        try {
            objIn = new ObjectInputStreamWithLoader(bIn, theClass.getClassLoader());
        }
        catch (IOException e) {
            throw new OperationsException("An IOException occurred trying to de-serialize the data");
        }
        return objIn;
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.instantiate(className, (Object[])null, (String[])null, null);
    }

    public Object instantiate(String className, ObjectName loaderName, ClassLoader loader) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.instantiate(className, loaderName, null, null, loader);
    }

    public Object instantiate(String className, Object[] params, String[] signature, ClassLoader loader) throws ReflectionException, MBeanException {
        Class theClass = this.findClassWithDefaultLoaderRepository(className);
        return this.instantiate(theClass, params, signature, loader);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature, ClassLoader loader) throws ReflectionException, MBeanException, InstanceNotFoundException {
        Class theClass = loaderName == null ? this.findClass(className, loader) : this.findClass(className, loaderName);
        return this.instantiate(theClass, params, signature, loader);
    }

    public ModifiableClassLoaderRepository getClassLoaderRepository() {
        return this.clr;
    }
}

