/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.agent.SnmpMibAgent;
import java.util.Enumeration;
import java.util.Vector;

final class SnmpMibTree {
    private SnmpMibAgent defaultAgent = null;
    private TreeNode root = new TreeNode(-1L, null);

    public boolean isMibReferenced(SnmpMibAgent agent) {
        return this.root.isMibReferenced(agent);
    }

    public void setDefaultAgent(SnmpMibAgent def) {
        this.defaultAgent = def;
        this.root.agent = def;
    }

    public SnmpMibAgent getDefaultAgent() {
        return this.defaultAgent;
    }

    public void register(SnmpMibAgent agent) {
        this.root.registerNode(agent);
    }

    public void register(SnmpMibAgent agent, long[] oid) {
        this.root.registerNode(oid, 0, agent);
    }

    public SnmpMibAgent getAgentMib(SnmpOid oid) {
        TreeNode node = this.root.retrieveMatchingBranch(oid.longValue(), 0);
        if (node == null) {
            return this.defaultAgent;
        }
        if (node.getAgentMib() == null) {
            return this.defaultAgent;
        }
        return node.getAgentMib();
    }

    public void unregister(SnmpMibAgent agent, SnmpOid[] oids) {
        for (int i = 0; i < oids.length; ++i) {
            long[] oid = oids[i].longValue();
            TreeNode node = this.root.retrieveMatchingBranch(oid, 0);
            if (node == null) continue;
            node.removeAgent(agent);
        }
    }

    public void unregister(SnmpMibAgent agent) {
        this.root.removeAgentFully(agent);
    }

    final class TreeNode {
        private Vector children = new Vector();
        long nodeValue;
        protected SnmpMibAgent agent;
        private TreeNode parent;

        void registerNode(SnmpMibAgent agent) {
            long[] oid = agent.getRootOid();
            this.registerNode(oid, 0, agent);
        }

        TreeNode retrieveMatchingBranch(long[] oid, int cursor) {
            TreeNode node = this.retrieveChild(oid, cursor);
            if (node == null) {
                return this;
            }
            if (this.children.size() == 0) {
                return node;
            }
            if (cursor + 1 == oid.length) {
                return node;
            }
            TreeNode n = node.retrieveMatchingBranch(oid, cursor + 1);
            return n.agent == null ? this : n;
        }

        SnmpMibAgent getAgentMib() {
            return this.agent;
        }

        private TreeNode(long nodeValue, TreeNode sup) {
            this.nodeValue = nodeValue;
            this.parent = sup;
        }

        private boolean isMibReferenced(SnmpMibAgent agent) {
            if (this.agent == agent) {
                return true;
            }
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                TreeNode node = (TreeNode)e.nextElement();
                if (!node.isMibReferenced(agent)) continue;
                return true;
            }
            return false;
        }

        private void removeAgentFully(SnmpMibAgent agent) {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                TreeNode node = (TreeNode)e.nextElement();
                node.removeAgentFully(agent);
            }
            this.removeAgent(agent);
        }

        private void removeAgent(SnmpMibAgent mib) {
            if (this.agent != mib) {
                return;
            }
            this.agent = null;
        }

        private void setAgent(SnmpMibAgent agent) {
            this.agent = agent;
        }

        private void registerNode(long[] oid, int cursor, SnmpMibAgent agent) {
            if (cursor >= oid.length) {
                return;
            }
            TreeNode child = this.retrieveChild(oid, cursor);
            if (child == null) {
                long theValue = oid[cursor];
                child = new TreeNode(theValue, this);
                this.children.addElement(child);
            }
            if (cursor == oid.length - 1) {
                child.setAgent(agent);
            } else {
                child.registerNode(oid, cursor + 1, agent);
            }
        }

        private TreeNode retrieveChild(long[] oid, int current) {
            long theValue = oid[current];
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                TreeNode node = (TreeNode)e.nextElement();
                if (!node.match(theValue)) continue;
                return node;
            }
            return null;
        }

        private final boolean match(long value) {
            return this.nodeValue == value;
        }
    }
}

