/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.ClientHandler;
import com.sun.management.comm.SnmpAdaptorServer;
import com.sun.management.comm.SnmpMibTree;
import com.sun.management.comm.SnmpSubBulkRequestHandler;
import com.sun.management.comm.SnmpSubNextRequestHandler;
import com.sun.management.comm.SnmpSubRequestHandler;
import com.sun.management.snmp.InetAddressAcl;
import com.sun.management.snmp.SnmpDefinitions;
import com.sun.management.snmp.SnmpMessage;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduBulk;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpPduPacket;
import com.sun.management.snmp.SnmpPduRequest;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpValue;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.agent.SnmpMibAgent;
import com.sun.management.snmp.agent.SnmpUserDataFactory;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class SnmpRequestHandler
extends ClientHandler
implements SnmpDefinitions {
    private transient DatagramSocket socket = null;
    private transient DatagramPacket packet = null;
    private transient Vector mibs = null;
    private transient Hashtable subs = null;
    private transient SnmpMibTree root;
    private transient Object ipacl = null;
    private transient SnmpPduFactory pduFactory = null;
    private transient SnmpUserDataFactory userDataFactory = null;
    private transient SnmpAdaptorServer adaptor = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";
    private static final SnmpStatusException noSuchNameException = new SnmpStatusException(2);

    public SnmpRequestHandler(SnmpAdaptorServer server, int id, DatagramSocket s, DatagramPacket p, SnmpMibTree tree, Vector m, Object a, SnmpPduFactory factory, SnmpUserDataFactory dataFactory, MBeanServer f, ObjectName n) {
        super(server, id, f, n);
        this.adaptor = server;
        this.socket = s;
        this.packet = p;
        this.root = tree;
        this.mibs = (Vector)m.clone();
        this.subs = new Hashtable(this.mibs.size());
        this.ipacl = a;
        this.pduFactory = factory;
        this.userDataFactory = dataFactory;
    }

    public void doRun() {
        block11: {
            if (this.logger.finerOn()) {
                this.logger.finer("doRun", "Packet received:\n" + SnmpMessage.dumpHexBuffer(this.packet.getData(), 0, this.packet.getLength()));
            }
            DatagramPacket respPacket = this.makeResponsePacket(this.packet);
            if (this.logger.finerOn() && respPacket != null) {
                this.logger.finer("doRun", "Packet to be sent:\n" + SnmpMessage.dumpHexBuffer(respPacket.getData(), 0, respPacket.getLength()));
            }
            if (respPacket != null) {
                try {
                    this.socket.send(respPacket);
                }
                catch (SocketException e) {
                    if (this.logger.finestOn()) {
                        if (e.getMessage().equals(InterruptSysCallMsg)) {
                            this.logger.finest("doRun", "interrupted");
                        } else {
                            this.logger.finest("doRun", "i/o exception");
                            this.logger.finest("doRun", e);
                        }
                    }
                }
                catch (InterruptedIOException e) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("doRun", "interrupted");
                    }
                }
                catch (Exception e) {
                    if (!this.logger.finestOn()) break block11;
                    this.logger.finest("doRun", "failure when sending response");
                    this.logger.finest("doRun", e);
                }
            }
        }
    }

    private DatagramPacket makeResponsePacket(DatagramPacket reqPacket) {
        DatagramPacket respPacket = null;
        SnmpMessage reqMsg = new SnmpMessage();
        try {
            reqMsg.decodeMessage(reqPacket.getData(), reqPacket.getLength());
            reqMsg.address = reqPacket.getAddress();
            reqMsg.port = reqPacket.getPort();
        }
        catch (SnmpStatusException x) {
            if (this.logger.finestOn()) {
                this.logger.finest("makeResponsePacket", "packet decoding failed");
                this.logger.finest("makeResponsePacket", x);
            }
            reqMsg = null;
            ((SnmpAdaptorServer)this.adaptorServer).incSnmpInASNParseErrs(1);
        }
        SnmpMessage respMsg = null;
        if (reqMsg != null) {
            respMsg = this.makeResponseMessage(reqMsg);
        }
        if (respMsg != null) {
            try {
                reqPacket.setLength(respMsg.encodeMessage(reqPacket.getData()));
                respPacket = reqPacket;
            }
            catch (SnmpTooBigException x) {
                if (this.logger.finestOn()) {
                    this.logger.finest("makeResponsePacket", "response message is too big");
                }
                try {
                    respMsg = this.newTooBigMessage(reqMsg);
                    reqPacket.setLength(respMsg.encodeMessage(reqPacket.getData()));
                    respPacket = reqPacket;
                }
                catch (SnmpTooBigException xx) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("makeResponsePacket", "'too big' is 'too big' !!!");
                    }
                    this.adaptor.incSnmpSilentDrops(1);
                }
            }
        }
        return respPacket;
    }

    private SnmpMessage makeResponseMessage(SnmpMessage reqMsg) {
        Object userData;
        SnmpPduPacket reqPdu;
        SnmpMessage respMsg;
        block31: {
            respMsg = null;
            reqPdu = null;
            userData = null;
            try {
                reqPdu = (SnmpPduPacket)this.pduFactory.decodeSnmpPdu(reqMsg);
                if (reqPdu != null && this.userDataFactory != null) {
                    userData = this.userDataFactory.allocateUserData(reqPdu);
                }
            }
            catch (SnmpStatusException x) {
                reqPdu = null;
                SnmpAdaptorServer snmpServer = (SnmpAdaptorServer)this.adaptorServer;
                snmpServer.incSnmpInASNParseErrs(1);
                if (x.getStatus() == 243) {
                    snmpServer.incSnmpInBadVersions(1);
                }
                if (!this.logger.finestOn()) break block31;
                this.logger.finest("makeResponseMessage", "message decoding failed");
            }
        }
        SnmpPduPacket respPdu = null;
        if (reqPdu != null) {
            respPdu = this.makeResponsePdu(reqPdu, userData);
            try {
                if (this.userDataFactory != null) {
                    this.userDataFactory.releaseUserData(userData, respPdu);
                }
            }
            catch (SnmpStatusException x) {
                respPdu = null;
            }
        }
        if (respPdu != null) {
            try {
                respMsg = (SnmpMessage)this.pduFactory.encodeSnmpPdu(respPdu, this.packet.getData().length);
            }
            catch (SnmpStatusException x) {
                respMsg = null;
                if (this.logger.finestOn()) {
                    this.logger.finest("makeResponseMessage", "failure when encoding the response message");
                    this.logger.finest("makeResponseMessage", x);
                }
            }
            catch (SnmpTooBigException x) {
                if (this.logger.finestOn()) {
                    this.logger.finest("makeResponseMessage", "response message is too big");
                    this.logger.finest("makeResponseMessage", "caught " + x, x);
                }
                try {
                    if (this.packet.getData().length <= 32) {
                        throw x;
                    }
                    int pos = x.getVarBindCount();
                    if (this.logger.finestOn()) {
                        this.logger.finest("makeResponseMessage", "fail on element " + pos);
                    }
                    int old = 0;
                    while (true) {
                        try {
                            respPdu = this.reduceResponsePdu(reqPdu, respPdu, pos);
                            respMsg = (SnmpMessage)this.pduFactory.encodeSnmpPdu(respPdu, this.packet.getData().length);
                        }
                        catch (SnmpTooBigException xx) {
                            if (this.logger.finestOn()) {
                                this.logger.finest("makeResponseMessage", "response message is still too big");
                            }
                            old = pos;
                            pos = xx.getVarBindCount();
                            if (!this.logger.finestOn()) continue;
                            this.logger.finest("makeResponseMessage", "fail on element" + pos);
                            if (pos != old) continue;
                            throw xx;
                        }
                        break;
                    }
                }
                catch (SnmpStatusException xx) {
                    respMsg = null;
                    if (this.logger.finestOn()) {
                        this.logger.finest("makeResponseMessage", "failure when encoding the response message");
                        this.logger.finest("makeResponseMessage", xx);
                    }
                }
                catch (SnmpTooBigException xx) {
                    try {
                        respPdu = this.newTooBigPdu(reqPdu);
                        respMsg = (SnmpMessage)this.pduFactory.encodeSnmpPdu(respPdu, this.packet.getData().length);
                    }
                    catch (SnmpTooBigException xxx) {
                        respMsg = null;
                        if (this.logger.finestOn()) {
                            this.logger.finest("makeResponseMessage", "'too big' is 'too big' !!!");
                        }
                        this.adaptor.incSnmpSilentDrops(1);
                    }
                    catch (Exception xxx) {
                        respMsg = null;
                        if (this.logger.finerOn()) {
                            this.logger.finer("makeResponseMessage", "[" + Thread.currentThread() + "]: Unexpected exception: " + xxx);
                        }
                        this.logger.finest("makeResponseMessage", xxx);
                    }
                }
                catch (Exception xx) {
                    respMsg = null;
                    if (this.logger.finerOn()) {
                        this.logger.finer("makeResponseMessage", "[" + Thread.currentThread() + "]: Unexpected exception: " + xx);
                    }
                    this.logger.finest("makeResponseMessage", xx);
                }
            }
        }
        return respMsg;
    }

    private SnmpPduPacket makeResponsePdu(SnmpPduPacket reqPdu, Object userData) {
        SnmpPduPacket respPdu;
        block14: {
            SnmpAdaptorServer snmpServer = (SnmpAdaptorServer)this.adaptorServer;
            respPdu = null;
            snmpServer.updateRequestCounters(reqPdu.type);
            if (reqPdu.varBindList != null) {
                snmpServer.updateVarCounters(reqPdu.type, reqPdu.varBindList.length);
            }
            if (this.checkPduType(reqPdu)) {
                respPdu = this.checkAcl(reqPdu);
                if (respPdu == null) {
                    if (this.mibs.size() < 1) {
                        if (this.logger.finerOn()) {
                            this.logger.finer("makeResponsePdu", "Request " + reqPdu.requestId + " received but no MIB registered.");
                        }
                        return this.makeNoMibErrorPdu((SnmpPduRequest)reqPdu, userData);
                    }
                    switch (reqPdu.type) {
                        case 160: 
                        case 161: 
                        case 163: {
                            respPdu = this.makeGetSetResponsePdu((SnmpPduRequest)reqPdu, userData);
                            break;
                        }
                        case 165: {
                            respPdu = this.makeGetBulkResponsePdu((SnmpPduBulk)reqPdu, userData);
                        }
                    }
                } else {
                    if (!snmpServer.getAuthRespEnabled()) {
                        respPdu = null;
                    }
                    if (snmpServer.getAuthTrapEnabled()) {
                        try {
                            snmpServer.snmpV1Trap(4, 0, new SnmpVarBindList());
                        }
                        catch (Exception x) {
                            if (!this.logger.finestOn()) break block14;
                            this.logger.finest("makeResponsePdu", "failure when sending authentication trap");
                            this.logger.finest("makeResponsePdu", x);
                        }
                    }
                }
            }
        }
        return respPdu;
    }

    SnmpPduPacket makeErrorVarbindPdu(SnmpPduPacket req, int statusTag) {
        SnmpVarBind[] vblist = req.varBindList;
        int length = vblist.length;
        switch (statusTag) {
            case 130: {
                for (int i = 0; i < length; ++i) {
                    vblist[i].setSnmpValue(SnmpVarBind.endOfMibView);
                }
                break;
            }
            case 128: {
                for (int i = 0; i < length; ++i) {
                    vblist[i].setSnmpValue(SnmpVarBind.noSuchObject);
                }
                break;
            }
            case 129: {
                for (int i = 0; i < length; ++i) {
                    vblist[i].setSnmpValue(SnmpVarBind.noSuchInstance);
                }
                break;
            }
            default: {
                return this.newErrorResponsePdu(req, 5, 1);
            }
        }
        return this.newValidResponsePdu(req, vblist);
    }

    SnmpPduPacket makeNoMibErrorPdu(SnmpPduRequest req, Object userData) {
        if (req.version == 0) {
            return this.newErrorResponsePdu(req, 2, 1);
        }
        if (req.version == 1) {
            switch (req.type) {
                case 163: 
                case 253: {
                    return this.newErrorResponsePdu(req, 6, 1);
                }
                case 160: {
                    return this.makeErrorVarbindPdu(req, 128);
                }
                case 161: 
                case 165: {
                    return this.makeErrorVarbindPdu(req, 130);
                }
            }
        }
        return this.newErrorResponsePdu(req, 5, 1);
    }

    private SnmpPduPacket makeGetSetResponsePdu(SnmpPduRequest req, Object userData) {
        if (req.varBindList == null) {
            return this.newValidResponsePdu(req, null);
        }
        this.splitRequest(req);
        int nbSubRequest = this.subs.size();
        if (nbSubRequest == 1) {
            return this.turboProcessingGetSet(req, userData);
        }
        SnmpPduPacket result = this.executeSubRequest(req, userData);
        if (result != null) {
            return result;
        }
        if (this.logger.finerOn()) {
            this.logger.finer("makeGetSetResponsePdu", "Build the unified response for request " + req.requestId);
        }
        return this.mergeResponses(req);
    }

    private SnmpPduPacket executeSubRequest(SnmpPduPacket req, Object userData) {
        SnmpSubRequestHandler sub;
        Enumeration e;
        int errorStatus = 0;
        int nbSubRequest = this.subs.size();
        int i = 0;
        if (req.type == 163) {
            i = 0;
            e = this.subs.elements();
            while (e.hasMoreElements()) {
                sub = (SnmpSubRequestHandler)e.nextElement();
                sub.setUserData(userData);
                sub.type = 253;
                sub.run();
                sub.type = 163;
                if (sub.getErrorStatus() != 0) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("executeSubRequest", "an error occurs");
                    }
                    return this.newErrorResponsePdu(req, errorStatus, sub.getErrorIndex() + 1);
                }
                ++i;
            }
        }
        i = 0;
        e = this.subs.elements();
        while (e.hasMoreElements()) {
            sub = (SnmpSubRequestHandler)e.nextElement();
            sub.setUserData(userData);
            sub.run();
            if (sub.getErrorStatus() != 0) {
                if (this.logger.finestOn()) {
                    this.logger.finest("executeSubRequest", "an error occurs");
                }
                return this.newErrorResponsePdu(req, errorStatus, sub.getErrorIndex() + 1);
            }
            ++i;
        }
        return null;
    }

    private SnmpPduPacket turboProcessingGetSet(SnmpPduRequest req, Object userData) {
        int errorStatus = 0;
        SnmpSubRequestHandler sub = (SnmpSubRequestHandler)this.subs.elements().nextElement();
        sub.setUserData(userData);
        if (req.type == 163) {
            sub.type = 253;
            sub.run();
            sub.type = 163;
            errorStatus = sub.getErrorStatus();
            if (errorStatus != 0) {
                return this.newErrorResponsePdu(req, errorStatus, sub.getErrorIndex() + 1);
            }
        }
        sub.run();
        errorStatus = sub.getErrorStatus();
        if (errorStatus != 0) {
            if (this.logger.finestOn()) {
                this.logger.finest("turboProcessingGetSet", "an error occurs");
            }
            int realIndex = sub.getErrorIndex() + 1;
            return this.newErrorResponsePdu(req, errorStatus, realIndex);
        }
        if (this.logger.finerOn()) {
            this.logger.finer("turboProcessingGetSet", "build the unified response for request " + req.requestId);
        }
        return this.mergeResponses(req);
    }

    private SnmpPduPacket makeGetBulkResponsePdu(SnmpPduBulk req, Object userData) {
        int t;
        SnmpVarBind[] respVarBindList = null;
        int L = req.varBindList.length;
        int N = Math.max(Math.min(req.nonRepeaters, L), 0);
        int M = Math.max(req.maxRepetitions, 0);
        int R = L - N;
        if (req.varBindList == null) {
            return this.newValidResponsePdu(req, null);
        }
        this.splitBulkRequest(req, N, M, R);
        SnmpPduPacket result = this.executeSubRequest(req, userData);
        if (result != null) {
            return result;
        }
        respVarBindList = this.mergeBulkResponses(N + M * R);
        for (t = respVarBindList.length; t > N && respVarBindList[t - 1].getSnmpValue().equals(SnmpVarBind.endOfMibView); --t) {
        }
        int m2 = t == N ? N + R : N + ((t - 1 - N) / R + 2) * R;
        if (m2 < respVarBindList.length) {
            SnmpVarBind[] truncatedList = new SnmpVarBind[m2];
            for (int i = 0; i < m2; ++i) {
                truncatedList[i] = respVarBindList[i];
            }
            respVarBindList = truncatedList;
        }
        return this.newValidResponsePdu(req, respVarBindList);
    }

    private boolean checkPduType(SnmpPduPacket pdu) {
        boolean result = true;
        switch (pdu.type) {
            case 160: 
            case 161: 
            case 163: 
            case 165: {
                result = true;
                break;
            }
            default: {
                if (this.logger.finestOn()) {
                    this.logger.finest("checkPduType", "cannot respond to this kind of PDU");
                }
                result = false;
            }
        }
        return result;
    }

    private SnmpPduPacket checkAcl(SnmpPduPacket pdu) {
        SnmpPduRequest response = null;
        String community = new String(pdu.community);
        if (this.ipacl != null) {
            int err;
            if (pdu.type == 163) {
                if (!((InetAddressAcl)this.ipacl).checkWritePermission(pdu.address, community)) {
                    if (this.logger.finerOn()) {
                        this.logger.finer("checkAcl", "sender is " + pdu.address + " with " + community);
                        this.logger.finer("checkAcl", "sender has no write permission");
                    }
                    err = SnmpSubRequestHandler.mapErrorStatus(16, pdu.version, pdu.type);
                    response = this.newErrorResponsePdu(pdu, err, 0);
                } else if (this.logger.finerOn()) {
                    this.logger.finer("checkAcl", "sender is " + pdu.address + " with " + community);
                    this.logger.finer("checkAcl", "sender has write permission");
                }
            } else if (!((InetAddressAcl)this.ipacl).checkReadPermission(pdu.address, community)) {
                if (this.logger.finerOn()) {
                    this.logger.finer("checkAcl", "sender is " + pdu.address + " with " + community);
                    this.logger.finer("checkAcl", "sender has no read permission");
                }
                err = SnmpSubRequestHandler.mapErrorStatus(16, pdu.version, pdu.type);
                response = this.newErrorResponsePdu(pdu, err, 0);
                SnmpAdaptorServer snmpServer = (SnmpAdaptorServer)this.adaptorServer;
                snmpServer.updateErrorCounters(2);
            } else if (this.logger.finerOn()) {
                this.logger.finer("checkAcl", "sender is " + pdu.address + " with " + community);
                this.logger.finer("checkAcl", "sender has read permission");
            }
        }
        if (response != null) {
            SnmpAdaptorServer snmpServer = (SnmpAdaptorServer)this.adaptorServer;
            snmpServer.incSnmpInBadCommunityUses(1);
            if (!((InetAddressAcl)this.ipacl).checkCommunity(community)) {
                snmpServer.incSnmpInBadCommunityNames(1);
            }
        }
        return response;
    }

    private SnmpPduRequest newValidResponsePdu(SnmpPduPacket reqPdu, SnmpVarBind[] varBindList) {
        SnmpPduRequest result = new SnmpPduRequest();
        result.address = reqPdu.address;
        result.port = reqPdu.port;
        result.version = reqPdu.version;
        result.community = reqPdu.community;
        result.type = 162;
        result.requestId = reqPdu.requestId;
        result.errorStatus = 0;
        result.errorIndex = 0;
        result.varBindList = varBindList;
        ((SnmpAdaptorServer)this.adaptorServer).updateErrorCounters(result.errorStatus);
        return result;
    }

    private SnmpPduRequest newErrorResponsePdu(SnmpPduPacket req, int s, int i) {
        SnmpPduRequest result = this.newValidResponsePdu(req, null);
        result.errorStatus = s;
        result.errorIndex = i;
        result.varBindList = req.varBindList;
        ((SnmpAdaptorServer)this.adaptorServer).updateErrorCounters(result.errorStatus);
        return result;
    }

    private SnmpMessage newTooBigMessage(SnmpMessage reqMsg) throws SnmpTooBigException {
        SnmpMessage result = null;
        SnmpPduPacket reqPdu = null;
        try {
            reqPdu = (SnmpPduPacket)this.pduFactory.decodeSnmpPdu(reqMsg);
            if (reqPdu != null) {
                SnmpPduPacket respPdu = this.newTooBigPdu(reqPdu);
                result = (SnmpMessage)this.pduFactory.encodeSnmpPdu(respPdu, this.packet.getData().length);
            }
        }
        catch (SnmpStatusException x) {
            this.logger.finest("newTooBigMessage", "Internal Error: ", x);
            throw new InternalError();
        }
        return result;
    }

    private SnmpPduPacket newTooBigPdu(SnmpPduPacket req) {
        SnmpPduRequest result = this.newErrorResponsePdu(req, 1, 0);
        result.varBindList = null;
        return result;
    }

    private SnmpPduPacket reduceResponsePdu(SnmpPduPacket req, SnmpPduPacket resp, int acceptedVbCount) throws SnmpTooBigException {
        if (req.type != 165) {
            if (this.logger.finestOn()) {
                this.logger.finest("reduceResponsePdu", "cannot remove anything");
            }
            throw new SnmpTooBigException(acceptedVbCount);
        }
        int vbCount = resp.varBindList.length;
        vbCount = acceptedVbCount >= 2 ? Math.min(acceptedVbCount, resp.varBindList.length - 1) : (acceptedVbCount == 1 ? 1 : resp.varBindList.length / 2);
        if (vbCount < 1) {
            if (this.logger.finestOn()) {
                this.logger.finest("reduceResponsePdu", "cannot remove anything");
            }
            throw new SnmpTooBigException(acceptedVbCount);
        }
        SnmpVarBind[] newVbList = new SnmpVarBind[vbCount];
        for (int i = 0; i < vbCount; ++i) {
            newVbList[i] = resp.varBindList[i];
        }
        if (this.logger.finestOn()) {
            this.logger.finest("reduceResponsePdu", resp.varBindList.length - newVbList.length + " items have been removed");
        }
        resp.varBindList = newVbList;
        return resp;
    }

    private void splitRequest(SnmpPduRequest req) {
        int nbAgents = this.mibs.size();
        SnmpMibAgent agent = (SnmpMibAgent)this.mibs.firstElement();
        if (req.type == 161) {
            Enumeration e = this.mibs.elements();
            while (e.hasMoreElements()) {
                SnmpMibAgent ag = (SnmpMibAgent)e.nextElement();
                this.subs.put(ag, new SnmpSubNextRequestHandler(ag, (SnmpPdu)req, this.root));
            }
            return;
        }
        int nbReqs = req.varBindList.length;
        SnmpVarBind[] vars = req.varBindList;
        for (int i = 0; i < nbReqs; ++i) {
            SnmpSubRequestHandler sub;
            agent = this.root.getAgentMib(vars[i].getOid());
            if (this.logger.finerOn()) {
                this.logger.finer("splitRequest", "Found mib [" + agent + "] for oid " + vars[i].getOid());
            }
            if ((sub = (SnmpSubRequestHandler)this.subs.get(agent)) == null) {
                sub = new SnmpSubRequestHandler(agent, req);
                this.subs.put(agent, sub);
            }
            sub.updateRequest(vars[i], i);
        }
    }

    private void splitBulkRequest(SnmpPduBulk req, int nonRepeaters, int maxRepetitions, int R) {
        Enumeration e = this.mibs.elements();
        while (e.hasMoreElements()) {
            SnmpMibAgent agent = (SnmpMibAgent)e.nextElement();
            if (this.logger.finestOn()) {
                this.logger.finer("splitBulkRequest", "Create a sub with : " + agent + " " + nonRepeaters + " " + maxRepetitions + " " + R);
            }
            this.subs.put(agent, new SnmpSubBulkRequestHandler(agent, req, nonRepeaters, maxRepetitions, R, this.root));
        }
    }

    private SnmpPduPacket mergeResponses(SnmpPduRequest req) {
        if (req.type == 161) {
            return this.mergeNextResponses(req);
        }
        SnmpVarBind[] result = req.varBindList;
        Enumeration e = this.subs.elements();
        while (e.hasMoreElements()) {
            SnmpSubRequestHandler sub = (SnmpSubRequestHandler)e.nextElement();
            sub.updateResult(result);
        }
        return this.newValidResponsePdu(req, result);
    }

    private SnmpPduPacket mergeNextResponses(SnmpPduRequest req) {
        int max = req.varBindList.length;
        SnmpVarBind[] result = new SnmpVarBind[max];
        Enumeration e = this.subs.elements();
        while (e.hasMoreElements()) {
            SnmpSubRequestHandler sub = (SnmpSubRequestHandler)e.nextElement();
            sub.updateResult(result);
        }
        if (req.version == 1) {
            return this.newValidResponsePdu(req, result);
        }
        for (int i = 0; i < max; ++i) {
            SnmpValue val = result[i].getSnmpValue();
            if (val != SnmpVarBind.endOfMibView) continue;
            return this.newErrorResponsePdu(req, 2, i + 1);
        }
        return this.newValidResponsePdu(req, result);
    }

    private SnmpVarBind[] mergeBulkResponses(int size) {
        SnmpVarBind[] result = new SnmpVarBind[size];
        for (int i = size - 1; i >= 0; --i) {
            result[i] = new SnmpVarBind();
            result[i].setSnmpValue(SnmpVarBind.endOfMibView);
        }
        Enumeration e = this.subs.elements();
        while (e.hasMoreElements()) {
            SnmpSubRequestHandler sub = (SnmpSubRequestHandler)e.nextElement();
            sub.updateResult(result);
        }
        return result;
    }

    protected String makeDebugTag() {
        return "SnmpRequestHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "]";
    }

    ClassLogger makeLogger(String dbgTag) {
        return new ClassLogger("com.sun.jdmk.snmp.adaptor", dbgTag);
    }

    Thread createThread(Runnable r) {
        return null;
    }
}

