/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.ThreadContext;
import com.sun.management.comm.SnmpMibTree;
import com.sun.management.comm.SnmpSubRequestHandler;
import com.sun.management.internal.snmp.SnmpIncomingRequest;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpValue;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.agent.SnmpMibAgent;

class SnmpSubNextRequestHandler
extends SnmpSubRequestHandler {
    private SnmpMibTree root = null;

    protected SnmpSubNextRequestHandler(SnmpMibAgent agent, SnmpPdu req, SnmpMibTree root) {
        super(agent, req);
        this.init(req, root);
    }

    protected SnmpSubNextRequestHandler(SnmpEngine engine, SnmpIncomingRequest incRequest, SnmpMibAgent agent, SnmpPdu req, SnmpMibTree root) {
        super(engine, incRequest, agent, req);
        this.init(req, root);
        if (this.logger.finestOn()) {
            this.logger.finest("SnmpSubNextRequestHandler", "Constructor :" + this);
        }
    }

    private void init(SnmpPdu req, SnmpMibTree root) {
        this.root = root;
        int max = this.translation.length;
        SnmpVarBind[] list = req.varBindList;
        SnmpSubRequestHandler.NonSyncVector nonSyncVarBind = (SnmpSubRequestHandler.NonSyncVector)this.varBind;
        for (int i = 0; i < max; ++i) {
            this.translation[i] = i;
            SnmpVarBind newVarBind = new SnmpVarBind(list[i].getOid(), list[i].getSnmpValue());
            nonSyncVarBind.addNonSyncElement(newVarBind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block10: {
            try {
                ThreadContext oldContext = ThreadContext.push("SnmpUserData", this.data);
                try {
                    if (this.logger.finerOn()) {
                        this.logger.finer("run", "[" + Thread.currentThread() + "]:getNext operation on " + this.agent.getMibName());
                    }
                    this.agent.getNext(this.createMibRequest(this.varBind, 1, this.data));
                }
                finally {
                    ThreadContext.restore(oldContext);
                }
            }
            catch (SnmpStatusException x) {
                this.errorStatus = x.getStatus();
                this.errorIndex = x.getErrorIndex();
                if (this.logger.finestOn()) {
                    this.logger.finest("run", "[" + Thread.currentThread() + "]:a Snmp error occured during the operation");
                    this.logger.finest("run", x);
                }
            }
            catch (Exception x) {
                this.errorStatus = 5;
                if (this.logger.finestOn()) {
                    this.logger.finest("run", "[" + Thread.currentThread() + "]: Unexpected exception: " + x);
                    this.logger.finest("run", x);
                }
                if (!this.logger.finerOn()) break block10;
                this.logger.finer("run", "[" + Thread.currentThread() + "]:a generic error occured during the operation");
            }
        }
        if (this.logger.finerOn()) {
            this.logger.finer("run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    protected void updateRequest(SnmpVarBind var, int pos) {
        if (this.logger.finestOn()) {
            this.logger.finest("updateRequest", "Copy :" + var);
        }
        int size = this.varBind.size();
        this.translation[size] = pos;
        SnmpVarBind newVarBind = new SnmpVarBind(var.getOid(), var.getSnmpValue());
        if (this.logger.finestOn()) {
            this.logger.finest("updateRequest", "Copied :" + newVarBind);
        }
        this.varBind.addElement(newVarBind);
    }

    protected void updateResult(SnmpVarBind[] result) {
        int max = this.varBind.size();
        for (int i = 0; i < max; ++i) {
            int index = this.translation[i];
            SnmpVarBind elmt = (SnmpVarBind)((SnmpSubRequestHandler.NonSyncVector)this.varBind).elementAtNonSync(i);
            SnmpVarBind vb = result[index];
            if (vb == null) {
                result[index] = elmt;
                continue;
            }
            SnmpValue val = vb.getSnmpValue();
            if (val == null || val == SnmpVarBind.endOfMibView) {
                if (elmt == null || elmt.getSnmpValue() == SnmpVarBind.endOfMibView) continue;
                result[index] = elmt;
                continue;
            }
            if (elmt == null || elmt.getSnmpValue() == SnmpVarBind.endOfMibView) continue;
            int comp = elmt.getOid().compareTo(vb.getOid());
            if (comp < 0) {
                result[index] = elmt;
                continue;
            }
            if (comp != 0) continue;
            if (this.logger.finestOn()) {
                this.logger.finer("updateResult", " oid overlapping. Oid : " + elmt.getOid() + "value :" + elmt.getSnmpValue());
                this.logger.finer("updateResult", "Already present varBind : " + vb);
            }
            SnmpOid oid = vb.getOid();
            SnmpMibAgent deeperAgent = this.root.getAgentMib(oid);
            if (this.logger.finestOn()) {
                this.logger.finer("updateResult", "Deeper agent : " + deeperAgent);
            }
            if (deeperAgent != this.agent) continue;
            if (this.logger.finestOn()) {
                this.logger.finer("updateResult", "The current agent is the deeper one. Update the value with the current one");
            }
            result[index].setSnmpValue(elmt.getSnmpValue());
        }
    }

    protected String makeDebugTag() {
        return "SnmpSubNextRequestHandler";
    }
}

