/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.internal.snmp;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpJdmkLcd;
import com.sun.management.internal.snmp.SnmpLcd;
import com.sun.management.internal.snmp.SnmpMsgProcessingModel;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSysImpl;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.internal.snmp.SnmpSecurityModel;
import com.sun.management.internal.snmp.SnmpSecurityModelV1V2;
import com.sun.management.internal.snmp.SnmpSecuritySubSysImpl;
import com.sun.management.internal.snmp.SnmpSecuritySubSystem;
import com.sun.management.internal.snmp.SnmpSubSystem;
import com.sun.management.internal.snmp.SnmpUsmKeyHandlerImpl;
import com.sun.management.snmp.InetAddressAcl;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineFactory;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpEngineParameters;
import com.sun.management.snmp.mpm.SnmpMsgProcessingModelV1V2;
import com.sun.management.snmp.mpm.SnmpMsgProcessingModelV3;
import com.sun.management.snmp.usm.SnmpUserSecurityModel;
import com.sun.management.snmp.usm.SnmpUsm;
import com.sun.management.snmp.usm.SnmpUsmAlgorithmManager;
import com.sun.management.snmp.usm.SnmpUsmDesAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmException;
import com.sun.management.snmp.usm.SnmpUsmHmacMd5;
import com.sun.management.snmp.usm.SnmpUsmHmacSha;
import com.sun.management.snmp.usm.SnmpUsmLcd;
import com.sun.management.snmp.usm.SnmpUsmPasswordLcd;
import java.net.UnknownHostException;

public class SnmpBaseEngineFactory
implements SnmpEngineFactory {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "SnmpBaseEngineFactory");
    private String dbgTag = "SnmpBaseEngineFactory";

    public SnmpEngine createEngine(SnmpEngineParameters parameters) throws IllegalArgumentException {
        String securityFile = parameters.getSecurityFile();
        SnmpEngineId engineid = parameters.getEngineId();
        SnmpLcd lcd = this.createEngineLcd(securityFile);
        SnmpEngineImpl engine = null;
        try {
            engine = new SnmpEngineImpl((SnmpEngineFactory)this, lcd, engineid);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unknown host: " + e.getMessage());
        }
        this.init(parameters, engine, lcd);
        return engine;
    }

    public SnmpEngine createEngine(SnmpEngineParameters p, InetAddressAcl ipacl) {
        return this.createEngine(p);
    }

    protected SnmpLcd createEngineLcd(String file) throws IllegalArgumentException {
        return new SnmpJdmkLcd(file);
    }

    protected SnmpUsmAlgorithmManager createAlgorithmManager(SnmpEngine engine) {
        return new SnmpUsmAlgorithmManager();
    }

    protected SnmpSecuritySubSystem createSecuritySubSystem(SnmpEngine engine) {
        return new SnmpSecuritySubSysImpl(engine);
    }

    protected SnmpMsgProcessingSubSystem createMsgProcessingSubSystem(SnmpEngine engine) {
        return new SnmpMsgProcessingSubSysImpl(engine);
    }

    protected SnmpUsmLcd createUsmLcd(SnmpEngine engine, SnmpLcd lcd, SnmpSecuritySubSystem securSys, String file) throws IllegalArgumentException {
        return new SnmpUsmPasswordLcd(engine, securSys, lcd, file);
    }

    protected SnmpUsm createUsmSecurityModel(SnmpEngine engine, SnmpUsmLcd usmlcd, SnmpSecuritySubSystem subSys) {
        SnmpUserSecurityModel ubm = new SnmpUserSecurityModel((SnmpSubSystem)subSys, usmlcd);
        return ubm;
    }

    void fillAlgorithmManager(SnmpEngineParameters parameters, SnmpUsmAlgorithmManager algoManager, SnmpEngineImpl engine) {
        if (algoManager.getAlgorithm("usmHMACMD5AuthProtocol") == null) {
            algoManager.addAlgorithm(new SnmpUsmHmacMd5());
        }
        if (algoManager.getAlgorithm("usmHMACSHAAuthProtocol") == null) {
            algoManager.addAlgorithm(new SnmpUsmHmacSha());
        }
        if (parameters.isEncryptionEnabled()) {
            block8: {
                if (logger.finestOn()) {
                    logger.finest("init", "Usm encryption activated.");
                }
                try {
                    if (algoManager.getAlgorithm("usmDESPrivProtocol") == null) {
                        algoManager.addAlgorithm(new SnmpUsmDesAlgorithm(engine));
                    }
                }
                catch (SnmpUsmException e) {
                    if (!logger.finerOn()) break block8;
                    logger.finer("init", "Problemm initializing encryption, check your classpath: " + e.toString());
                }
            }
            if (logger.finestOn()) {
                logger.finest("init", "Usm encryption algos added.");
            }
        }
    }

    protected SnmpSecurityModel createCommunityStringSecurityModel(SnmpEngine engine, SnmpSecuritySubSystem subSys) {
        return new SnmpSecurityModelV1V2(subSys);
    }

    protected SnmpMsgProcessingModel createSnmpV1MsgProcessingModel(SnmpEngine engine, SnmpMsgProcessingSubSystem subSys) {
        return new SnmpMsgProcessingModelV1V2(subSys, null);
    }

    protected SnmpMsgProcessingModel createSnmpV2MsgProcessingModel(SnmpEngine engine, SnmpMsgProcessingSubSystem subSys, SnmpMsgProcessingModel v1mpm) {
        return v1mpm;
    }

    protected SnmpMsgProcessingModel createSnmpV3MsgProcessingModel(SnmpEngine engine, SnmpMsgProcessingSubSystem subSys, SnmpMsgProcessingModel v2mpm) {
        return new SnmpMsgProcessingModelV3(subSys, null);
    }

    private void init(SnmpEngineParameters p, SnmpEngineImpl engine, SnmpLcd lcd) {
        if (logger.finestOn()) {
            logger.finest("init", "Starting...");
        }
        SnmpSecuritySubSystem securSys = this.createSecuritySubSystem(engine);
        SnmpMsgProcessingSubSystem mpmSys = this.createMsgProcessingSubSystem(engine);
        mpmSys.setSecuritySubSystem(securSys);
        engine.setSecuritySubSystem(securSys);
        engine.setMsgProcessingSubSystem(mpmSys);
        if (logger.finestOn()) {
            logger.finest("init", "Sub Systems created.");
        }
        SnmpUsmLcd usmlcd = this.createUsmLcd(engine, lcd, securSys, p.getSecurityFile());
        lcd.addModelLcd(securSys, 3, usmlcd);
        if (logger.finestOn()) {
            logger.finest("init", "Usm Lcd added.");
        }
        SnmpUsm ubm = this.createUsmSecurityModel(engine, usmlcd, securSys);
        SnmpSecurityModel v1v2model = this.createCommunityStringSecurityModel(engine, securSys);
        if (logger.finestOn()) {
            logger.finest("init", "Security models V1 V2 v3 added.");
        }
        SnmpUsmAlgorithmManager algoManager = this.createAlgorithmManager(engine);
        this.fillAlgorithmManager(p, algoManager, engine);
        if (logger.finestOn()) {
            logger.finest("init", "Usm algos added.");
        }
        usmlcd.setAlgorithmManager(algoManager);
        usmlcd.syncDataSource();
        if (logger.finestOn()) {
            logger.finest("init", "Usm configuration sync.");
        }
        SnmpMsgProcessingModel msgV1 = this.createSnmpV1MsgProcessingModel(engine, mpmSys);
        SnmpMsgProcessingModel msgV2 = this.createSnmpV2MsgProcessingModel(engine, mpmSys, msgV1);
        if (logger.finestOn()) {
            logger.finest("init", "V1 V2 processing model added. Can speak V1V2");
        }
        SnmpMsgProcessingModel msgV3 = null;
        msgV3 = this.createSnmpV3MsgProcessingModel(engine, mpmSys, msgV2);
        if (logger.finestOn()) {
            logger.finest("init", "V3 processing model added. Can speak V3");
        }
        SnmpUsmKeyHandlerImpl usmKeyHandler = new SnmpUsmKeyHandlerImpl(algoManager);
        engine.setUsmKeyHandler(usmKeyHandler);
    }
}

