/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.IPAcl;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.IPAcl.PrincipalImpl;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Vector;

class NetMaskImpl
extends PrincipalImpl
implements Group,
Serializable {
    private static final long serialVersionUID = 7409889974102413924L;
    protected byte[] subnet = null;
    protected int prefix = -1;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "NetMaskImpl");
    String dbgTag = "NetMaskImpl";

    public NetMaskImpl() throws UnknownHostException {
    }

    private byte[] extractSubNet(byte[] b) {
        int fullyCoveredByte;
        int addrLength = b.length;
        byte[] subnet = null;
        if (logger.finestOn()) {
            logger.finest("extractSubNet", "BINARY ARRAY :");
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < addrLength; ++i) {
                buff.append((b[i] & 0xFF) + ":");
            }
            logger.finest("extractSubNet", buff.toString());
        }
        if ((fullyCoveredByte = this.prefix / 8) == addrLength) {
            if (logger.finestOn()) {
                logger.finest("extractSubNet", " The mask is the complete address, strange..." + addrLength);
            }
            subnet = b;
            return subnet;
        }
        if (fullyCoveredByte > addrLength) {
            if (logger.finestOn()) {
                logger.finest("extractSubNet", " The number of covered byte is longer than the address. BUG");
            }
            throw new IllegalArgumentException("The number of covered byte is longer than the address.");
        }
        int partialyCoveredIndex = fullyCoveredByte;
        if (logger.finestOn()) {
            logger.finest("extractSubNet", " Partialy covered index : " + partialyCoveredIndex);
        }
        byte toDeal = b[partialyCoveredIndex];
        if (logger.finestOn()) {
            logger.finest("extractSubNet", " Partialy covered byte : " + toDeal);
        }
        int nbbits = this.prefix % 8;
        int subnetSize = 0;
        subnetSize = nbbits == 0 ? partialyCoveredIndex : partialyCoveredIndex + 1;
        if (logger.finestOn()) {
            logger.finest("extractSubNet", " Remains : " + nbbits);
        }
        byte mask = 0;
        for (int i = 0; i < nbbits; ++i) {
            mask = (byte)(mask | 1 << 7 - i);
        }
        if (logger.finestOn()) {
            logger.finest("extractSubNet", "Mask value" + (mask & 0xFF));
        }
        byte maskedValue = (byte)(toDeal & mask);
        if (logger.finestOn()) {
            logger.finest("extractSubNet", "Masked byte :" + (maskedValue & 0xFF));
        }
        subnet = new byte[subnetSize];
        if (logger.finestOn()) {
            logger.finest("extractSubNet", "Resulting subnet : ");
        }
        for (int i = 0; i < partialyCoveredIndex; ++i) {
            subnet[i] = b[i];
            if (!logger.finestOn()) continue;
            logger.finest("extractSubNet", (subnet[i] & 0xFF) + ":");
        }
        if (nbbits != 0) {
            subnet[partialyCoveredIndex] = maskedValue;
            if (logger.finestOn()) {
                logger.finest("extractSubNet", " Last subnet byte : " + (subnet[partialyCoveredIndex] & 0xFF));
            }
        }
        return subnet;
    }

    public NetMaskImpl(String hostname, int prefix) throws UnknownHostException {
        super(hostname);
        this.prefix = prefix;
        this.subnet = this.extractSubNet(this.getAddress().getAddress());
    }

    public boolean addMember(Principal p) {
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object p) {
        if (p instanceof PrincipalImpl || p instanceof NetMaskImpl) {
            PrincipalImpl received = (PrincipalImpl)p;
            InetAddress addr = received.getAddress();
            if (logger.finestOn()) {
                logger.finest("equals", "Received Address : " + addr);
            }
            byte[] recAddr = addr.getAddress();
            for (int i = 0; i < this.subnet.length; ++i) {
                if (logger.finestOn()) {
                    logger.finest("equals", "(recAddr[i]) :" + (recAddr[i] & 0xFF));
                    logger.finest("equals", "(recAddr[i] & subnet[i]) :" + (recAddr[i] & this.subnet[i] & 0xFF) + "subnet[i] :" + (this.subnet[i] & 0xFF));
                }
                if ((recAddr[i] & this.subnet[i]) == this.subnet[i]) continue;
                if (logger.finestOn()) {
                    logger.finest("equals", "FALSE");
                }
                return false;
            }
            if (logger.finestOn()) {
                logger.finest("equals", "TRUE");
            }
            return true;
        }
        return false;
    }

    public boolean isMember(Principal p) {
        return (((Object)p).hashCode() & super.hashCode()) == ((Object)p).hashCode();
    }

    public Enumeration members() {
        Vector<NetMaskImpl> v = new Vector<NetMaskImpl>(1);
        v.addElement(this);
        return v.elements();
    }

    public boolean removeMember(Principal p) {
        return true;
    }

    public String toString() {
        return "NetMaskImpl :" + super.getAddress().toString() + "/" + this.prefix;
    }
}

