/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp;

import com.sun.management.snmp.SnmpTimeticks;
import java.io.Serializable;
import java.util.Date;

public class Timestamp
implements Serializable {
    private static final long serialVersionUID = -7237553204610388243L;
    private long sysUpTime;
    private long crtime;
    private Date dateCache = null;
    private SnmpTimeticks uptimeCache = null;

    public Timestamp() {
        this.crtime = System.currentTimeMillis();
    }

    public Timestamp(long uptime, long when) {
        this.sysUpTime = uptime;
        this.crtime = when;
    }

    public Timestamp(long uptime) {
        this.sysUpTime = uptime;
        this.crtime = System.currentTimeMillis();
    }

    public final synchronized SnmpTimeticks getTimeTicks() {
        if (this.uptimeCache == null) {
            this.uptimeCache = new SnmpTimeticks((int)this.sysUpTime);
        }
        return this.uptimeCache;
    }

    public final long getSysUpTime() {
        return this.sysUpTime;
    }

    public final synchronized Date getDate() {
        if (this.dateCache == null) {
            this.dateCache = new Date(this.crtime);
        }
        return this.dateCache;
    }

    public final long getDateTime() {
        return this.crtime;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{SysUpTime = " + SnmpTimeticks.printTimeTicks(this.sysUpTime));
        buf.append("} {Timestamp = " + this.getDate().toString() + "}");
        return buf.toString();
    }
}

