/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.mpm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpDecryptedPdu;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpIncomingRequest;
import com.sun.management.internal.snmp.SnmpSecurityCache;
import com.sun.management.internal.snmp.SnmpSecuritySubSystem;
import com.sun.management.snmp.SnmpBadSecurityLevelException;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpScopedPduRequest;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.SnmpSecurityParameters;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpUnknownSecModelException;
import com.sun.management.snmp.mpm.SnmpMsgTranslator;
import java.net.InetAddress;

class SnmpIncomingRequestImpl
implements SnmpIncomingRequest {
    SnmpMsg req = null;
    SnmpMsg resp = null;
    SnmpSecuritySubSystem secureSubSys = null;
    SnmpMsgTranslator translator = null;
    String principal = null;
    SnmpSecurityCache cache = null;
    boolean isReport = false;
    boolean isResponse = true;
    SnmpSecurityParameters secParams = null;
    SnmpPduFactory factory = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpIncomingRequestImpl");
    String dbgTag = "SnmpIncomingRequestImpl";

    public SnmpIncomingRequestImpl(SnmpSecuritySubSystem secureSubSys, SnmpPduFactory factory, SnmpMsg req, SnmpMsg resp, SnmpMsgTranslator translator) {
        this.secureSubSys = secureSubSys;
        this.factory = factory;
        this.req = req;
        this.resp = resp;
        this.translator = translator;
    }

    public SnmpSecurityParameters getSecurityParameters() {
        return this.secParams;
    }

    public boolean isReport() {
        return this.isReport;
    }

    public boolean isResponse() {
        return this.isResponse;
    }

    public void noResponse() {
        this.isResponse = false;
    }

    public int getSecurityLevel() {
        return this.translator.getSecurityLevel(this.req);
    }

    public byte[] getContextEngineId() {
        return this.translator.getContextEngineId(this.req);
    }

    public int getSecurityModel() {
        return this.translator.getMsgSecurityModel(this.req);
    }

    private void handleReport(SnmpMsg msg, SnmpSecurityException e) throws SnmpStatusException {
        if ((this.translator.getMsgFlags(msg) & 2) != 0) {
            if ((this.translator.getMsgFlags(msg) & 4) != 0) {
                if (logger.finestOn()) {
                    logger.finest("handleReport", "Report to send. Encryption + flag set");
                }
                this.constructReport(msg, e, null);
                return;
            }
            if (logger.finestOn()) {
                logger.finest("handleReport", "No Report to send. No flag set");
            }
            throw new SnmpStatusException("Security failed");
        }
        SnmpPdu pdu = this.factory.decodeSnmpPdu(msg);
        if (pdu == null && (this.translator.getMsgFlags(msg) & 4) != 0) {
            if (logger.finestOn()) {
                logger.finest("handleReport", "Can't decode pdu. Flag set");
            }
            this.constructReport(msg, e, null);
            return;
        }
        if (pdu.type != 160 && pdu.type != 161 && pdu.type != 163 && pdu.type != 165 && pdu.type != 166) {
            if (logger.finestOn()) {
                logger.finest("handleReport", "Not a confirmed pdu class [ " + pdu.type + "]. No report to send");
            }
            throw new SnmpStatusException("Security failed");
        }
        this.constructReport(this.req, e, pdu);
    }

    private void constructReport(SnmpMsg msg, SnmpSecurityException e, SnmpPdu p) throws SnmpStatusException {
        if (logger.finerOn()) {
            logger.finer("constructReport", "Report to send. Exception: " + e + " Security parameters : " + e.params);
        }
        this.isReport = true;
        SnmpScopedPduRequest pdu = new SnmpScopedPduRequest();
        pdu.address = msg.address;
        pdu.port = msg.port;
        if (p != null) {
            pdu.requestId = p.requestId;
        }
        pdu.version = 3;
        pdu.msgId = this.translator.getMsgId(msg);
        pdu.type = 168;
        pdu.varBindList = e.list;
        pdu.contextEngineId = e.contextEngineId;
        pdu.contextName = e.contextName;
        pdu.msgFlags = (byte)(e.flags & 3);
        pdu.msgMaxSize = this.translator.getMsgMaxSize(msg);
        pdu.msgSecurityModel = this.translator.getMsgSecurityModel(msg);
        pdu.securityParameters = e.params;
        if (logger.finerOn()) {
            logger.finer("constructReport", " Security parameters : " + pdu.securityParameters);
        }
        pdu.setErrorIndex(0);
        pdu.setErrorStatus(0);
        try {
            this.resp.encodeSnmpPdu(pdu, this.translator.getMsgMaxSize(msg));
        }
        catch (SnmpTooBigException ex) {
            throw new SnmpStatusException("Too Big when sending report");
        }
    }

    public byte[] getContextName() {
        return this.translator.getContextName(this.req);
    }

    public byte[] getAccessContext() {
        return this.translator.getAccessContext(this.req);
    }

    public String getPrincipal() {
        return this.secParams.getPrincipal();
    }

    public int encodeMessage(byte[] outputBytes) throws SnmpTooBigException {
        int encodingLength = 0;
        try {
            encodingLength = this.secureSubSys.generateResponseMsg(this.cache, this.resp.version, this.translator.getMsgId(this.resp), this.translator.getMsgMaxSize(this.resp), (byte)(this.translator.getMsgFlags(this.resp) & 3), this.translator.getMsgSecurityModel(this.resp), this.translator.getSecurityParameters(this.resp), this.translator.getContextEngineId(this.resp), this.translator.getRawContextName(this.resp), this.resp.data, this.resp.dataLength, outputBytes);
            this.secureSubSys.releaseSecurityCache(this.translator.getMsgSecurityModel(this.req), this.cache);
        }
        catch (SnmpStatusException e) {
            this.isResponse = false;
        }
        catch (SnmpSecurityException x) {
            this.isResponse = false;
        }
        catch (SnmpUnknownSecModelException y) {
            this.isResponse = false;
        }
        return encodingLength;
    }

    public void decodeMessage(byte[] inputBytes, int byteCount, InetAddress address, int port) throws SnmpStatusException, SnmpUnknownSecModelException, SnmpBadSecurityLevelException {
        this.req.address = address;
        this.req.port = port;
        this.req.decodeMessage(inputBytes, byteCount);
        this.cache = this.secureSubSys.createSecurityCache(this.translator.getMsgSecurityModel(this.req));
        SnmpDecryptedPdu decrPdu = new SnmpDecryptedPdu();
        SnmpEngineImpl.checkSecurityLevel(this.translator.getMsgFlags(this.req));
        try {
            this.secParams = this.secureSubSys.processIncomingRequest(this.cache, this.req.version, this.translator.getMsgId(this.req), this.translator.getMsgMaxSize(this.req), this.translator.getMsgFlags(this.req), this.translator.getMsgSecurityModel(this.req), this.translator.getFlatSecurityParameters(this.req), this.translator.getContextEngineId(this.req), this.translator.getContextName(this.req), this.req.data, this.translator.getEncryptedPdu(this.req), decrPdu);
        }
        catch (SnmpSecurityException e) {
            if (logger.finestOn()) {
                logger.finest("decodeMessage", "Security error: " + e + ", Msg flags: " + this.translator.getMsgFlags(this.req));
            }
            this.isResponse = false;
            this.handleReport(this.req, e);
            return;
        }
        catch (SnmpStatusException ex) {
            this.isResponse = false;
            throw ex;
        }
        this.req.securityParameters = this.secParams;
        if (decrPdu.data != null) {
            this.req.data = decrPdu.data;
            this.translator.setContextName(this.req, decrPdu.contextName);
            this.translator.setContextEngineId(this.req, decrPdu.contextEngineId);
        }
    }

    public SnmpMsg encodeSnmpPdu(SnmpPdu p, int maxDataLength) throws SnmpStatusException, SnmpTooBigException {
        this.resp = this.factory.encodeSnmpPdu(p, maxDataLength);
        return this.resp;
    }

    public SnmpPdu decodeSnmpPdu() throws SnmpStatusException {
        return this.factory.decodeSnmpPdu(this.req);
    }

    public String printRequestMessage() {
        return this.req.printMessage();
    }

    public String printResponseMessage() {
        return this.resp.printMessage();
    }
}

