/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.management.snmp.SnmpCounter;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.usm.SnmpUserSecurityModel;
import com.sun.management.snmp.usm.SnmpUsmSecurityParameters;

class SnmpUsmExceptionGenerator {
    SnmpUserSecurityModel model = null;

    SnmpUsmExceptionGenerator(SnmpUserSecurityModel model) {
        this.model = model;
    }

    void genSecurityException(String oid, String msg, byte[] contextEngineId, byte[] contextName, byte msgFlags, SnmpUsmSecurityParameters params) throws SnmpSecurityException, SnmpStatusException {
        SnmpVarBind varbind = new SnmpVarBind(oid);
        SnmpVarBind[] l = new SnmpVarBind[]{varbind};
        varbind.setSnmpValue(new SnmpCounter(this.model.getNotInTimeWindowsCounter().intValue()));
        SnmpSecurityException ex = new SnmpSecurityException(msg);
        ex.list = l;
        ex.params = params;
        ex.contextEngineId = contextEngineId;
        ex.contextName = contextName;
        ex.flags = (byte)(msgFlags & 4);
        throw ex;
    }

    void genTimeWindowException(byte[] contextEngineId, byte[] contextName, byte msgFlags, SnmpUsmSecurityParameters params) throws SnmpSecurityException, SnmpStatusException {
        SnmpVarBind varbind = new SnmpVarBind("1.3.6.1.6.3.15.1.1.2.0");
        SnmpVarBind[] l = new SnmpVarBind[]{varbind};
        varbind.setSnmpValue(new SnmpCounter(this.model.incNotInTimeWindowsCounter(1)));
        SnmpSecurityException ex = new SnmpSecurityException("notInTimeWindow");
        ex.list = l;
        ex.params = params;
        ex.contextEngineId = contextEngineId;
        ex.contextName = contextName;
        ex.flags = (byte)5;
        throw ex;
    }

    void genEngineIdException(byte[] contextEngineId, byte[] contextName, byte msgFlags, SnmpUsmSecurityParameters params) throws SnmpSecurityException, SnmpStatusException {
        SnmpVarBind varbind = new SnmpVarBind("1.3.6.1.6.3.15.1.1.4.0");
        SnmpVarBind[] l = new SnmpVarBind[]{varbind};
        varbind.setSnmpValue(new SnmpCounter(this.model.incUnknownEngineIdsCounter(1)));
        SnmpSecurityException ex = new SnmpSecurityException("unknownEngineId");
        ex.list = l;
        ex.params = params;
        ex.contextEngineId = contextEngineId;
        ex.contextName = contextName;
        ex.flags = (byte)(msgFlags & 4);
        throw ex;
    }

    void genAuthenticationException(byte[] contextEngineId, byte[] contextName, byte msgFlags, SnmpUsmSecurityParameters params) throws SnmpSecurityException, SnmpStatusException {
        SnmpVarBind varbind = new SnmpVarBind("1.3.6.1.6.3.15.1.1.5.0");
        SnmpVarBind[] l = new SnmpVarBind[]{varbind};
        varbind.setSnmpValue(new SnmpCounter(this.model.incWrongDigestsCounter(1)));
        SnmpSecurityException ex = new SnmpSecurityException("authenticationFailure");
        ex.list = l;
        ex.params = params;
        ex.contextEngineId = contextEngineId;
        ex.contextName = contextName;
        ex.flags = (byte)(msgFlags & 4);
        throw ex;
    }

    void genDecryptionException(byte msgFlags, SnmpUsmSecurityParameters params) throws SnmpSecurityException, SnmpStatusException {
        SnmpVarBind varbind = new SnmpVarBind("1.3.6.1.6.3.15.1.1.6.0");
        SnmpVarBind[] l = new SnmpVarBind[]{varbind};
        varbind.setSnmpValue(new SnmpCounter(this.model.incDecryptionErrorsCounter(1)));
        SnmpSecurityException ex = new SnmpSecurityException("decryptionError");
        ex.list = l;
        ex.params = params;
        ex.flags = (byte)(msgFlags & 4);
        throw ex;
    }

    void genSecurityLevelException(byte[] contextEngineId, byte[] contextName, byte msgFlags, SnmpUsmSecurityParameters params) throws SnmpSecurityException, SnmpStatusException {
        SnmpVarBind varbind = new SnmpVarBind("1.3.6.1.6.3.15.1.1.1.0");
        SnmpVarBind[] l = new SnmpVarBind[]{varbind};
        varbind.setSnmpValue(new SnmpCounter(this.model.incUnsupportedSecLevelsCounter(1)));
        SnmpSecurityException ex = new SnmpSecurityException("unsupportedSecurityLevel");
        ex.list = l;
        ex.params = params;
        ex.contextEngineId = contextEngineId;
        ex.contextName = contextName;
        ex.flags = (byte)(msgFlags & 4);
        throw ex;
    }

    void genUserNameException(byte[] contextEngineId, byte[] contextName, byte msgFlags, SnmpUsmSecurityParameters params) throws SnmpSecurityException, SnmpStatusException {
        SnmpVarBind varbind = new SnmpVarBind("1.3.6.1.6.3.15.1.1.3.0");
        SnmpVarBind[] l = new SnmpVarBind[]{varbind};
        varbind.setSnmpValue(new SnmpCounter(this.model.incUnknownUserNamesCounter(1)));
        SnmpSecurityException ex = new SnmpSecurityException("unknownSecurityName");
        ex.list = l;
        ex.params = params;
        ex.contextEngineId = contextEngineId;
        ex.contextName = contextName;
        ex.flags = (byte)(msgFlags & 4);
        throw ex;
    }
}

