/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm.usmmib;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.EnumRowStatus;
import com.sun.management.snmp.SnmpInt;
import com.sun.management.snmp.SnmpScopedPduPacket;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpString;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpStandardObjectServer;
import com.sun.management.snmp.usm.SnmpUsmAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmAuthPair;
import com.sun.management.snmp.usm.SnmpUsmPrivPair;
import com.sun.management.snmp.usm.SnmpUsmSecureUser;
import com.sun.management.snmp.usm.usmmib.UsmUserEntryImpl;
import com.sun.management.snmp.usm.usmmib.UsmUserEntryMeta;
import java.util.Enumeration;

class UsmUserEntryMetaImpl
extends UsmUserEntryMeta {
    private static final long serialVersionUID = 1380866985476444282L;
    private String dbgTag = "UsmUserEntryMetaImpl";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "UsmUserEntryMetaImpl");

    public UsmUserEntryMetaImpl(SnmpMib myMib, SnmpStandardObjectServer objserv) {
        super(myMib, objserv);
    }

    public void check(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        SnmpVarBind rowStat;
        boolean setClone = false;
        if (logger.finestOn()) {
            logger.finest("check", "Checking varbind. Depth : " + depth);
        }
        if ((rowStat = req.getRowStatusVarBind()) != null) {
            int val;
            int e;
            if (logger.finestOn()) {
                logger.finest("check", "Row status : " + rowStat);
            }
            if ((e = new EnumRowStatus("destroy").intValue()) == (val = ((SnmpInt)rowStat.getSnmpValue()).intValue())) {
                UsmUserEntryImpl ent;
                if (logger.finestOn()) {
                    logger.finest("check", "Destroy Row status .");
                }
                if ((ent = (UsmUserEntryImpl)this.node).getUsmUserStorageType().toString().equals("permanent") || ent.getUsmUserStorageType().toString().equals("readOnly")) {
                    if (logger.finestOn()) {
                        logger.finest("check", "Illegal storage type.");
                    }
                    throw new SnmpStatusException(6);
                }
            }
        } else if (logger.finestOn()) {
            logger.finest("check", "Row status is null");
        }
        Enumeration e = req.getElements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = (SnmpVarBind)e.nextElement();
            if (var.getOid().getOidArc(depth) != 4L) continue;
            if (logger.finestOn()) {
                logger.finest("check", "setClone = true");
            }
            setClone = true;
            break;
        }
        SnmpVarBind authKeyChange = null;
        SnmpVarBind privKeyChange = null;
        SnmpVarBind random = null;
        UsmUserEntryImpl ent = (UsmUserEntryImpl)this.node;
        SnmpUsmSecureUser user = ent.getUser();
        Enumeration e2 = req.getElements();
        while (e2.hasMoreElements()) {
            SnmpVarBind var = (SnmpVarBind)e2.nextElement();
            int arc = (int)var.getOid().getOidArc(depth);
            if (logger.finestOn()) {
                logger.finest("check", "checking OID arc : " + arc);
            }
            if (arc == 6 || arc == 7) {
                authKeyChange = var;
            }
            if (arc == 9 || arc == 10) {
                privKeyChange = var;
            }
            if (arc == 11) {
                random = var;
            }
            if (arc != 7 && arc != 10) continue;
            if (logger.finestOn()) {
                logger.finest("check", "User : " + user.getName());
            }
            SnmpScopedPduPacket p = (SnmpScopedPduPacket)req.getPdu();
            String principal = p.securityParameters.getPrincipal();
            if (logger.finestOn()) {
                logger.finest("check", "Principal : " + principal + " Security model : " + p.msgSecurityModel);
            }
            int msgSecurityModel = p.msgSecurityModel;
            if (!principal.equals(user.getName())) {
                if (logger.finestOn()) {
                    logger.finest("check", "Principal are not equals : " + principal + " / " + user.getName());
                }
                throw new SnmpStatusException(6);
            }
            if (msgSecurityModel == 3) continue;
            if (logger.finestOn()) {
                logger.finest("check", "Security model is not usm: " + msgSecurityModel);
            }
            throw new SnmpStatusException(6);
        }
        if (random != null) {
            int expectedSize;
            SnmpUsmPrivPair p;
            SnmpUsmAlgorithm a;
            SnmpString val = (SnmpString)random.getSnmpValue();
            int received = val.byteValue().length;
            if (authKeyChange != null) {
                int expectedSize2;
                SnmpUsmAuthPair p2 = user.getAuthPair();
                if (p2 != null && (a = p2.algo) != null && received != (expectedSize2 = a.getDeltaSize())) {
                    if (logger.finestOn()) {
                        logger.finest("check", "Wrong random size for authKeyChange");
                    }
                    if (logger.finestOn()) {
                        logger.finest("check", "expected : " + expectedSize2 + "received : " + received);
                    }
                    throw new SnmpStatusException(10);
                }
            } else if (privKeyChange != null && (p = user.getPrivPair()) != null && (a = p.algo) != null && received != (expectedSize = a.getDeltaSize())) {
                if (logger.finestOn()) {
                    logger.finest("check", "Wrong random size for privKeyChange");
                }
                if (logger.finestOn()) {
                    logger.finest("check", "expected : " + expectedSize + "received : " + received);
                }
                throw new SnmpStatusException(10);
            }
        }
        if (logger.finestOn()) {
            logger.finest("check", "Calling super.");
        }
        super.check(req, depth);
        if (logger.finestOn()) {
            logger.finest("check", "Done.");
        }
    }

    public void set(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        Enumeration e = req.getElements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = (SnmpVarBind)e.nextElement();
            int arc = (int)var.getOid().getOidArc(depth);
            if (logger.finestOn()) {
                logger.finest("check", "checking OID arc : " + arc);
            }
            if (arc != 11) continue;
            if (logger.finestOn()) {
                logger.finest("check", "Found usmUserPublic, must be set before keychange.");
            }
            this.node.setUsmUserPublic(((SnmpString)var.getSnmpValue()).toByte());
        }
        if (logger.finestOn()) {
            logger.finest("set", "Calling super.");
        }
        super.set(req, depth);
        if (logger.finestOn()) {
            logger.finest("set", "Updating lcd.");
        }
        SnmpUsmSecureUser user = ((UsmUserEntryImpl)this.node).getUser();
        user.updateConfiguration();
        if (logger.finestOn()) {
            logger.finest("set", "Lcd updated.");
        }
    }
}

