/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintDescriptor;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.UnexpectedTypeException;
import javax.validation.ValidationException;
import org.hibernate.validation.AmbiguousConstraintUsageException;
import org.hibernate.validation.engine.ConstraintViolationImpl;
import org.hibernate.validation.engine.ExecutionContext;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.ValidatorTypeHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintTree<A extends Annotation> {
    private static final Logger log = LoggerFactory.make();
    private final ConstraintTree<?> parent;
    private final List<ConstraintTree<?>> children;
    private final ConstraintDescriptor<A> descriptor;

    public ConstraintTree(ConstraintDescriptor<A> descriptor) {
        this(descriptor, null);
    }

    private ConstraintTree(ConstraintDescriptor<A> descriptor, ConstraintTree<?> parent) {
        this.parent = parent;
        this.descriptor = descriptor;
        Set<ConstraintDescriptor<?>> composingConstraints = descriptor.getComposingConstraints();
        this.children = new ArrayList(composingConstraints.size());
        for (ConstraintDescriptor<?> composingDescriptor : composingConstraints) {
            ConstraintTree<?> treeNode = this.createConstraintTree(composingDescriptor);
            this.children.add(treeNode);
        }
    }

    private <U extends Annotation> ConstraintTree<U> createConstraintTree(ConstraintDescriptor<U> composingDescriptor) {
        return new ConstraintTree<U>(composingDescriptor, this);
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public ConstraintTree getParent() {
        return this.parent;
    }

    public List<ConstraintTree<?>> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public ConstraintDescriptor<A> getDescriptor() {
        return this.descriptor;
    }

    public <T, V> void validateConstraints(V value, ExecutionContext<T> executionContext, List<ConstraintViolationImpl<T>> constraintViolations) {
        for (ConstraintTree<?> tree : this.getChildren()) {
            tree.validateConstraints(value, executionContext, constraintViolations);
        }
        if (log.isTraceEnabled()) {
            log.trace("Validating value {} against constraint defined by {}", value, this.descriptor);
        }
        ConstraintValidator<A, V> validator = this.getInitalizedValidator(value, executionContext.getConstraintValidatorFactory());
        executionContext.setCurrentConstraintDescriptor(this.descriptor);
        if (!validator.isValid(value, executionContext)) {
            constraintViolations.addAll(executionContext.createConstraintViolations(value));
        }
        if (this.reportAsSingleViolation() && constraintViolations.size() > 0) {
            constraintViolations.clear();
            String message = (String)this.getParent().getDescriptor().getParameters().get("message");
            String property = executionContext.peekPropertyPath();
            ExecutionContext<T> executionContext2 = executionContext;
            executionContext2.getClass();
            ExecutionContext.ErrorMessage error = new ExecutionContext.ErrorMessage(executionContext2, message, property);
            constraintViolations.add(executionContext.createConstraintViolation(value, error));
        }
    }

    private boolean reportAsSingleViolation() {
        return this.getParent() != null && this.getParent().getDescriptor().isReportAsSingleViolation();
    }

    private <V> ConstraintValidator<A, V> getInitalizedValidator(Object value, ConstraintValidatorFactory constraintFactory) {
        Class<ConstraintValidator<Object, ?>> validatorClass = value == null ? this.descriptor.getConstraintValidatorClasses().get(0) : this.findMatchingValidatorClass(value);
        ConstraintValidator<?, ?> constraintValidator = constraintFactory.getInstance(validatorClass);
        this.initializeConstraint(this.descriptor, constraintValidator);
        return constraintValidator;
    }

    private Class<? extends ConstraintValidator<?, ?>> findMatchingValidatorClass(Object value) {
        Class valueClass = this.determineValueClass(value);
        Map<Class<?>, Class<ConstraintValidator<?, ?>>> validatorsTypes = ValidatorTypeHelper.getValidatorsTypes(this.descriptor.getConstraintValidatorClasses());
        List<Class> assignableClasses = this.findAssignableClasses(valueClass, validatorsTypes);
        this.resolveAssignableClasses(assignableClasses);
        this.verifyResolveWasUnique(valueClass, assignableClasses);
        return validatorsTypes.get(assignableClasses.get(0));
    }

    private void verifyResolveWasUnique(Class valueClass, List<Class> assignableClasses) {
        if (assignableClasses.size() == 0) {
            throw new UnexpectedTypeException("No validator could be found for type: " + valueClass.getName());
        }
        if (assignableClasses.size() > 1) {
            StringBuilder builder = new StringBuilder();
            builder.append("There are multiple validators which could validate the type ");
            builder.append(valueClass);
            builder.append(". The validator classes are: ");
            for (Class clazz : assignableClasses) {
                builder.append(clazz.getName());
                builder.append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
            throw new AmbiguousConstraintUsageException(builder.toString());
        }
    }

    private List<Class> findAssignableClasses(Class valueClass, Map<Class<?>, Class<? extends ConstraintValidator<?, ?>>> validatorsTypes) {
        ArrayList<Class> assignableClasses = new ArrayList<Class>();
        for (Class<?> clazz : validatorsTypes.keySet()) {
            if (!clazz.isAssignableFrom(valueClass)) continue;
            assignableClasses.add(clazz);
        }
        return assignableClasses;
    }

    private Class determineValueClass(Object value) {
        Class<Object> valueClass = value.getClass();
        if (valueClass.isArray()) {
            valueClass = Array.class;
        }
        return valueClass;
    }

    private void resolveAssignableClasses(List<Class> assignableClasses) {
        if (assignableClasses.size() == 0 || assignableClasses.size() == 1) {
            return;
        }
        ArrayList<Class> classesToRemove = new ArrayList<Class>();
        do {
            classesToRemove.clear();
            Class clazz = assignableClasses.get(0);
            for (int i = 1; i < assignableClasses.size(); ++i) {
                if (clazz.isAssignableFrom(assignableClasses.get(i))) {
                    classesToRemove.add(clazz);
                    continue;
                }
                if (!assignableClasses.get(i).isAssignableFrom(clazz)) continue;
                classesToRemove.add(assignableClasses.get(i));
            }
            assignableClasses.removeAll(classesToRemove);
        } while (classesToRemove.size() > 0);
    }

    private void initializeConstraint(ConstraintDescriptor<A> descriptor, ConstraintValidator constraintValidator) {
        try {
            constraintValidator.initialize(descriptor.getAnnotation());
        }
        catch (RuntimeException e) {
            throw new ValidationException("Unable to intialize " + constraintValidator.getClass().getName(), e);
        }
    }
}

