/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.util;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericConstructor<T> {
    private String typeName;
    private Class<T> resultType;
    private Class<?> type;
    private Class<?>[] signature;
    private Constructor constructor;

    public GenericConstructor(Class<T> type, String className, Class<?> ... signature) {
        this.resultType = type;
        this.typeName = className;
        this.signature = (Class[])signature.clone();
    }

    private synchronized void getConstructor() {
        if (this.type == null || this.constructor == null) {
            try {
                this.type = Class.forName(this.typeName);
                this.constructor = AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor>(){

                    @Override
                    public Constructor run() throws Exception {
                        return GenericConstructor.this.type.getDeclaredConstructor(GenericConstructor.this.signature);
                    }
                });
            }
            catch (Exception exc) {
                Logger.getLogger("org.glassfish.gmbal.util").log(Level.FINE, "Failure in getConstructor", exc);
            }
        }
    }

    public synchronized T create(Object ... args) {
        T result = null;
        for (int ctr = 0; ctr <= 1; ++ctr) {
            this.getConstructor();
            if (this.constructor == null) break;
            try {
                result = this.resultType.cast(this.constructor.newInstance(args));
                break;
            }
            catch (Exception exc) {
                this.constructor = null;
                Logger.getLogger("org.glassfish.gmbal.util").log(Level.WARNING, "Error invoking constructor", exc);
                continue;
            }
        }
        return result;
    }
}

