/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.connectionpool;

import org.glassfish.grizzly.ConnectorHandler;

public class EndpointKey<E> {
    private final Object internalKey;
    private final E endpoint;
    private final E localEndpoint;
    private final ConnectorHandler<E> connectorHandler;

    public EndpointKey(Object internalKey, E endpoint) {
        this(internalKey, endpoint, null, (ConnectorHandler<Object>)null);
    }

    public EndpointKey(Object internalKey, E endpoint, E localEndpoint) {
        this(internalKey, endpoint, localEndpoint, null);
    }

    public EndpointKey(Object internalKey, E endpoint, ConnectorHandler<E> connectorHandler) {
        this(internalKey, endpoint, null, (ConnectorHandler<Object>)connectorHandler);
    }

    public EndpointKey(Object internalKey, E endpoint, E localEndpoint, ConnectorHandler<E> connectorHandler) {
        this.internalKey = internalKey;
        this.endpoint = endpoint;
        this.localEndpoint = localEndpoint;
        this.connectorHandler = connectorHandler;
    }

    public Object getInternalKey() {
        return this.internalKey;
    }

    public E getEndpoint() {
        return this.endpoint;
    }

    public E getLocalEndpoint() {
        return this.localEndpoint;
    }

    public ConnectorHandler<E> getConnectorHandler() {
        return this.connectorHandler;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointKey that = (EndpointKey)o;
        if (!this.endpoint.equals(that.endpoint)) {
            return false;
        }
        if (!this.internalKey.equals(that.internalKey)) {
            return false;
        }
        return !(this.localEndpoint != null ? !this.localEndpoint.equals(that.localEndpoint) : that.localEndpoint != null);
    }

    public int hashCode() {
        int result = this.internalKey.hashCode();
        result = 31 * result + this.endpoint.hashCode();
        result = 31 * result + (this.localEndpoint != null ? this.localEndpoint.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EndpointKey{internalKey=" + this.internalKey + ", endpoint=" + this.endpoint + ", localEndpoint=" + this.localEndpoint + ", connectorHandler=" + this.connectorHandler + "} " + super.toString();
    }
}

