/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.connectionpool;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectorHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.connectionpool.Chain;
import org.glassfish.grizzly.connectionpool.ConnectionInfo;
import org.glassfish.grizzly.connectionpool.EndpointKey;
import org.glassfish.grizzly.connectionpool.Link;
import org.glassfish.grizzly.connectionpool.SingleEndpointPool;
import org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.utils.DataStructures;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.Futures;

public class MultiEndpointPool<E> {
    private static final Logger LOGGER = Grizzly.logger(MultiEndpointPool.class);
    protected final Map<EndpointKey<E>, SingleEndpointPool<E>> endpointToPoolMap = DataStructures.getConcurrentMap();
    private final Map<Connection, ConnectionInfo<E>> connectionToSubPoolMap = DataStructures.getConcurrentMap();
    protected final Object poolSync = new Object();
    private final Object countersSync = new Object();
    private boolean isClosed;
    private int poolSize;
    private int totalPendingConnections;
    private final Chain<EndpointPoolImpl> maxPoolSizeHitsChain = new Chain();
    private final ExecutorService ownDelayedExecutorThreadPool;
    private final DelayedExecutor ownDelayedExecutor;
    private final DelayedExecutor.DelayQueue<SingleEndpointPool.ConnectTimeoutTask> connectTimeoutQueue;
    private final DelayedExecutor.DelayQueue<SingleEndpointPool.ReconnectTask> reconnectQueue;
    private final DelayedExecutor.DelayQueue<SingleEndpointPool.KeepAliveCleanerTask> keepAliveCleanerQueue;
    private final ConnectorHandler<E> defaultConnectorHandler;
    private final int maxConnectionsPerEndpoint;
    private final int maxConnectionsTotal;
    private final long connectTimeoutMillis;
    private final long reconnectDelayMillis;
    private final long keepAliveTimeoutMillis;
    private final long keepAliveCheckIntervalMillis;
    private final int maxReconnectAttempts;

    public static <T> Builder<T> builder(Class<T> endpointType) {
        return new Builder();
    }

    protected MultiEndpointPool(ConnectorHandler<E> defaultConnectorHandler, int maxConnectionsPerEndpoint, int maxConnectionsTotal, DelayedExecutor delayedExecutor, long connectTimeoutMillis, long keepAliveTimeoutMillis, long keepAliveCheckIntervalMillis, long reconnectDelayMillis, int maxReconnectAttempts) {
        this.defaultConnectorHandler = defaultConnectorHandler;
        this.maxConnectionsPerEndpoint = maxConnectionsPerEndpoint;
        this.maxConnectionsTotal = maxConnectionsTotal;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.reconnectDelayMillis = reconnectDelayMillis;
        this.keepAliveTimeoutMillis = keepAliveTimeoutMillis;
        this.keepAliveCheckIntervalMillis = keepAliveCheckIntervalMillis;
        this.maxReconnectAttempts = maxReconnectAttempts;
        if (delayedExecutor == null) {
            ThreadPoolConfig tpc = ThreadPoolConfig.defaultConfig().setPoolName("connection-pool-delays-thread-pool").setCorePoolSize(1).setMaxPoolSize(1);
            this.ownDelayedExecutorThreadPool = GrizzlyExecutorService.createInstance((ThreadPoolConfig)tpc);
            this.ownDelayedExecutor = new DelayedExecutor(this.ownDelayedExecutorThreadPool);
            this.ownDelayedExecutor.start();
            delayedExecutor = this.ownDelayedExecutor;
        } else {
            this.ownDelayedExecutorThreadPool = null;
            this.ownDelayedExecutor = null;
        }
        this.connectTimeoutQueue = connectTimeoutMillis >= 0L ? delayedExecutor.createDelayQueue((DelayedExecutor.Worker)new SingleEndpointPool.ConnectTimeoutWorker(), (DelayedExecutor.Resolver)new SingleEndpointPool.ConnectTimeoutTaskResolver()) : null;
        this.reconnectQueue = reconnectDelayMillis >= 0L ? delayedExecutor.createDelayQueue((DelayedExecutor.Worker)new SingleEndpointPool.Reconnector(), (DelayedExecutor.Resolver)new SingleEndpointPool.ReconnectTaskResolver()) : null;
        this.keepAliveCleanerQueue = keepAliveTimeoutMillis >= 0L ? delayedExecutor.createDelayQueue((DelayedExecutor.Worker)new SingleEndpointPool.KeepAliveCleaner(), (DelayedExecutor.Resolver)new SingleEndpointPool.KeepAliveCleanerTaskResolver()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.countersSync;
        synchronized (object) {
            return this.poolSize + this.totalPendingConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOpenConnectionsCount() {
        Object object = this.countersSync;
        synchronized (object) {
            return this.poolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMaxCapacityReached() {
        Object object = this.countersSync;
        synchronized (object) {
            return this.maxConnectionsTotal != -1 && this.poolSize + this.totalPendingConnections >= this.maxConnectionsTotal;
        }
    }

    public boolean isRegistered(Connection connection) {
        return this.connectionToSubPoolMap.get(connection) != null;
    }

    public boolean isBusy(Connection connection) {
        ConnectionInfo<E> info = this.connectionToSubPoolMap.get(connection);
        return info != null && info.endpointPool.isBusy0(info);
    }

    public ConnectionInfo<E> getConnectionInfo(Connection connection) {
        return this.connectionToSubPoolMap.get(connection);
    }

    public GrizzlyFuture<Connection> take(EndpointKey<E> endpointKey) {
        try {
            SingleEndpointPool<E> sePool = this.obtainSingleEndpointPool(endpointKey);
            return sePool.take();
        }
        catch (IOException e) {
            return Futures.createReadyFuture((Throwable)e);
        }
    }

    public void take(EndpointKey<E> endpointKey, CompletionHandler<Connection> completionHandler) {
        if (completionHandler == null) {
            throw new IllegalArgumentException("The completionHandler argument can not be null");
        }
        try {
            SingleEndpointPool<E> sePool = this.obtainSingleEndpointPool(endpointKey);
            sePool.take(completionHandler);
        }
        catch (IOException e) {
            completionHandler.failed((Throwable)e);
        }
    }

    public boolean release(Connection connection) {
        ConnectionInfo<E> info = this.connectionToSubPoolMap.get(connection);
        if (info != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Returning {0} to endpoint pool {1}", new Object[]{connection, info.endpointPool});
            }
            return info.endpointPool.release0(info);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "No ConnectionInfo available for {0}.  Closing connection.", connection);
        }
        connection.closeSilently();
        return false;
    }

    public boolean attach(EndpointKey<E> endpointKey, Connection connection) throws IOException {
        SingleEndpointPool<E> sePool = this.obtainSingleEndpointPool(endpointKey);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Associating foreign connection with pool {0} using endpoint key {1}.", new Object[]{sePool, endpointKey});
        }
        return sePool.attach(connection);
    }

    public boolean detach(Connection connection) {
        ConnectionInfo<E> info = this.connectionToSubPoolMap.get(connection);
        if (info != null && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Detaching {0} from endpoint pool {1}.", new Object[]{connection, info.endpointPool});
        }
        return info != null && info.endpointPool.detach(connection);
    }

    public void close(EndpointKey<E> endpointKey) {
        SingleEndpointPool<E> sePool = this.endpointToPoolMap.remove(endpointKey);
        if (sePool != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Closing pool associated with endpoint key {0}", endpointKey);
            }
            sePool.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.poolSync;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Shutting down. Closing all pools; shutting down executors as needed.");
            }
            this.isClosed = true;
            for (Map.Entry<EndpointKey<E>, SingleEndpointPool<E>> entry : this.endpointToPoolMap.entrySet()) {
                try {
                    entry.getValue().close();
                }
                catch (Exception ignore) {}
            }
            this.endpointToPoolMap.clear();
            if (this.ownDelayedExecutor != null) {
                this.ownDelayedExecutor.destroy();
            }
            if (this.ownDelayedExecutorThreadPool != null) {
                this.ownDelayedExecutorThreadPool.shutdownNow();
            }
        }
    }

    public String toString() {
        return "MultiEndpointPool{endpoint count=" + this.endpointToPoolMap.size() + "poolSize=" + this.poolSize + ", isClosed=" + this.isClosed + "} " + super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleEndpointPool<E> obtainSingleEndpointPool(EndpointKey<E> endpointKey) throws IOException {
        SingleEndpointPool<E> sePool = this.endpointToPoolMap.get(endpointKey);
        if (sePool == null) {
            Object object = this.poolSync;
            synchronized (object) {
                this.checkNotClosed();
                sePool = this.endpointToPoolMap.get(endpointKey);
                if (sePool == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Creating new endpoint pool for key {0}", endpointKey);
                    }
                    sePool = this.createSingleEndpointPool(endpointKey);
                    this.endpointToPoolMap.put(endpointKey, sePool);
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Returning existing pool {0} for key {1}", new Object[]{sePool, endpointKey});
                }
            }
        }
        return sePool;
    }

    protected SingleEndpointPool<E> createSingleEndpointPool(EndpointKey<E> endpointKey) {
        return new EndpointPoolImpl(endpointKey.getEndpoint(), endpointKey.getLocalEndpoint(), endpointKey.getConnectorHandler() == null ? this.defaultConnectorHandler : endpointKey.getConnectorHandler());
    }

    protected void checkNotClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("The pool is closed");
        }
    }

    public static class Builder<E> {
        private ConnectorHandler<E> defaultConnectorHandler;
        private int maxConnectionsPerEndpoint = 2;
        private int maxConnectionsTotal = 16;
        private DelayedExecutor delayedExecutor;
        private long connectTimeoutMillis = -1L;
        private long reconnectDelayMillis = -1L;
        private int maxReconnectAttempts = 5;
        private long keepAliveTimeoutMillis = 30000L;
        private long keepAliveCheckIntervalMillis = 5000L;

        public Builder<E> connectorHandler(ConnectorHandler<E> defaultConnectorHandler) {
            this.defaultConnectorHandler = defaultConnectorHandler;
            return this;
        }

        public Builder<E> maxConnectionsPerEndpoint(int maxConnectionsPerEndpoint) {
            this.maxConnectionsPerEndpoint = maxConnectionsPerEndpoint;
            return this;
        }

        public Builder<E> maxConnectionsTotal(int maxConnectionsTotal) {
            this.maxConnectionsTotal = maxConnectionsTotal;
            return this;
        }

        public Builder<E> delayExecutor(DelayedExecutor delayedExecutor) {
            this.delayedExecutor = delayedExecutor;
            return this;
        }

        public Builder<E> connectTimeout(long connectTimeout, TimeUnit timeunit) {
            this.connectTimeoutMillis = connectTimeout > 0L ? TimeUnit.MILLISECONDS.convert(connectTimeout, timeunit) : connectTimeout;
            return this;
        }

        public Builder<E> reconnectDelay(long reconnectDelay, TimeUnit timeunit) {
            this.reconnectDelayMillis = reconnectDelay > 0L ? TimeUnit.MILLISECONDS.convert(reconnectDelay, timeunit) : reconnectDelay;
            return this;
        }

        public Builder<E> maxReconnectAttempts(int maxReconnectAttempts) {
            this.maxReconnectAttempts = maxReconnectAttempts;
            return this;
        }

        public Builder<E> keepAliveTimeout(long keepAliveTimeout, TimeUnit timeunit) {
            this.keepAliveTimeoutMillis = keepAliveTimeout > 0L ? TimeUnit.MILLISECONDS.convert(keepAliveTimeout, timeunit) : keepAliveTimeout;
            return this;
        }

        public Builder<E> keepAliveCheckInterval(long keepAliveCheckInterval, TimeUnit timeunit) {
            this.keepAliveCheckIntervalMillis = keepAliveCheckInterval > 0L ? TimeUnit.MILLISECONDS.convert(keepAliveCheckInterval, timeunit) : keepAliveCheckInterval;
            return this;
        }

        public MultiEndpointPool<E> build() {
            if (this.defaultConnectorHandler == null) {
                throw new IllegalStateException("The default ConnectorHandler is not set");
            }
            if (this.keepAliveTimeoutMillis >= 0L && this.keepAliveCheckIntervalMillis < 0L) {
                throw new IllegalStateException("Keep-alive timeout is set, but keepAliveCheckInterval is invalid");
            }
            if (this.maxReconnectAttempts < 0) {
                throw new IllegalStateException("Max reconnect attempts must not be a negative value");
            }
            return new MultiEndpointPool<E>(this.defaultConnectorHandler, this.maxConnectionsPerEndpoint, this.maxConnectionsTotal, this.delayedExecutor, this.connectTimeoutMillis, this.keepAliveTimeoutMillis, this.keepAliveCheckIntervalMillis, this.reconnectDelayMillis, this.maxReconnectAttempts);
        }
    }

    private final class EndpointPoolImpl
    extends SingleEndpointPool<E> {
        private final Link<EndpointPoolImpl> maxPoolSizeHitsLink;
        private int maxPoolSizeHits;

        public EndpointPoolImpl(E endpoint, E localEndpoint, ConnectorHandler<E> connectorHandler) {
            super(connectorHandler, endpoint, localEndpoint, 0, MultiEndpointPool.this.maxConnectionsPerEndpoint, (DelayedExecutor.DelayQueue<SingleEndpointPool.ConnectTimeoutTask>)MultiEndpointPool.this.connectTimeoutQueue, (DelayedExecutor.DelayQueue<SingleEndpointPool.ReconnectTask>)MultiEndpointPool.this.reconnectQueue, (DelayedExecutor.DelayQueue<SingleEndpointPool.KeepAliveCleanerTask>)MultiEndpointPool.this.keepAliveCleanerQueue, MultiEndpointPool.this.connectTimeoutMillis, MultiEndpointPool.this.keepAliveTimeoutMillis, MultiEndpointPool.this.keepAliveCheckIntervalMillis, MultiEndpointPool.this.reconnectDelayMillis, MultiEndpointPool.this.maxReconnectAttempts);
            this.maxPoolSizeHitsLink = new Link<EndpointPoolImpl>(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean checkBeforeOpeningConnection() {
            if (this.isMaxCapacityReached()) {
                return false;
            }
            Object object = MultiEndpointPool.this.countersSync;
            synchronized (object) {
                if (MultiEndpointPool.this.isMaxCapacityReached()) {
                    this.onMaxPoolSizeHit();
                    return false;
                }
                ++this.pendingConnections;
                MultiEndpointPool.this.totalPendingConnections++;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void onOpenConnection(ConnectionInfo<E> info) {
            Connection connection = info.connection;
            MultiEndpointPool.this.connectionToSubPoolMap.put(connection, info);
            Object object = MultiEndpointPool.this.countersSync;
            synchronized (object) {
                MultiEndpointPool.this.totalPendingConnections--;
                MultiEndpointPool.this.poolSize++;
            }
            super.onOpenConnection(info);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void onFailedConnection() {
            Object object = MultiEndpointPool.this.countersSync;
            synchronized (object) {
                MultiEndpointPool.this.totalPendingConnections--;
            }
            super.onFailedConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void onCloseConnection(ConnectionInfo<E> info) {
            EndpointPoolImpl prioritizedPool;
            Connection connection = info.connection;
            MultiEndpointPool.this.connectionToSubPoolMap.remove(connection);
            Object object = MultiEndpointPool.this.countersSync;
            synchronized (object) {
                MultiEndpointPool.this.poolSize--;
                prioritizedPool = this.getPrioritizedPool();
            }
            if (prioritizedPool != null) {
                prioritizedPool.createConnectionIfPossible();
                return;
            }
            super.onCloseConnection(info);
        }

        private void onMaxPoolSizeHit() {
            if (this.maxPoolSizeHits++ == 0) {
                if (this.size() > 0) {
                    MultiEndpointPool.this.maxPoolSizeHitsChain.offerLast(this.maxPoolSizeHitsLink);
                } else {
                    Link head = MultiEndpointPool.this.maxPoolSizeHitsChain.getFirstLink();
                    if (head != null) {
                        this.maxPoolSizeHits = ((EndpointPoolImpl)head.getValue()).maxPoolSizeHits;
                    }
                    MultiEndpointPool.this.maxPoolSizeHitsChain.offerFirst(this.maxPoolSizeHitsLink);
                }
            } else {
                Link prev = this.maxPoolSizeHitsLink.prev;
                if (prev != null && this.maxPoolSizeHits > ((EndpointPoolImpl)prev.getValue()).maxPoolSizeHits) {
                    MultiEndpointPool.this.maxPoolSizeHitsChain.moveTowardsHead(this.maxPoolSizeHitsLink);
                }
            }
        }

        private EndpointPoolImpl getPrioritizedPool() {
            EndpointPoolImpl prioritizedPool;
            Link firstLink = MultiEndpointPool.this.maxPoolSizeHitsChain.pollFirst();
            if (firstLink != null) {
                prioritizedPool = (EndpointPoolImpl)firstLink.getValue();
                prioritizedPool.maxPoolSizeHits = 0;
            } else {
                prioritizedPool = null;
            }
            return prioritizedPool;
        }
    }
}

