/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.connectionpool;

import java.io.IOException;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectorHandler;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.connectionpool.Chain;
import org.glassfish.grizzly.connectionpool.ConnectionInfo;
import org.glassfish.grizzly.connectionpool.Link;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.Futures;

public class SingleEndpointPool<E> {
    private static final Logger LOGGER = Grizzly.logger(SingleEndpointPool.class);
    private final ConnectCompletionHandler defaultConnectionCompletionHandler = new ConnectCompletionHandler();
    private final PoolConnectionCloseListener closeListener = new PoolConnectionCloseListener();
    private final Chain<ConnectionInfo<E>> readyConnections = new Chain();
    private final Map<Connection, ConnectionInfo<E>> connectionsMap = new HashMap<Connection, ConnectionInfo<E>>();
    final Object poolSync = new Object();
    private boolean isClosed;
    private final ExecutorService ownDelayedExecutorThreadPool;
    private final DelayedExecutor ownDelayedExecutor;
    private final DelayedExecutor.DelayQueue<ConnectTimeoutTask> connectTimeoutQueue;
    private final DelayedExecutor.DelayQueue<ReconnectTask> reconnectQueue;
    private final int maxReconnectAttempts;
    private final DelayedExecutor.DelayQueue<KeepAliveCleanerTask> keepAliveCleanerQueue;
    private final ConnectorHandler<E> connectorHandler;
    private final E endpointAddress;
    private final E localEndpointAddress;
    private final int corePoolSize;
    private final int maxPoolSize;
    private final long connectTimeoutMillis;
    private final long reconnectDelayMillis;
    private final long keepAliveTimeoutMillis;
    private final long keepAliveCheckIntervalMillis;
    private int poolSize;
    protected int pendingConnections;
    private int failedConnectAttempts;
    private final Chain<AsyncPoll> asyncWaitingList = new Chain();

    public static <T> Builder<T> builder(Class<T> endpointType) {
        return new Builder();
    }

    protected SingleEndpointPool(ConnectorHandler<E> connectorHandler, E endpointAddress, E localEndpointAddress, int corePoolSize, int maxPoolSize, DelayedExecutor delayedExecutor, long connectTimeoutMillis, long keepAliveTimeoutMillis, long keepAliveCheckIntervalMillis, long reconnectDelayMillis, int maxReconnectAttempts) {
        this.connectorHandler = connectorHandler;
        this.endpointAddress = endpointAddress;
        this.localEndpointAddress = localEndpointAddress;
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.reconnectDelayMillis = reconnectDelayMillis;
        this.keepAliveTimeoutMillis = keepAliveTimeoutMillis;
        this.keepAliveCheckIntervalMillis = keepAliveCheckIntervalMillis;
        this.maxReconnectAttempts = maxReconnectAttempts;
        if (delayedExecutor == null) {
            ThreadPoolConfig tpc = ThreadPoolConfig.defaultConfig().setPoolName("connection-pool-delays-thread-pool").setCorePoolSize(1).setMaxPoolSize(1);
            this.ownDelayedExecutorThreadPool = GrizzlyExecutorService.createInstance((ThreadPoolConfig)tpc);
            this.ownDelayedExecutor = new DelayedExecutor(this.ownDelayedExecutorThreadPool);
            this.ownDelayedExecutor.start();
            delayedExecutor = this.ownDelayedExecutor;
        } else {
            this.ownDelayedExecutorThreadPool = null;
            this.ownDelayedExecutor = null;
        }
        this.connectTimeoutQueue = connectTimeoutMillis >= 0L ? delayedExecutor.createDelayQueue((DelayedExecutor.Worker)new ConnectTimeoutWorker(), (DelayedExecutor.Resolver)new ConnectTimeoutTaskResolver()) : null;
        this.reconnectQueue = reconnectDelayMillis >= 0L ? delayedExecutor.createDelayQueue((DelayedExecutor.Worker)new Reconnector(), (DelayedExecutor.Resolver)new ReconnectTaskResolver()) : null;
        if (keepAliveTimeoutMillis >= 0L) {
            this.keepAliveCleanerQueue = delayedExecutor.createDelayQueue((DelayedExecutor.Worker)new KeepAliveCleaner(), (DelayedExecutor.Resolver)new KeepAliveCleanerTaskResolver());
            this.keepAliveCleanerQueue.add(new KeepAliveCleanerTask(this), keepAliveCheckIntervalMillis, TimeUnit.MILLISECONDS);
        } else {
            this.keepAliveCleanerQueue = null;
        }
    }

    protected SingleEndpointPool(ConnectorHandler<E> connectorHandler, E endpointAddress, E localEndpointAddress, int corePoolSize, int maxPoolSize, DelayedExecutor.DelayQueue<ConnectTimeoutTask> connectTimeoutQueue, DelayedExecutor.DelayQueue<ReconnectTask> reconnectQueue, DelayedExecutor.DelayQueue<KeepAliveCleanerTask> keepAliveCleanerQueue, long connectTimeoutMillis, long keepAliveTimeoutMillis, long keepAliveCheckIntervalMillis, long reconnectDelayMillis, int maxReconnectAttempts) {
        this.connectorHandler = connectorHandler;
        this.endpointAddress = endpointAddress;
        this.localEndpointAddress = localEndpointAddress;
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.reconnectDelayMillis = reconnectDelayMillis;
        this.keepAliveTimeoutMillis = keepAliveTimeoutMillis;
        this.keepAliveCheckIntervalMillis = keepAliveCheckIntervalMillis;
        this.maxReconnectAttempts = maxReconnectAttempts;
        this.ownDelayedExecutor = null;
        this.ownDelayedExecutorThreadPool = null;
        this.connectTimeoutQueue = connectTimeoutQueue;
        this.reconnectQueue = reconnectQueue;
        this.keepAliveCleanerQueue = keepAliveCleanerQueue;
        if (keepAliveTimeoutMillis >= 0L) {
            keepAliveCleanerQueue.add(new KeepAliveCleanerTask(this), keepAliveCheckIntervalMillis, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.poolSync;
        synchronized (object) {
            return this.poolSize + this.pendingConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOpenConnectionsCount() {
        Object object = this.poolSync;
        synchronized (object) {
            return this.poolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReadyConnectionsCount() {
        Object object = this.poolSync;
        synchronized (object) {
            return this.readyConnections.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMaxCapacityReached() {
        Object object = this.poolSync;
        synchronized (object) {
            return this.maxPoolSize != -1 && this.poolSize + this.pendingConnections >= this.maxPoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(Connection connection) {
        Object object = this.poolSync;
        synchronized (object) {
            return this.connectionsMap.containsKey(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy(Connection connection) {
        Object object = this.poolSync;
        synchronized (object) {
            return this.isBusy0(this.connectionsMap.get(connection));
        }
    }

    public String toString() {
        return "SingleEndpointPool{endpointAddress=" + this.endpointAddress + ", localEndpointAddress=" + this.localEndpointAddress + ", corePoolSize=" + this.corePoolSize + ", maxPoolSize=" + this.maxPoolSize + ", poolSize=" + this.poolSize + ", isClosed=" + this.isClosed + "} " + super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBusy0(ConnectionInfo<E> connectionRecord) {
        Object object = this.poolSync;
        synchronized (object) {
            return connectionRecord != null && !connectionRecord.isReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionInfo<E> getConnectionInfo(Connection connection) {
        Object object = this.poolSync;
        synchronized (object) {
            return this.connectionsMap.get(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrizzlyFuture<Connection> take() {
        Object object = this.poolSync;
        synchronized (object) {
            try {
                if (this.isClosed) {
                    return Futures.createReadyFuture((Throwable)new IOException("The pool is closed"));
                }
                if (!this.readyConnections.isEmpty()) {
                    return Futures.createReadyFuture((Object)this.readyConnections.pollLast().getValue().connection);
                }
                AsyncPoll asyncPoll = new AsyncPoll();
                final Link<AsyncPoll> pollLink = new Link<AsyncPoll>(asyncPoll);
                SafeFutureImpl<Connection> cancellableFuture = new SafeFutureImpl<Connection>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void onComplete() {
                        try {
                            if (!this.isCancelled()) {
                                this.get();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        Object object = SingleEndpointPool.this.poolSync;
                        synchronized (object) {
                            SingleEndpointPool.this.asyncWaitingList.remove(pollLink);
                        }
                    }
                };
                asyncPoll.future = (FutureImpl)cancellableFuture;
                this.asyncWaitingList.offerLast(pollLink);
                this.createConnectionIfPossibleNoSync();
                return cancellableFuture;
            }
            catch (Exception e) {
                return Futures.createReadyFuture((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void take(CompletionHandler<Connection> completionHandler) {
        if (completionHandler == null) {
            throw new IllegalArgumentException("The completionHandler argument can not be null");
        }
        Object object = this.poolSync;
        synchronized (object) {
            try {
                if (this.isClosed) {
                    completionHandler.failed((Throwable)new IOException("The pool is closed"));
                    return;
                }
                if (!this.readyConnections.isEmpty()) {
                    completionHandler.completed((Object)this.readyConnections.pollLast().getValue().connection);
                    return;
                }
                AsyncPoll asyncPoll = new AsyncPoll();
                Link<AsyncPoll> pollLink = new Link<AsyncPoll>(asyncPoll);
                asyncPoll.completionHandler = completionHandler;
                this.asyncWaitingList.offerLast(pollLink);
                this.createConnectionIfPossibleNoSync();
            }
            catch (Exception e) {
                completionHandler.failed((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(Connection connection) {
        Object object = this.poolSync;
        synchronized (object) {
            ConnectionInfo<E> info = this.connectionsMap.get(connection);
            if (info == null) {
                connection.closeSilently();
                return false;
            }
            return this.release0(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean release0(ConnectionInfo<E> info) {
        Object object = this.poolSync;
        synchronized (object) {
            if (info.isReady()) {
                return false;
            }
            this.readyConnections.offerLast(info.readyStateLink);
            this.notifyAsyncPoller();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attach(Connection connection) throws IOException {
        Object object = this.poolSync;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException("The pool is closed");
            }
            if (this.connectionsMap.containsKey(connection)) {
                return true;
            }
            if (this.checkBeforeOpeningConnection()) {
                this.defaultConnectionCompletionHandler.completed(connection);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detach(Connection connection) {
        Object object = this.poolSync;
        synchronized (object) {
            ConnectionInfo<E> info = this.connectionsMap.remove(connection);
            if (info != null) {
                if (info.isReady()) {
                    return false;
                }
                connection.removeCloseListener((CloseListener)this.closeListener);
                this.deregisterConnection(info);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.poolSync;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            try {
                this.isClosed = true;
                if (this.ownDelayedExecutor != null) {
                    this.ownDelayedExecutor.destroy();
                }
                if (this.ownDelayedExecutorThreadPool != null) {
                    this.ownDelayedExecutorThreadPool.shutdownNow();
                }
                int size = this.readyConnections.size();
                for (int i = 0; i < size; ++i) {
                    Connection c = this.readyConnections.pollLast().getValue().connection;
                    c.closeSilently();
                }
                int asyncWaitingListSize = this.asyncWaitingList.size();
                IOException exception = null;
                for (int i = 0; i < asyncWaitingListSize; ++i) {
                    AsyncPoll asyncPoll = this.asyncWaitingList.pollFirst().getValue();
                    if (exception == null) {
                        exception = new IOException("The pool is closed");
                    }
                    try {
                        Futures.notifyFailure((FutureImpl)asyncPoll.future, (CompletionHandler)asyncPoll.completionHandler, (Throwable)exception);
                        continue;
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                for (Map.Entry<Connection, ConnectionInfo<E>> entry : this.connectionsMap.entrySet()) {
                    this.deregisterConnection(entry.getValue());
                }
                this.connectionsMap.clear();
            }
            finally {
                this.poolSync.notifyAll();
            }
        }
    }

    protected boolean checkBeforeOpeningConnection() {
        if (!this.isMaxCapacityReached()) {
            ++this.pendingConnections;
            return true;
        }
        return false;
    }

    void onOpenConnection(ConnectionInfo<E> info) {
    }

    void onFailedConnection() {
    }

    void onCloseConnection(ConnectionInfo<E> info) {
        if (!this.asyncWaitingList.isEmpty()) {
            this.createConnectionIfPossibleNoSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cleanupIdleConnections(KeepAliveCleanerTask cleanerTask) {
        Object object = this.poolSync;
        synchronized (object) {
            if (this.isClosed) {
                return true;
            }
            if (!this.readyConnections.isEmpty() && this.poolSize > this.corePoolSize) {
                long now = System.currentTimeMillis();
                try {
                    Link<ConnectionInfo<E>> link;
                    while (now - (link = this.readyConnections.getFirstLink()).getAttachmentTimeStamp() >= this.keepAliveTimeoutMillis) {
                        Connection connection = link.getValue().connection;
                        connection.closeSilently();
                        if (!this.readyConnections.isEmpty() && this.poolSize > this.corePoolSize) continue;
                        break;
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        }
        cleanerTask.timeoutMillis = System.currentTimeMillis() + this.keepAliveCheckIntervalMillis;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createConnectionIfPossible() {
        Object object = this.poolSync;
        synchronized (object) {
            return this.createConnectionIfPossibleNoSync();
        }
    }

    private boolean createConnectionIfPossibleNoSync() {
        if (this.checkBeforeOpeningConnection()) {
            if (this.connectTimeoutMillis < 0L) {
                this.connectorHandler.connect(this.endpointAddress, this.localEndpointAddress, (CompletionHandler)this.defaultConnectionCompletionHandler);
            } else {
                Future future = this.connectorHandler.connect(this.endpointAddress, this.localEndpointAddress);
                if (future instanceof GrizzlyFuture) {
                    GrizzlyFuture listenableFuture = (GrizzlyFuture)future;
                    ConnectTimeoutTask connectTimeoutTask = new ConnectTimeoutTask((GrizzlyFuture<Connection>)listenableFuture);
                    this.connectTimeoutQueue.add((Object)connectTimeoutTask, this.connectTimeoutMillis, TimeUnit.MILLISECONDS);
                    listenableFuture.addCompletionHandler((CompletionHandler)this.defaultConnectionCompletionHandler);
                } else {
                    LOGGER.log(Level.FINE, "ConnectorHandler doesn't support interruption of the connect operation. Connect-timeout setting will be ignored");
                }
            }
            return true;
        }
        return false;
    }

    private void notifyAsyncPoller() {
        if (!this.asyncWaitingList.isEmpty() && !this.readyConnections.isEmpty()) {
            ConnectionInfo<E> info = this.readyConnections.pollLast().getValue();
            Connection connection = info.connection;
            AsyncPoll asyncPoll = this.asyncWaitingList.pollFirst().getValue();
            Futures.notifyResult((FutureImpl)asyncPoll.future, (CompletionHandler)asyncPoll.completionHandler, (Object)connection);
        }
    }

    private void notifyAsyncPollersOfFailure(Throwable t) {
        this.failedConnectAttempts = 0;
        while (!this.asyncWaitingList.isEmpty()) {
            AsyncPoll asyncPoll = this.asyncWaitingList.pollFirst().getValue();
            Futures.notifyFailure((FutureImpl)asyncPoll.future, (CompletionHandler)asyncPoll.completionHandler, (Throwable)t);
        }
    }

    private void deregisterConnection(ConnectionInfo<E> info) {
        this.readyConnections.remove(info.readyStateLink);
        --this.poolSize;
        this.onCloseConnection(info);
    }

    public static class Builder<E> {
        private ConnectorHandler<E> connectorHandler;
        private E endpointAddress;
        private E localEndpointAddress;
        private int corePoolSize = 0;
        private int maxPoolSize = 4;
        private DelayedExecutor delayedExecutor;
        private long connectTimeoutMillis = -1L;
        private long reconnectDelayMillis = -1L;
        private int maxReconnectAttempts = 5;
        private long keepAliveTimeoutMillis = 30000L;
        private long keepAliveCheckIntervalMillis = 5000L;

        public Builder<E> connectorHandler(ConnectorHandler<E> connectorHandler) {
            this.connectorHandler = connectorHandler;
            return this;
        }

        public Builder<E> endpointAddress(E endpointAddress) {
            this.endpointAddress = endpointAddress;
            return this;
        }

        public Builder<E> localEndpointAddress(E localEndpointAddress) {
            this.localEndpointAddress = localEndpointAddress;
            return this;
        }

        public Builder<E> corePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public Builder<E> maxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return this;
        }

        public Builder<E> delayExecutor(DelayedExecutor delayedExecutor) {
            this.delayedExecutor = delayedExecutor;
            return this;
        }

        public Builder<E> connectTimeout(long connectTimeout, TimeUnit timeunit) {
            this.connectTimeoutMillis = connectTimeout > 0L ? TimeUnit.MILLISECONDS.convert(connectTimeout, timeunit) : connectTimeout;
            return this;
        }

        public Builder<E> reconnectDelay(long reconnectDelay, TimeUnit timeunit) {
            this.reconnectDelayMillis = reconnectDelay > 0L ? TimeUnit.MILLISECONDS.convert(reconnectDelay, timeunit) : reconnectDelay;
            return this;
        }

        public Builder<E> maxReconnectAttempts(int maxReconnectAttempts) {
            this.maxReconnectAttempts = maxReconnectAttempts;
            return this;
        }

        public Builder<E> keepAliveTimeout(long keepAliveTimeout, TimeUnit timeunit) {
            this.keepAliveTimeoutMillis = keepAliveTimeout > 0L ? TimeUnit.MILLISECONDS.convert(keepAliveTimeout, timeunit) : keepAliveTimeout;
            return this;
        }

        public Builder<E> keepAliveCheckInterval(long keepAliveCheckInterval, TimeUnit timeunit) {
            this.keepAliveCheckIntervalMillis = keepAliveCheckInterval > 0L ? TimeUnit.MILLISECONDS.convert(keepAliveCheckInterval, timeunit) : keepAliveCheckInterval;
            return this;
        }

        public SingleEndpointPool<E> build() {
            if (this.connectorHandler == null) {
                throw new IllegalStateException("ConnectorHandler is not set");
            }
            if (this.endpointAddress == null) {
                throw new IllegalStateException("Endpoint address is not set");
            }
            if (this.keepAliveTimeoutMillis >= 0L && this.keepAliveCheckIntervalMillis < 0L) {
                throw new IllegalStateException("Keep-alive timeout is set, but keepAliveCheckInterval is invalid");
            }
            if (this.maxReconnectAttempts < 0) {
                throw new IllegalStateException("Max reconnect attempts must not be a negative value");
            }
            return new SingleEndpointPool<E>(this.connectorHandler, this.endpointAddress, this.localEndpointAddress, this.corePoolSize, this.maxPoolSize, this.delayedExecutor, this.connectTimeoutMillis, this.keepAliveTimeoutMillis, this.keepAliveCheckIntervalMillis, this.reconnectDelayMillis, this.maxReconnectAttempts);
        }
    }

    private final class AsyncPoll {
        private CompletionHandler<Connection> completionHandler;
        private FutureImpl<Connection> future;

        private AsyncPoll() {
        }
    }

    protected static final class ReconnectTask<E> {
        public long timeout;
        public final SingleEndpointPool<E> pool;

        public ReconnectTask(SingleEndpointPool<E> singleEndpointPool) {
            this.pool = singleEndpointPool;
        }
    }

    protected static final class ReconnectTaskResolver
    implements DelayedExecutor.Resolver<ReconnectTask> {
        protected ReconnectTaskResolver() {
        }

        public boolean removeTimeout(ReconnectTask reconnectTask) {
            reconnectTask.timeout = -1L;
            return true;
        }

        public long getTimeoutMillis(ReconnectTask reconnectTask) {
            return reconnectTask.timeout;
        }

        public void setTimeoutMillis(ReconnectTask reconnectTask, long timeoutMillis) {
            reconnectTask.timeout = timeoutMillis;
        }
    }

    protected static final class Reconnector
    implements DelayedExecutor.Worker<ReconnectTask> {
        protected Reconnector() {
        }

        public boolean doWork(ReconnectTask reconnectTask) {
            reconnectTask.pool.createConnectionIfPossibleNoSync();
            return true;
        }
    }

    protected static final class KeepAliveCleanerTask<E> {
        public long timeoutMillis;
        public final SingleEndpointPool<E> pool;

        public KeepAliveCleanerTask(SingleEndpointPool<E> singleEndpointPool) {
            this.pool = singleEndpointPool;
        }
    }

    protected static final class KeepAliveCleanerTaskResolver
    implements DelayedExecutor.Resolver<KeepAliveCleanerTask> {
        protected KeepAliveCleanerTaskResolver() {
        }

        public boolean removeTimeout(KeepAliveCleanerTask cleanerTask) {
            cleanerTask.timeoutMillis = -1L;
            return true;
        }

        public long getTimeoutMillis(KeepAliveCleanerTask cleanerTask) {
            return cleanerTask.timeoutMillis;
        }

        public void setTimeoutMillis(KeepAliveCleanerTask cleanerTask, long timeoutMillis) {
            cleanerTask.timeoutMillis = timeoutMillis;
        }
    }

    protected static final class KeepAliveCleaner
    implements DelayedExecutor.Worker<KeepAliveCleanerTask> {
        protected KeepAliveCleaner() {
        }

        public boolean doWork(KeepAliveCleanerTask cleanerTask) {
            return cleanerTask.pool.cleanupIdleConnections(cleanerTask);
        }
    }

    protected static final class ConnectTimeoutTask {
        public long timeout;
        public final GrizzlyFuture<Connection> connectFuture;

        public ConnectTimeoutTask(GrizzlyFuture<Connection> future) {
            this.connectFuture = future;
        }
    }

    protected static final class ConnectTimeoutTaskResolver
    implements DelayedExecutor.Resolver<ConnectTimeoutTask> {
        protected ConnectTimeoutTaskResolver() {
        }

        public boolean removeTimeout(ConnectTimeoutTask connectTimeoutTask) {
            connectTimeoutTask.timeout = -1L;
            return true;
        }

        public long getTimeoutMillis(ConnectTimeoutTask connectTimeoutTask) {
            return connectTimeoutTask.timeout;
        }

        public void setTimeoutMillis(ConnectTimeoutTask connectTimeoutTask, long timeoutMillis) {
            connectTimeoutTask.timeout = timeoutMillis;
        }
    }

    protected static final class ConnectTimeoutWorker
    implements DelayedExecutor.Worker<ConnectTimeoutTask> {
        protected ConnectTimeoutWorker() {
        }

        public boolean doWork(ConnectTimeoutTask connectTimeoutTask) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINE, "Pool connect timed out");
            }
            connectTimeoutTask.connectFuture.cancel(false);
            return true;
        }
    }

    private final class PoolConnectionCloseListener
    implements CloseListener<Connection, CloseType> {
        private PoolConnectionCloseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClosed(Connection connection, CloseType type) throws IOException {
            Object object = SingleEndpointPool.this.poolSync;
            synchronized (object) {
                ConnectionInfo info = (ConnectionInfo)SingleEndpointPool.this.connectionsMap.remove(connection);
                if (info != null) {
                    SingleEndpointPool.this.deregisterConnection(info);
                }
            }
        }
    }

    private final class ConnectCompletionHandler
    extends EmptyCompletionHandler<Connection> {
        private final ConnectTimeoutTask connectTimeoutTask;

        public ConnectCompletionHandler() {
            this(null);
        }

        public ConnectCompletionHandler(ConnectTimeoutTask connectTimeoutTask) {
            this.connectTimeoutTask = connectTimeoutTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(Connection connection) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINE, "Pool connection is established {0}", connection);
            }
            if (this.connectTimeoutTask != null) {
                SingleEndpointPool.this.connectTimeoutQueue.remove((Object)this.connectTimeoutTask);
            }
            Object object = SingleEndpointPool.this.poolSync;
            synchronized (object) {
                if (!SingleEndpointPool.this.isClosed) {
                    ConnectionInfo info = new ConnectionInfo(connection, SingleEndpointPool.this);
                    SingleEndpointPool.this.connectionsMap.put(connection, info);
                    SingleEndpointPool.this.readyConnections.offerLast(info.readyStateLink);
                    SingleEndpointPool.this.poolSize++;
                    --SingleEndpointPool.this.pendingConnections;
                    SingleEndpointPool.this.failedConnectAttempts = 0;
                    SingleEndpointPool.this.onOpenConnection(info);
                    connection.addCloseListener((CloseListener)SingleEndpointPool.this.closeListener);
                    SingleEndpointPool.this.notifyAsyncPoller();
                } else {
                    connection.closeSilently();
                }
            }
        }

        public void cancelled() {
            this.onFailedToConnect(new ConnectException("Connect timeout"));
        }

        public void failed(Throwable throwable) {
            this.onFailedToConnect(throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onFailedToConnect(Throwable t) {
            if (this.connectTimeoutTask != null) {
                SingleEndpointPool.this.connectTimeoutQueue.remove((Object)this.connectTimeoutTask);
            }
            Object object = SingleEndpointPool.this.poolSync;
            synchronized (object) {
                --SingleEndpointPool.this.pendingConnections;
                SingleEndpointPool.this.onFailedConnection();
                if (SingleEndpointPool.this.reconnectQueue != null && !SingleEndpointPool.this.asyncWaitingList.isEmpty()) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINE, "Pool connect operation failed, schedule reconnect");
                    }
                    if (++SingleEndpointPool.this.failedConnectAttempts > SingleEndpointPool.this.maxReconnectAttempts) {
                        SingleEndpointPool.this.notifyAsyncPollersOfFailure(t);
                    } else {
                        SingleEndpointPool.this.reconnectQueue.add(new ReconnectTask(SingleEndpointPool.this), SingleEndpointPool.this.reconnectDelayMillis, TimeUnit.MILLISECONDS);
                    }
                } else {
                    SingleEndpointPool.this.notifyAsyncPollersOfFailure(t);
                }
            }
        }
    }
}

