/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.FixedLengthTransferEncoding;
import org.glassfish.grizzly.http.HttpBaseFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.TransferEncoding;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http2.HeadersDecoder;
import org.glassfish.grizzly.http2.Http2Configuration;
import org.glassfish.grizzly.http2.Http2FrameCodec;
import org.glassfish.grizzly.http2.Http2Request;
import org.glassfish.grizzly.http2.Http2Session;
import org.glassfish.grizzly.http2.Http2SessionException;
import org.glassfish.grizzly.http2.Http2State;
import org.glassfish.grizzly.http2.Http2Stream;
import org.glassfish.grizzly.http2.Http2StreamException;
import org.glassfish.grizzly.http2.NetLogger;
import org.glassfish.grizzly.http2.frames.DataFrame;
import org.glassfish.grizzly.http2.frames.ErrorCode;
import org.glassfish.grizzly.http2.frames.GoAwayFrame;
import org.glassfish.grizzly.http2.frames.HeaderBlockFragment;
import org.glassfish.grizzly.http2.frames.HeaderBlockHead;
import org.glassfish.grizzly.http2.frames.HeadersFrame;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.http2.frames.PingFrame;
import org.glassfish.grizzly.http2.frames.PriorityFrame;
import org.glassfish.grizzly.http2.frames.RstStreamFrame;
import org.glassfish.grizzly.http2.frames.SettingsFrame;
import org.glassfish.grizzly.http2.frames.WindowUpdateFrame;
import org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.threadpool.Threads;
import org.glassfish.grizzly.utils.Charsets;

public abstract class Http2BaseFilter
extends HttpBaseFilter {
    private static final Logger LOGGER = Grizzly.logger(Http2BaseFilter.class);
    static final String HTTP2_CLEAR = "h2c";
    static final String HTTP2_PUSH_ENABLED = "http2-push-enabled";
    static final byte[] PRI_PAYLOAD = "SM\r\n\r\n".getBytes(Charsets.ASCII_CHARSET);
    protected static final TransferEncoding FIXED_LENGTH_ENCODING = new FixedLengthTransferEncoding();
    final Http2FrameCodec frameCodec = new Http2FrameCodec();
    private final Http2Configuration configuration;
    protected final ExecutorService threadPool;
    private int localMaxFramePayloadSize;

    public Http2BaseFilter(Http2Configuration configuration) {
        this.configuration = configuration;
        ThreadPoolConfig tpConfig = configuration.getThreadPoolConfig();
        this.threadPool = tpConfig != null ? GrizzlyExecutorService.createInstance(tpConfig) : configuration.getExecutorService();
    }

    public int getLocalMaxFramePayloadSize() {
        return this.localMaxFramePayloadSize;
    }

    public void setLocalMaxFramePayloadSize(int localMaxFramePayloadSize) {
        this.localMaxFramePayloadSize = localMaxFramePayloadSize;
    }

    public Http2Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processFrames(FilterChainContext ctx, Http2Session http2Session, List<Http2Frame> framesList) {
        if (framesList == null || framesList.isEmpty()) {
            return true;
        }
        try {
            try {
                for (Http2Frame inFrame : framesList) {
                    NetLogger.log(NetLogger.Context.RX, http2Session, inFrame);
                    try {
                        this.processInFrame(http2Session, ctx, inFrame);
                    }
                    catch (Http2StreamException e) {
                        int streamId;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Http2StreamException occurred on connection=" + ctx.getConnection() + " during Http2Frame processing", e);
                        }
                        if ((streamId = e.getStreamId()) == 0) {
                            throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR);
                        }
                        this.sendRstStream(ctx, http2Session, streamId, e.getErrorCode());
                    }
                }
            }
            finally {
                framesList.clear();
            }
            List<Http2Stream> streamsToFlushInput = http2Session.streamsToFlushInput;
            for (Http2Stream streamsToFlush : streamsToFlushInput) {
                streamsToFlush.flushInputData();
            }
            streamsToFlushInput.clear();
            return true;
        }
        catch (Http2SessionException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Http2SessionException occurred on connection=" + ctx.getConnection() + " during Http2Frame processing", e);
            }
            http2Session.terminate(e.getErrorCode(), e.getMessage());
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "IOException occurred on connection=" + ctx.getConnection() + " during Http2Frame processing", e);
            }
            http2Session.terminate(ErrorCode.INTERNAL_ERROR, e.getMessage());
        }
        return false;
    }

    protected boolean checkRequestHeadersOnUpgrade(HttpRequestPacket httpRequest) {
        if (!httpRequest.isUpgrade()) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("checkRequestHeadersOnUpgrade: failed no upgrade");
            }
            return false;
        }
        DataChunk connectionHeaderDC = httpRequest.getHeaders().getValue(Header.Connection);
        if (connectionHeaderDC == null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("checkRequestHeadersOnUpgrade: failed no connection");
            }
            return false;
        }
        boolean upgradeFound = false;
        boolean http2SettingsFound = false;
        int pos = 0;
        int len = connectionHeaderDC.getLength();
        while (pos < len) {
            int comma = connectionHeaderDC.indexOf(",", pos);
            int valueEnd = comma != -1 ? comma : len;
            String value = connectionHeaderDC.toString(pos, valueEnd).trim();
            upgradeFound = upgradeFound || "Upgrade".equals(value);
            http2SettingsFound = http2SettingsFound || "HTTP2-Settings".equals(value);
            pos = valueEnd + 1;
        }
        if (!upgradeFound || !http2SettingsFound) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "checkRequestHeadersOnUpgrade: failed incorrect connection: {0}", connectionHeaderDC);
            }
            return false;
        }
        if (!httpRequest.getHeaders().contains(Header.HTTP2Settings)) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("checkRequestHeadersOnUpgrade: failed no settings");
            }
            return false;
        }
        return true;
    }

    protected boolean checkResponseHeadersOnUpgrade(HttpResponsePacket httpResponse) {
        if (httpResponse.getStatus() != 101) {
            return false;
        }
        if (!httpResponse.isUpgrade()) {
            return false;
        }
        DataChunk connectionHeaderDC = httpResponse.getHeaders().getValue(Header.Connection);
        return connectionHeaderDC != null && !connectionHeaderDC.isNull() && connectionHeaderDC.equals(Header.Upgrade.getBytes());
    }

    protected SettingsFrame getHttp2UpgradeSettings(HttpRequestPacket httpRequest) {
        DataChunk http2Settings = httpRequest.getHeaders().getValue(Header.HTTP2Settings);
        return http2Settings != null ? SettingsFrame.fromBase64Uri(http2Settings) : null;
    }

    protected boolean isHttp2UpgradingVersion(HttpHeader httpHeader) {
        DataChunk upgradeDC = httpHeader.getUpgradeDC();
        assert (upgradeDC != null && !upgradeDC.isNull());
        return upgradeDC.equals(HTTP2_CLEAR);
    }

    protected boolean onHttpPacketParsed(HttpHeader httpHeader, FilterChainContext ctx) {
        return false;
    }

    protected boolean onHttpHeaderParsed(HttpHeader httpHeader, Buffer buffer, FilterChainContext ctx) {
        return false;
    }

    protected void onInitialLineParsed(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    protected void onInitialLineEncoded(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    protected void onHttpHeadersParsed(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    protected void onHttpHeadersEncoded(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    protected void onHttpContentParsed(HttpContent content, FilterChainContext ctx) {
    }

    protected void onHttpContentEncoded(HttpContent content, FilterChainContext ctx) {
    }

    protected void onHttpHeaderError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
    }

    protected void onHttpContentError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
    }

    private void processInFrame(Http2Session http2Session, FilterChainContext context, Http2Frame frame) throws Http2StreamException, Http2SessionException, IOException {
        http2Session.checkFrameSequenceSemantics(frame);
        switch (frame.getType()) {
            case 0: {
                Http2BaseFilter.processDataFrame(http2Session, context, frame);
                break;
            }
            case 2: {
                this.processPriorityFrame(frame);
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                this.processHeadersFrame(http2Session, context, frame);
                break;
            }
            case 4: {
                this.processSettingsFrame(http2Session, context, frame);
                break;
            }
            case 6: {
                this.processPingFrame(http2Session, frame);
                break;
            }
            case 3: {
                this.processRstStreamFrame(http2Session, frame);
                break;
            }
            case 7: {
                this.processGoAwayFrame(http2Session, frame);
                break;
            }
            case 8: {
                this.processWindowUpdateFrame(http2Session, frame);
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "Unknown or unhandled frame [type={0} flags={1} length={2} streamId={3}]", new Object[]{frame.getType(), frame.getFlags(), frame.getLength(), frame.getStreamId()});
            }
        }
    }

    private void processPriorityFrame(Http2Frame frame) throws Http2SessionException, Http2StreamException {
        int streamId = frame.getStreamId();
        try {
            if (streamId == 0) {
                throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR, "PRIORITY frame on stream ID zero.");
            }
            if (frame.getLength() != 5) {
                throw new Http2StreamException(streamId, ErrorCode.FRAME_SIZE_ERROR);
            }
            if (streamId == ((PriorityFrame)frame).getStreamDependency()) {
                throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR, "PRIORITY frame dependent on itself.");
            }
        }
        finally {
            frame.recycle();
        }
    }

    private void processWindowUpdateFrame(Http2Session http2Session, Http2Frame frame) throws Http2StreamException, Http2SessionException {
        WindowUpdateFrame updateFrame = (WindowUpdateFrame)frame;
        int streamId = updateFrame.getStreamId();
        int delta = updateFrame.getWindowSizeIncrement();
        updateFrame.recycle();
        if (streamId == 0) {
            if (delta == 0) {
                throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR, "Illegal WINDOW_UPDATE with a delta of 0.");
            }
            http2Session.getOutputSink().onPeerWindowUpdate(delta);
        } else {
            if (delta == 0) {
                throw new Http2StreamException(streamId, ErrorCode.PROTOCOL_ERROR, "Illegal WINDOW_UPDATE with a delta of 0.");
            }
            Http2Stream stream = http2Session.getStream(streamId);
            if (stream != null) {
                stream.getOutputSink().onPeerWindowUpdate(delta);
            } else {
                throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR);
            }
        }
    }

    private void processGoAwayFrame(Http2Session http2Session, Http2Frame frame) throws Http2SessionException {
        if (frame.getStreamId() != 0) {
            throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR, "GOAWAY frame for non-zero stream ID.");
        }
        http2Session.setGoAwayByPeer(((GoAwayFrame)frame).getLastStreamId());
        frame.recycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSettingsFrame(Http2Session http2Session, FilterChainContext context, Http2Frame frame) throws Http2SessionException, Http2StreamException {
        if (frame.getStreamId() != 0) {
            throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR, "SETTINGS frame with non-zero stream ID.");
        }
        SettingsFrame settingsFrame = (SettingsFrame)frame;
        try {
            if (settingsFrame.isAck()) {
                if (settingsFrame.getLength() != 0) {
                    throw new Http2SessionException(ErrorCode.FRAME_SIZE_ERROR, "SETTINGS frame ack with a non-zero length.");
                }
                return;
            }
            if (settingsFrame.getLength() % 6 != 0) {
                throw new Http2SessionException(ErrorCode.FRAME_SIZE_ERROR, "SETTINGS frame length not multiple of six.");
            }
            this.sendSettingsAck(http2Session, context);
            this.applySettings(http2Session, settingsFrame);
        }
        finally {
            frame.recycle();
        }
    }

    void applySettings(Http2Session http2Session, SettingsFrame settingsFrame) throws Http2SessionException, Http2StreamException {
        int numberOfSettings = settingsFrame.getNumberOfSettings();
        block7: for (int i = 0; i < numberOfSettings; ++i) {
            SettingsFrame.Setting setting = settingsFrame.getSettingByIndex(i);
            switch (setting.getId()) {
                case 1: {
                    continue block7;
                }
                case 2: {
                    int val = setting.getValue();
                    if (val < 0 || val > 1) {
                        throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR, "Invalid value for SETTINGS_ENABLE_PUSH.");
                    }
                    boolean pushEnabled = val == 1;
                    http2Session.getConnection().getAttributes().setAttribute(HTTP2_PUSH_ENABLED, pushEnabled);
                    http2Session.setPushEnabled(pushEnabled);
                    continue block7;
                }
                case 3: {
                    http2Session.setPeerMaxConcurrentStreams(setting.getValue());
                    continue block7;
                }
                case 4: {
                    if (setting.getValue() == Integer.MIN_VALUE) {
                        throw new Http2SessionException(ErrorCode.FLOW_CONTROL_ERROR, "SETTINGS_INITIAL_WINDOW_SIZE greater than 2^31-1.");
                    }
                    http2Session.setPeerStreamWindowSize(setting.getValue());
                    continue block7;
                }
                case 5: {
                    http2Session.setPeerMaxFramePayloadSize(setting.getValue());
                    continue block7;
                }
            }
        }
    }

    private void processPingFrame(Http2Session http2Session, Http2Frame frame) throws Http2SessionException {
        if (frame.getStreamId() != 0) {
            throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR, "PING frame with non-zero stream ID.");
        }
        if (frame.getLength() != 8) {
            throw new Http2SessionException(ErrorCode.FRAME_SIZE_ERROR, "PING frame with invalid length.");
        }
        PingFrame pingFrame = (PingFrame)frame;
        if (pingFrame.isAckSet()) {
            return;
        }
        pingFrame.setFlag(1);
        http2Session.getOutputSink().writeDownStream(pingFrame);
    }

    private void processRstStreamFrame(Http2Session http2Session, Http2Frame frame) throws Http2SessionException {
        int streamId = frame.getStreamId();
        frame.recycle();
        if (streamId == 0) {
            throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR, "RST frame on stream ID zero.");
        }
        if (Http2BaseFilter.ignoreFrameForStreamId(http2Session, streamId)) {
            return;
        }
        Http2Stream stream = http2Session.getStream(streamId);
        if (stream == null) {
            if (streamId > http2Session.lastPeerStreamId) {
                throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR, "Received RST frame on IDLE stream.");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Received RST frame on on existent stream.  Ignoring frame.");
            }
            return;
        }
        if (stream.isIdle()) {
            throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR, "Illegal attempt to RST IDLE stream.");
        }
        stream.resetRemotely();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHeadersFrame(Http2Session http2Session, FilterChainContext context, Http2Frame frame) throws IOException {
        HeaderBlockHead blockHead;
        HeaderBlockFragment headerBlockFragment = (HeaderBlockFragment)frame;
        if (headerBlockFragment.getStreamId() == 0) {
            throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR, "HEADERS frame received on stream 0.");
        }
        if (frame instanceof HeaderBlockHead && (blockHead = (HeaderBlockHead)frame).isPadded() && blockHead.getPadLength() >= headerBlockFragment.getLength()) {
            throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR, "Pad length greater than or equal to the payload length.");
        }
        if (frame instanceof HeadersFrame) {
            HeadersFrame headersFrame = (HeadersFrame)frame;
            if (headersFrame.getStreamId() == headersFrame.getStreamDependency()) {
                throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR, "HEADER frame dependent upon itself.");
            }
            headersFrame.normalize();
        }
        if (http2Session.isServer() && frame.getType() == 5) {
            throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR, "Server endpoint received PUSH_PROMISE frame.");
        }
        HeadersDecoder headersDecoder = http2Session.getHeadersDecoder();
        if (headerBlockFragment.getCompressedHeaders().hasRemaining() && !headersDecoder.append(headerBlockFragment.takePayload())) {
            headersDecoder.setFirstHeaderFrame((HeaderBlockHead)headerBlockFragment);
            HeaderBlockHead firstHeaderFrame = headersDecoder.finishHeader();
            firstHeaderFrame.setTruncated();
            try {
                this.processCompleteHeader(http2Session, context, firstHeaderFrame);
            }
            finally {
                firstHeaderFrame.recycle();
            }
            return;
        }
        boolean isEOH = headerBlockFragment.isEndHeaders();
        if (!headersDecoder.isProcessingHeaders()) {
            headersDecoder.setFirstHeaderFrame((HeaderBlockHead)headerBlockFragment);
        } else {
            headerBlockFragment.recycle();
        }
        if (!isEOH) {
            return;
        }
        HeaderBlockHead firstHeaderFrame = headersDecoder.finishHeader();
        try {
            this.processCompleteHeader(http2Session, context, firstHeaderFrame);
        }
        finally {
            firstHeaderFrame.recycle();
        }
    }

    protected abstract void processCompleteHeader(Http2Session var1, FilterChainContext var2, HeaderBlockHead var3) throws IOException;

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Http2State http2State = Http2State.get(ctx.getConnection());
        if (http2State == null || http2State.isNeverHttp2()) {
            return ctx.getInvokeAction();
        }
        Object message = ctx.getMessage();
        Http2Session http2Session = this.obtainHttp2Session(ctx, false);
        if (http2Session.isHttp2OutputEnabled() && HttpPacket.isHttp(message)) {
            HttpPacket httpPacket = (HttpPacket)ctx.getMessage();
            HttpHeader httpHeader = httpPacket.getHttpHeader();
            this.processOutgoingHttpHeader(ctx, http2Session, httpHeader, httpPacket);
        } else {
            FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
            http2Session.getOutputSink().writeDownStream(message, transportContext.getCompletionHandler(), transportContext.getMessageCloner());
        }
        return ctx.getStopAction();
    }

    protected abstract void processOutgoingHttpHeader(FilterChainContext var1, Http2Session var2, HttpHeader var3, HttpPacket var4) throws IOException;

    protected void prepareOutgoingRequest(HttpRequestPacket request) {
        String contentType = request.getContentType();
        if (contentType != null) {
            request.getHeaders().setValue(Header.ContentType).setString(contentType);
        }
        if (request.getContentLength() != -1L) {
            FIXED_LENGTH_ENCODING.prepareSerialize(null, request, null);
        }
    }

    @Override
    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        if (!Http2State.isHttp2(ctx.getConnection())) {
            return ctx.getInvokeAction();
        }
        Object type = event.type();
        if (type == TransportFilter.FlushEvent.TYPE) {
            assert (event instanceof TransportFilter.FlushEvent);
            HttpContext httpContext = HttpContext.get(ctx);
            Http2Stream stream = (Http2Stream)httpContext.getContextStorage();
            TransportFilter.FlushEvent flushEvent = (TransportFilter.FlushEvent)event;
            stream.outputSink.flush(flushEvent.getCompletionHandler());
            return ctx.getStopAction();
        }
        return ctx.getInvokeAction();
    }

    boolean checkIfHttp2StreamChain(FilterChainContext ctx) throws IOException {
        Object message = ctx.getMessage();
        if (message == null) {
            Http2Stream http2Stream = (Http2Stream)HttpContext.get(ctx).getContextStorage();
            ctx.setMessage(http2Stream.pollInputData());
            return true;
        }
        HttpContent httpContent = (HttpContent)message;
        HttpHeader httpHeader = httpContent.getHttpHeader();
        return Http2Stream.getStreamFor(httpHeader) != null;
    }

    protected Http2Session createHttp2Session(Connection connection, boolean isServer) {
        Http2Session http2Session = new Http2Session(connection, isServer, this);
        Http2Session.bind(connection, http2Session);
        return http2Session;
    }

    protected void onPrefaceReceived(Http2Session http2Session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendUpstream(final Http2Session http2Session, final Http2Stream stream, final HttpContent content) {
        HttpRequestPacket request = stream.getRequest();
        HttpContext httpContext = HttpContext.newInstance(stream, stream, stream, request);
        request.getProcessingState().setHttpContext(httpContext);
        if (this.threadPool == null) {
            Threads.setService(true);
            try {
                http2Session.sendMessageUpstream(stream, content);
            }
            finally {
                Threads.setService(false);
            }
        } else {
            this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    http2Session.sendMessageUpstream(stream, content);
                }
            });
        }
    }

    void prepareIncomingRequest(Http2Stream stream, Http2Request request) {
        ProcessingState state = request.getProcessingState();
        HttpResponsePacket response = request.getResponse();
        Method method = request.getMethod();
        if (stream.isPushStream() || Method.GET.equals(method) || Method.HEAD.equals(method) || !Method.CONNECT.equals(method) && request.getContentLength() == 0L) {
            request.setExpectContent(false);
        }
        try {
            request.getProtocol();
        }
        catch (IllegalStateException e) {
            state.setError(true);
            HttpStatus.HTTP_VERSION_NOT_SUPPORTED_505.setValues(response);
            request.setProtocol(Protocol.HTTP_1_1);
            return;
        }
        MimeHeaders headers = request.getHeaders();
        DataChunk hostDC = headers.getValue(Header.Host);
        if (hostDC == null || hostDC.getLength() == 0) {
            state.setError(true);
        }
    }

    void sendRstStream(FilterChainContext ctx, Http2Session http2Session, int streamId, ErrorCode errorCode) {
        RstStreamFrame rstStreamFrame = ((RstStreamFrame.RstStreamFrameBuilder)RstStreamFrame.builder().errorCode(errorCode).streamId(streamId)).build();
        ctx.write(this.frameCodec.serializeAndRecycle(http2Session, rstStreamFrame));
    }

    protected final Http2Session obtainHttp2Session(FilterChainContext context, boolean isUpStream) {
        return this.obtainHttp2Session(null, context, isUpStream);
    }

    final Http2Session obtainHttp2Session(Http2State http2State, FilterChainContext context, boolean isUpStream) {
        Http2Session http2Session;
        Connection connection = context.getConnection();
        Http2Session http2Session2 = http2Session = http2State != null ? http2State.getHttp2Session() : null;
        if (http2Session == null && (http2Session = Http2Session.get(connection)) == null) {
            http2Session = this.createHttp2Session(connection, true);
        }
        http2Session.setupFilterChains(context, isUpStream);
        return http2Session;
    }

    private void sendSettingsAck(Http2Session http2Session, FilterChainContext context) {
        SettingsFrame frame = SettingsFrame.builder().setAck().build();
        context.write(this.frameCodec.serializeAndRecycle(http2Session, frame));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processDataFrame(Http2Session http2Session, FilterChainContext context, Http2Frame frame) throws IOException {
        boolean fin;
        int streamId;
        Buffer data;
        DataFrame dataFrame = (DataFrame)frame;
        try {
            if (dataFrame.isPadded() && dataFrame.getPadLength() >= dataFrame.getLength()) {
                throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR, "Pad length greater than or equal to the payload length.");
            }
            dataFrame.normalize();
            data = dataFrame.getData();
            streamId = dataFrame.getStreamId();
            fin = dataFrame.isFlagSet(1);
        }
        finally {
            dataFrame.recycle();
        }
        http2Session.ackConsumedData(data.remaining());
        if (Http2BaseFilter.ignoreFrameForStreamId(http2Session, streamId)) {
            return;
        }
        Http2Stream stream = http2Session.getStream(streamId);
        if (stream == null && streamId > http2Session.lastPeerStreamId) {
            throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR, "Received DATA frame on IDLE stream.");
        }
        if (stream == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Data frame received for non-existent stream: connection={0}, frame={1}, stream={2}", new Object[]{context.getConnection(), dataFrame, streamId});
            }
            throw new Http2StreamException(streamId, ErrorCode.STREAM_CLOSED);
        }
        stream.offerInputData(data, fin);
    }

    protected static boolean ignoreFrameForStreamId(Http2Session session, int streamId) {
        return session.isGoingAway() && streamId > session.getGoingAwayLastStreamId();
    }
}

