/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.GrizzlyTestCase;
import org.glassfish.grizzly.NIOTransportBuilder;
import org.glassfish.grizzly.memory.BuffersBuffer;
import org.glassfish.grizzly.memory.ByteBufferWrapper;
import org.glassfish.grizzly.memory.MemoryManager;

public class BuffersBufferTest
extends GrizzlyTestCase {
    private MemoryManager mm;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.mm = NIOTransportBuilder.DEFAULT_MEMORY_MANAGER;
    }

    public void testCharEndianess() {
        BuffersBuffer buffer = BuffersBufferTest.createOneSevenBuffer(this.mm);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.BIG_ENDIAN ? 1 : 0) != 0);
        buffer.putChar('a');
        buffer.flip();
        BuffersBufferTest.assertEquals((String)"big endian", (char)'a', (char)buffer.getChar());
        buffer = BuffersBufferTest.createOneSevenBuffer(this.mm);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.BIG_ENDIAN ? 1 : 0) != 0);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0) != 0);
        buffer.putChar('a');
        buffer.flip();
        BuffersBufferTest.assertEquals((String)"little endian", (char)'a', (char)buffer.getChar());
    }

    public void testShortEndianess() {
        BuffersBuffer buffer = BuffersBufferTest.createOneSevenBuffer(this.mm);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.BIG_ENDIAN ? 1 : 0) != 0);
        buffer.putShort((short)1);
        buffer.flip();
        BuffersBufferTest.assertEquals((String)"big endian", (short)1, (short)buffer.getShort());
        buffer = BuffersBufferTest.createOneSevenBuffer(this.mm);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.BIG_ENDIAN ? 1 : 0) != 0);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0) != 0);
        buffer.putShort((short)1);
        buffer.flip();
        BuffersBufferTest.assertEquals((String)"little endian", (short)1, (short)buffer.getShort());
    }

    public void testIntEndianess() {
        BuffersBuffer buffer = BuffersBufferTest.createOneSevenBuffer(this.mm);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.BIG_ENDIAN ? 1 : 0) != 0);
        buffer.putInt(1);
        buffer.flip();
        BuffersBufferTest.assertEquals((String)"big endian", (int)1, (int)buffer.getInt());
        buffer = BuffersBufferTest.createOneSevenBuffer(this.mm);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.BIG_ENDIAN ? 1 : 0) != 0);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0) != 0);
        buffer.putInt(1);
        buffer.flip();
        BuffersBufferTest.assertEquals((String)"little endian", (int)1, (int)buffer.getInt());
    }

    public void testLongEndianess() {
        BuffersBuffer buffer = BuffersBufferTest.createOneSevenBuffer(this.mm);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.BIG_ENDIAN ? 1 : 0) != 0);
        buffer.putLong(1L);
        buffer.flip();
        BuffersBufferTest.assertEquals((String)"big endian", (long)1L, (long)buffer.getLong());
        buffer = BuffersBufferTest.createOneSevenBuffer(this.mm);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.BIG_ENDIAN ? 1 : 0) != 0);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0) != 0);
        buffer.putLong(1L);
        buffer.flip();
        BuffersBufferTest.assertEquals((String)"little endian", (long)1L, (long)buffer.getLong());
    }

    public void testFloatEndianess() {
        BuffersBuffer buffer = BuffersBufferTest.createOneSevenBuffer(this.mm);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.BIG_ENDIAN ? 1 : 0) != 0);
        buffer.putFloat(1.0f);
        buffer.flip();
        BuffersBufferTest.assertEquals((String)"big endian", (Object)Float.valueOf(1.0f), (Object)Float.valueOf(buffer.getFloat()));
        buffer = BuffersBufferTest.createOneSevenBuffer(this.mm);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.BIG_ENDIAN ? 1 : 0) != 0);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0) != 0);
        buffer.putFloat(1.0f);
        buffer.flip();
        BuffersBufferTest.assertEquals((String)"little endian", (Object)Float.valueOf(1.0f), (Object)Float.valueOf(buffer.getFloat()));
    }

    public void testDoubleEndianess() {
        BuffersBuffer buffer = BuffersBufferTest.createOneSevenBuffer(this.mm);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.BIG_ENDIAN ? 1 : 0) != 0);
        buffer.putDouble(1.0);
        buffer.flip();
        BuffersBufferTest.assertEquals((String)"big endian", (Object)1.0, (Object)buffer.getDouble());
        buffer = BuffersBufferTest.createOneSevenBuffer(this.mm);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.BIG_ENDIAN ? 1 : 0) != 0);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        BuffersBufferTest.assertTrue((buffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0) != 0);
        buffer.putDouble(1.0);
        buffer.flip();
        BuffersBufferTest.assertEquals((String)"little endian", (Object)1.0, (Object)buffer.getDouble());
    }

    private static BuffersBuffer createOneSevenBuffer(MemoryManager mm) {
        BuffersBuffer b = BuffersBuffer.create((MemoryManager)mm);
        b.append((Buffer)new ByteBufferWrapper(ByteBuffer.allocate(1)));
        b.append((Buffer)new ByteBufferWrapper(ByteBuffer.allocate(7)));
        return b;
    }
}

