/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.GrizzlyTestCase;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;

public class IdleConnectionFilterTest
extends GrizzlyTestCase {
    public static final int PORT = 7782;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAcceptedConnectionIdleTimeout() throws Exception {
        Connection connection = null;
        final CountDownLatch latch = new CountDownLatch(1);
        IdleTimeoutFilter idleTimeoutFilter = new IdleTimeoutFilter(2L, TimeUnit.SECONDS);
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)idleTimeoutFilter);
        filterChainBuilder.add((Filter)new BaseFilter(){
            private volatile Connection acceptedConnection;

            public NextAction handleAccept(FilterChainContext ctx) throws IOException {
                this.acceptedConnection = ctx.getConnection();
                return ctx.getInvokeAction();
            }

            public NextAction handleClose(FilterChainContext ctx) throws IOException {
                if (ctx.getConnection().equals(this.acceptedConnection)) {
                    latch.countDown();
                }
                return ctx.getInvokeAction();
            }
        });
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(7782);
            transport.start();
            GrizzlyFuture future = transport.connect("localhost", 7782);
            connection = (Connection)future.get(10L, TimeUnit.SECONDS);
            IdleConnectionFilterTest.assertTrue((connection != null ? 1 : 0) != 0);
            IdleConnectionFilterTest.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectedConnectionIdleTimeout() throws Exception {
        Connection connection = null;
        final CountDownLatch latch = new CountDownLatch(1);
        IdleTimeoutFilter idleTimeoutFilter = new IdleTimeoutFilter(2L, TimeUnit.SECONDS);
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)idleTimeoutFilter);
        filterChainBuilder.add((Filter)new BaseFilter(){
            private volatile Connection connectedConnection;

            public NextAction handleConnect(FilterChainContext ctx) throws IOException {
                this.connectedConnection = ctx.getConnection();
                return ctx.getInvokeAction();
            }

            public NextAction handleClose(FilterChainContext ctx) throws IOException {
                if (ctx.getConnection().equals(this.connectedConnection)) {
                    latch.countDown();
                }
                return ctx.getInvokeAction();
            }
        });
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(7782);
            transport.start();
            GrizzlyFuture future = transport.connect("localhost", 7782);
            connection = (Connection)future.get(10L, TimeUnit.SECONDS);
            IdleConnectionFilterTest.assertTrue((connection != null ? 1 : 0) != 0);
            IdleConnectionFilterTest.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }
}

