/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.StandaloneProcessor;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.ByteBufferWrapper;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.ssl.SSLStreamReader;
import org.glassfish.grizzly.ssl.SSLStreamWriter;
import org.glassfish.grizzly.streams.StreamReader;
import org.glassfish.grizzly.streams.StreamWriter;
import org.glassfish.grizzly.utils.ChunkingFilter;
import org.glassfish.grizzly.utils.EchoFilter;
import org.glassfish.grizzly.utils.StringFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SSLTest {
    private static final Logger logger = Grizzly.logger(SSLTest.class);
    public static final int PORT = 7779;
    private final boolean isLazySslInit;

    public SSLTest(boolean isLazySslInit) {
        this.isLazySslInit = isLazySslInit;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getLazySslInit() {
        return Arrays.asList({Boolean.FALSE}, {Boolean.TRUE});
    }

    @Before
    public void before() throws Exception {
        Grizzly.setTrackingThreadCache((boolean)true);
        ByteBufferWrapper.DEBUG_MODE = true;
    }

    @Test
    public void testSimpleSyncSSL() throws Exception {
        this.doTestSSL(true, 1, 1, 0, new Filter[0]);
    }

    @Test
    public void testSimpleAsyncSSL() throws Exception {
        this.doTestSSL(false, 1, 1, 0, new Filter[0]);
    }

    @Test
    public void test5PacketsOn1ConnectionSyncSSL() throws Exception {
        this.doTestSSL(true, 1, 5, 0, new Filter[0]);
    }

    @Test
    public void test5PacketsOn1ConnectionAsyncSSL() throws Exception {
        this.doTestSSL(false, 1, 5, 0, new Filter[0]);
    }

    @Test
    public void test5PacketsOn5ConnectionsSyncSSL() throws Exception {
        this.doTestSSL(true, 5, 5, 0, new Filter[0]);
    }

    @Test
    public void test5PacketsOn5ConnectionsAsyncSSL() throws Exception {
        this.doTestSSL(false, 5, 5, 0, new Filter[0]);
    }

    @Test
    public void testSimpleSyncSSLChunkedBefore() throws Exception {
        this.doTestSSL(true, 1, 1, 1, new Filter[]{new ChunkingFilter(1)});
    }

    @Test
    public void testSimpleAsyncSSLChunkedBefore() throws Exception {
        this.doTestSSL(false, 1, 1, 1, new Filter[]{new ChunkingFilter(1)});
    }

    @Test
    public void testSimpleSyncSSLChunkedAfter() throws Exception {
        this.doTestSSL(true, 1, 1, 2, new Filter[]{new ChunkingFilter(1)});
    }

    @Test
    public void testSimpleAsyncSSLChunkedAfter() throws Exception {
        this.doTestSSL(false, 1, 1, 2, new Filter[]{new ChunkingFilter(1)});
    }

    @Test
    @Ignore
    public void testPingPongFilterChainSync() throws Exception {
        this.doTestPingPongFilterChain(true, 5, 0, new Filter[0]);
    }

    @Test
    public void testPingPongFilterChainAsync() throws Exception {
        this.doTestPingPongFilterChain(false, 5, 0, new Filter[0]);
    }

    @Test
    @Ignore
    public void testPingPongFilterChainSyncChunked() throws Exception {
        this.doTestPingPongFilterChain(true, 5, 1, new Filter[]{new ChunkingFilter(1)});
    }

    @Test
    public void testPingPongFilterChainAsyncChunked() throws Exception {
        this.doTestPingPongFilterChain(false, 5, 1, new Filter[]{new ChunkingFilter(1)});
    }

    @Test
    public void testSimplePendingSSLClientWrites() throws Exception {
        this.doTestPendingSSLClientWrites(1, 1);
    }

    @Test
    public void test20on1PendingSSLClientWrites() throws Exception {
        this.doTestPendingSSLClientWrites(1, 20);
    }

    @Test
    public void test200On5PendingSSLClientWrites() throws Exception {
        this.doTestPendingSSLClientWrites(5, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTestPingPongFilterChain(boolean isBlocking, int turnAroundsNum, int filterIndex, Filter ... filters) throws Exception {
        Integer pingPongTurnArounds = turnAroundsNum;
        Connection connection = null;
        SSLContextConfigurator sslContextConfigurator = this.createSSLContextConfigurator();
        SSLEngineConfigurator clientSSLEngineConfigurator = null;
        SSLEngineConfigurator serverSSLEngineConfigurator = null;
        if (sslContextConfigurator.validateConfiguration(true)) {
            clientSSLEngineConfigurator = new SSLEngineConfigurator(sslContextConfigurator.createSSLContext());
            serverSSLEngineConfigurator = new SSLEngineConfigurator(sslContextConfigurator.createSSLContext(), false, false, false);
        } else {
            Assert.fail((String)"Failed to validate SSLContextConfiguration.");
        }
        SSLFilter sslFilter = new SSLFilter(serverSSLEngineConfigurator, clientSSLEngineConfigurator);
        SSLPingPongFilter pingPongFilter = new SSLPingPongFilter(sslFilter, pingPongTurnArounds);
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)sslFilter);
        filterChainBuilder.add((Filter)new StringFilter());
        filterChainBuilder.add((Filter)pingPongFilter);
        filterChainBuilder.addAll(filterIndex, filters);
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(7779);
            transport.start();
            transport.configureBlocking(isBlocking);
            GrizzlyFuture future = transport.connect("localhost", 7779);
            connection = (Connection)future.get(10L, TimeUnit.SECONDS);
            Assert.assertTrue((connection != null ? 1 : 0) != 0);
            try {
                Assert.assertEquals((Object)pingPongTurnArounds, (Object)pingPongFilter.getServerCompletedFeature().get(10L, TimeUnit.SECONDS));
            }
            catch (TimeoutException e) {
                logger.severe("Server timeout");
            }
            Assert.assertEquals((Object)pingPongTurnArounds, (Object)pingPongFilter.getClientCompletedFeature().get(10L, TimeUnit.SECONDS));
            connection.close();
            connection = null;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestSSL(boolean isBlocking, int connectionsNum, int packetsNumber, int filterIndex, Filter ... filters) throws Exception {
        Connection connection = null;
        SSLContextConfigurator sslContextConfigurator = this.createSSLContextConfigurator();
        SSLEngineConfigurator clientSSLEngineConfigurator = null;
        SSLEngineConfigurator serverSSLEngineConfigurator = null;
        if (sslContextConfigurator.validateConfiguration(true)) {
            if (this.isLazySslInit) {
                clientSSLEngineConfigurator = new SSLEngineConfigurator(sslContextConfigurator);
                serverSSLEngineConfigurator = new SSLEngineConfigurator(sslContextConfigurator, false, false, false);
            } else {
                clientSSLEngineConfigurator = new SSLEngineConfigurator(sslContextConfigurator.createSSLContext());
                serverSSLEngineConfigurator = new SSLEngineConfigurator(sslContextConfigurator.createSSLContext(), false, false, false);
            }
        } else {
            Assert.fail((String)"Failed to validate SSLContextConfiguration.");
        }
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new SSLFilter(serverSSLEngineConfigurator, clientSSLEngineConfigurator));
        filterChainBuilder.add((Filter)new EchoFilter());
        filterChainBuilder.addAll(filterIndex, filters);
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        SSLStreamReader reader = null;
        SSLStreamWriter writer = null;
        try {
            transport.bind(7779);
            transport.start();
            transport.configureBlocking(isBlocking);
            for (int i = 0; i < connectionsNum; ++i) {
                GrizzlyFuture future = transport.connect((SocketAddress)new InetSocketAddress("localhost", 7779), (CompletionHandler)new EmptyCompletionHandler<Connection>(){

                    public void completed(Connection connection) {
                        connection.configureStandalone(true);
                        connection.setReadTimeout(10L, TimeUnit.SECONDS);
                    }
                });
                connection = (Connection)future.get(10L, TimeUnit.SECONDS);
                Assert.assertTrue((connection != null ? 1 : 0) != 0);
                StreamReader connectionStreamReader = StandaloneProcessor.INSTANCE.getStreamReader(connection);
                StreamWriter connectionStreamWriter = StandaloneProcessor.INSTANCE.getStreamWriter(connection);
                reader = new SSLStreamReader(connectionStreamReader);
                writer = new SSLStreamWriter(connectionStreamWriter);
                Future handshakeFuture = writer.handshake(reader, clientSSLEngineConfigurator);
                handshakeFuture.get(10L, TimeUnit.SECONDS);
                Assert.assertTrue((boolean)handshakeFuture.isDone());
                for (int j = 0; j < packetsNumber; ++j) {
                    try {
                        byte[] sentMessage = ("Hello world! Connection#" + i + " Packet#" + j).getBytes();
                        writer.writeByteArray(sentMessage);
                        GrizzlyFuture writeFuture = writer.flush();
                        writeFuture.get(10L, TimeUnit.SECONDS);
                        Assert.assertTrue((String)"Write timeout", (boolean)writeFuture.isDone());
                        byte[] receivedMessage = new byte[sentMessage.length];
                        GrizzlyFuture readFuture = reader.notifyAvailable(receivedMessage.length);
                        readFuture.get(10L, TimeUnit.SECONDS);
                        Assert.assertTrue((boolean)readFuture.isDone());
                        reader.readByteArray(receivedMessage);
                        String sentString = new String(sentMessage);
                        String receivedString = new String(receivedMessage);
                        Assert.assertEquals((Object)sentString, (Object)receivedString);
                        continue;
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Error occurred when testing connection#{0} packet#{1}", new Object[]{i, j});
                        throw e;
                    }
                }
                reader.close();
                reader = null;
                writer.close();
                writer = null;
                connection.close();
                connection = null;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestPendingSSLClientWrites(int connectionsNum, int packetsNumber) throws Exception {
        Connection connection = null;
        SSLContextConfigurator sslContextConfigurator = this.createSSLContextConfigurator();
        SSLEngineConfigurator clientSSLEngineConfigurator = null;
        SSLEngineConfigurator serverSSLEngineConfigurator = null;
        if (sslContextConfigurator.validateConfiguration(true)) {
            clientSSLEngineConfigurator = new SSLEngineConfigurator(sslContextConfigurator.createSSLContext());
            serverSSLEngineConfigurator = new SSLEngineConfigurator(sslContextConfigurator.createSSLContext(), false, false, false);
        } else {
            Assert.fail((String)"Failed to validate SSLContextConfiguration.");
        }
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new SSLFilter(serverSSLEngineConfigurator, clientSSLEngineConfigurator));
        filterChainBuilder.add((Filter)new EchoFilter());
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        MemoryManager mm = transport.getMemoryManager();
        try {
            transport.bind(7779);
            transport.start();
            for (int i = 0; i < connectionsNum; ++i) {
                String messagePattern = "Hello world! Connection#" + i + " Packet#";
                GrizzlyFuture future = transport.connect("localhost", 7779);
                connection = (Connection)future.get(10L, TimeUnit.SECONDS);
                Assert.assertTrue((connection != null ? 1 : 0) != 0);
                SafeFutureImpl clientFuture = SafeFutureImpl.create();
                FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
                clientFilterChainBuilder.add((Filter)new TransportFilter());
                clientFilterChainBuilder.add((Filter)new SSLFilter(serverSSLEngineConfigurator, clientSSLEngineConfigurator));
                ClientTestFilter clientTestFilter = new ClientTestFilter((FutureImpl)clientFuture, messagePattern, packetsNumber);
                clientFilterChainBuilder.add((Filter)clientTestFilter);
                connection.setProcessor((Processor)clientFilterChainBuilder.build());
                int packetNum = 0;
                try {
                    for (int j = 0; j < packetsNumber; ++j) {
                        packetNum = j;
                        Buffer buffer = Buffers.wrap((MemoryManager)mm, (String)(messagePattern + j));
                        connection.write((Object)buffer);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Error occurred when testing connection#{0} packet#{1}", new Object[]{i, packetNum});
                    throw e;
                }
                try {
                    Integer bytesReceived = (Integer)clientFuture.get(10L, TimeUnit.SECONDS);
                    Assert.assertNotNull((Object)bytesReceived);
                }
                catch (TimeoutException e) {
                    throw new TimeoutException("Received " + clientTestFilter.getBytesReceived() + " out of " + clientTestFilter.getPatternString().length());
                }
                connection.close();
                connection = null;
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    private SSLContextConfigurator createSSLContextConfigurator() {
        URL keystoreUrl;
        SSLContextConfigurator sslContextConfigurator = new SSLContextConfigurator();
        ClassLoader cl = this.getClass().getClassLoader();
        URL cacertsUrl = cl.getResource("ssltest-cacerts.jks");
        if (cacertsUrl != null) {
            sslContextConfigurator.setTrustStoreFile(cacertsUrl.getFile());
            sslContextConfigurator.setTrustStorePass("changeit");
        }
        if ((keystoreUrl = cl.getResource("ssltest-keystore.jks")) != null) {
            sslContextConfigurator.setKeyStoreFile(keystoreUrl.getFile());
            sslContextConfigurator.setKeyStorePass("changeit");
        }
        return sslContextConfigurator;
    }

    private static class ClientTestFilter
    extends BaseFilter {
        private final FutureImpl<Integer> clientFuture;
        private final String messagePattern;
        private final int packetsNumber;
        private volatile int bytesReceived = 0;
        private final String patternString;

        private ClientTestFilter(FutureImpl<Integer> clientFuture, String messagePattern, int packetsNumber) {
            this.clientFuture = clientFuture;
            this.messagePattern = messagePattern;
            this.packetsNumber = packetsNumber;
            StringBuilder sb = new StringBuilder(packetsNumber * (messagePattern.length() + 5));
            for (int i = 0; i < packetsNumber; ++i) {
                sb.append(messagePattern).append(i);
            }
            this.patternString = sb.toString();
        }

        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            try {
                Buffer buffer = (Buffer)ctx.getMessage();
                String rcvdStr = buffer.toStringContent();
                String expectedChunk = this.patternString.substring(this.bytesReceived, this.bytesReceived + buffer.remaining());
                if (!expectedChunk.equals(rcvdStr)) {
                    this.clientFuture.failure((Throwable)((Object)new AssertionError((Object)("Content doesn't match. Expected: " + expectedChunk + " Got: " + rcvdStr))));
                }
                this.bytesReceived += buffer.remaining();
                if (this.bytesReceived == this.patternString.length()) {
                    this.clientFuture.result((Object)this.bytesReceived);
                }
            }
            catch (Exception e) {
                this.clientFuture.failure((Throwable)e);
            }
            return super.handleRead(ctx);
        }

        public int getBytesReceived() {
            return this.bytesReceived;
        }

        public String getPatternString() {
            return this.patternString;
        }
    }

    private class SSLPingPongFilter
    extends BaseFilter {
        private final Attribute<Integer> turnAroundAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("TurnAroundAttr");
        private final int turnAroundNum;
        private final SSLFilter sslFilter;
        private final FutureImpl<Integer> serverCompletedFeature = SafeFutureImpl.create();
        private final FutureImpl<Integer> clientCompletedFeature = SafeFutureImpl.create();

        public SSLPingPongFilter(SSLFilter sslFilter, int turnaroundNum) {
            this.sslFilter = sslFilter;
            this.turnAroundNum = turnaroundNum;
        }

        public NextAction handleConnect(FilterChainContext ctx) throws IOException {
            final Connection connection = ctx.getConnection();
            try {
                this.sslFilter.handshake(connection, (CompletionHandler)new EmptyCompletionHandler<SSLEngine>(){

                    public void completed(SSLEngine result) {
                        try {
                            connection.write((Object)"ping");
                            SSLPingPongFilter.this.turnAroundAttr.set((AttributeStorage)connection, (Object)1);
                        }
                        catch (IOException e) {
                            SSLPingPongFilter.this.clientCompletedFeature.failure((Throwable)e);
                        }
                    }
                });
            }
            catch (Exception e) {
                this.clientCompletedFeature.failure((Throwable)e);
            }
            return ctx.getInvokeAction();
        }

        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            Connection connection = ctx.getConnection();
            Integer currentTurnAround = (Integer)this.turnAroundAttr.get((AttributeStorage)connection);
            if (currentTurnAround == null) {
                currentTurnAround = 1;
            } else {
                Integer n = currentTurnAround;
                Integer n2 = currentTurnAround = Integer.valueOf(currentTurnAround + 1);
            }
            String message = (String)ctx.getMessage();
            if (message.equals("ping")) {
                try {
                    connection.write((Object)"pong");
                    this.turnAroundAttr.set((AttributeStorage)connection, (Object)currentTurnAround);
                    if (currentTurnAround >= this.turnAroundNum) {
                        this.serverCompletedFeature.result((Object)this.turnAroundNum);
                    }
                }
                catch (Exception e) {
                    this.serverCompletedFeature.failure((Throwable)e);
                }
            } else if (message.equals("pong")) {
                try {
                    if (currentTurnAround > this.turnAroundNum) {
                        this.clientCompletedFeature.result((Object)this.turnAroundNum);
                        return ctx.getStopAction();
                    }
                    connection.write((Object)"ping");
                    this.turnAroundAttr.set((AttributeStorage)connection, (Object)currentTurnAround);
                }
                catch (Exception e) {
                    this.clientCompletedFeature.failure((Throwable)e);
                }
            }
            return ctx.getStopAction();
        }

        public Future<Integer> getClientCompletedFeature() {
            return this.clientCompletedFeature;
        }

        public Future<Integer> getServerCompletedFeature() {
            return this.serverCompletedFeature;
        }
    }
}

