/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.AbstractWriter;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Interceptor;
import org.glassfish.grizzly.PendingWriteQueueLimitExceededException;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.asyncqueue.AsyncWriteQueueRecord;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.NullaryFunction;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.threadpool.WorkerThread;

public abstract class AbstractNIOAsyncQueueWriter
extends AbstractWriter<SocketAddress>
implements AsyncQueueWriter<SocketAddress> {
    private static final Logger logger = Grizzly.logger(AbstractNIOAsyncQueueWriter.class);
    private static final ThreadLocal<Reenterant> REENTERANTS_COUNTER = new ThreadLocal<Reenterant>(){

        @Override
        protected Reenterant initialValue() {
            return new Reenterant();
        }
    };
    private static final int EMPTY_RECORD_SPACE_VALUE = 1;
    protected final NIOTransport transport;
    protected volatile int maxPendingBytes = -1;
    protected volatile int maxWriteReenterants = 10;
    private IOException cachedIOException;
    private final Attribute<Reenterant> reenterantsAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(AbstractNIOAsyncQueueWriter.class + ".reenterant", new NullaryFunction<Reenterant>(){

        @Override
        public Reenterant evaluate() {
            return new Reenterant();
        }
    });

    public AbstractNIOAsyncQueueWriter(NIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public boolean canWrite(Connection connection, int size) {
        if (this.maxPendingBytes < 0) {
            return true;
        }
        TaskQueue<AsyncWriteQueueRecord> connectionQueue = ((NIOConnection)connection).getAsyncWriteQueue();
        return connectionQueue.spaceInBytes() + size < this.maxPendingBytes;
    }

    @Override
    public void setMaxPendingBytesPerConnection(int maxPendingBytes) {
        this.maxPendingBytes = maxPendingBytes <= 0 ? -1 : maxPendingBytes;
    }

    @Override
    public int getMaxPendingBytesPerConnection() {
        return this.maxPendingBytes;
    }

    @Override
    public int getMaxWriteReenterants() {
        return this.maxWriteReenterants;
    }

    @Override
    public void setMaxWriteReenterants(int maxWriteReenterants) {
        this.maxWriteReenterants = maxWriteReenterants;
    }

    @Override
    public GrizzlyFuture<WriteResult<Buffer, SocketAddress>> write(Connection connection, SocketAddress dstAddress, Buffer buffer, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, Interceptor<WriteResult<Buffer, SocketAddress>> interceptor) throws IOException {
        return this.write(connection, dstAddress, buffer, completionHandler, interceptor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GrizzlyFuture<WriteResult<Buffer, SocketAddress>> write(Connection connection, SocketAddress dstAddress, Buffer buffer, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, Interceptor<WriteResult<Buffer, SocketAddress>> interceptor, MessageCloner<Buffer> cloner) throws IOException {
        if (connection == null) {
            throw new IOException("Connection is null");
        }
        if (!connection.isOpen()) {
            throw new IOException("Connection is closed");
        }
        NIOConnection nioConnection = (NIOConnection)connection;
        TaskQueue<AsyncWriteQueueRecord> connectionQueue = nioConnection.getAsyncWriteQueue();
        WriteResult<Buffer, SocketAddress> currentResult = WriteResult.create(connection, buffer, dstAddress, 0);
        boolean isEmptyRecord = !buffer.hasRemaining();
        AsyncWriteQueueRecord queueRecord = this.createRecord(connection, buffer, null, currentResult, completionHandler, interceptor, dstAddress, buffer, false, isEmptyRecord);
        int bufferSize = buffer.remaining();
        int bytesToReserve = queueRecord.isEmptyRecord() ? 1 : bufferSize;
        int pendingBytes = connectionQueue.reserveSpace(bytesToReserve);
        boolean isCurrent = pendingBytes == bytesToReserve;
        boolean isLogFine = logger.isLoggable(Level.FINEST);
        if (isLogFine) {
            AbstractNIOAsyncQueueWriter.doFineLog("AsyncQueueWriter.write connection={0} record={1} directWrite={2}", connection, queueRecord, isCurrent);
        }
        Reenterant reenterants = null;
        try {
            if (isCurrent && (reenterants = this.getWriteReenterants()).incAndGet() < this.maxWriteReenterants) {
                boolean isQueueEmpty;
                int bytesWritten = this.write0(nioConnection, queueRecord);
                int bytesToRelease = isEmptyRecord ? 1 : bytesWritten;
                boolean bl = isQueueEmpty = connectionQueue.releaseSpaceAndNotify(bytesToRelease) == 0;
                if (this.isFinished(queueRecord)) {
                    this.onWriteComplete(queueRecord);
                    if (!isQueueEmpty) {
                        this.onReadyToWrite(connection);
                    }
                    ReadyFutureImpl<WriteResult<Buffer, SocketAddress>> readyFutureImpl = ReadyFutureImpl.create(currentResult);
                    return readyFutureImpl;
                }
            } else if (this.maxPendingBytes > 0 && pendingBytes > this.maxPendingBytes && bufferSize > 0) {
                connectionQueue.releaseSpace(bytesToReserve);
                throw new PendingWriteQueueLimitExceededException("Max queued data limit exceeded: " + pendingBytes + '>' + this.maxPendingBytes);
            }
            SafeFutureImpl<WriteResult<Buffer, SocketAddress>> future = SafeFutureImpl.create();
            queueRecord.setFuture(future);
            if (isCurrent) {
                if (cloner != null) {
                    if (isLogFine) {
                        logger.log(Level.FINEST, "AsyncQueueWriter.write clone. connection={0}", connection);
                    }
                    buffer = cloner.clone(connection, buffer);
                    queueRecord.setMessage(buffer);
                    queueRecord.setOutputBuffer(buffer);
                    queueRecord.setCloned(true);
                }
                connectionQueue.setCurrentElement(queueRecord);
                this.onReadyToWrite(connection);
                SafeFutureImpl<WriteResult<Buffer, SocketAddress>> safeFutureImpl = future;
                return safeFutureImpl;
            }
            connectionQueue.offer(queueRecord);
            if (!connection.isOpen() && connectionQueue.remove(queueRecord)) {
                this.onWriteFailure(connection, queueRecord, new IOException("Connection is closed"));
            }
            SafeFutureImpl<WriteResult<Buffer, SocketAddress>> safeFutureImpl = future;
            return safeFutureImpl;
        }
        catch (IOException e) {
            if (isLogFine) {
                logger.log(Level.FINEST, "AsyncQueueWriter.write exception. connection=" + connection + " record=" + queueRecord, e);
            }
            this.onWriteFailure(connection, queueRecord, e);
            ReadyFutureImpl<WriteResult<Buffer, SocketAddress>> readyFutureImpl = ReadyFutureImpl.create(e);
            return readyFutureImpl;
        }
        finally {
            if (reenterants != null) {
                reenterants.decAndGet();
            }
        }
    }

    protected AsyncWriteQueueRecord createRecord(Connection connection, Buffer message, Future<WriteResult<Buffer, SocketAddress>> future, WriteResult<Buffer, SocketAddress> currentResult, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, Interceptor<WriteResult<Buffer, SocketAddress>> interceptor, SocketAddress dstAddress, Buffer outputBuffer, boolean isCloned, boolean isEmptyRecord) {
        return AsyncWriteQueueRecord.create(connection, message, future, currentResult, completionHandler, interceptor, dstAddress, outputBuffer, isCloned, isEmptyRecord);
    }

    @Override
    public final boolean isReady(Connection connection) {
        TaskQueue<AsyncWriteQueueRecord> connectionQueue = ((NIOConnection)connection).getAsyncWriteQueue();
        return connectionQueue != null && !connectionQueue.isEmpty();
    }

    @Override
    public void processAsync(Connection connection) throws IOException {
        boolean isLogFine = logger.isLoggable(Level.FINEST);
        NIOConnection nioConnection = (NIOConnection)connection;
        TaskQueue<AsyncWriteQueueRecord> connectionQueue = nioConnection.getAsyncWriteQueue();
        boolean done = false;
        AsyncWriteQueueRecord queueRecord = null;
        try {
            while ((queueRecord = connectionQueue.obtainCurrentElementAndReserve()) != null) {
                if (isLogFine) {
                    AbstractNIOAsyncQueueWriter.doFineLog("AsyncQueueWriter.processAsync doWriteconnection={0} record={1}", connection, queueRecord);
                }
                int bytesWritten = this.write0(nioConnection, queueRecord);
                int bytesToRelease = queueRecord.isEmptyRecord() ? 1 : bytesWritten;
                boolean bl = done = connectionQueue.releaseSpaceAndNotify(bytesToRelease) == 0;
                if (this.isFinished(queueRecord)) {
                    if (isLogFine) {
                        AbstractNIOAsyncQueueWriter.doFineLog("AsyncQueueWriter.processAsync finished connection={0} record={1}", connection, queueRecord);
                    }
                    this.onWriteComplete(queueRecord);
                    if (isLogFine) {
                        AbstractNIOAsyncQueueWriter.doFineLog("AsyncQueueWriter.processAsync nextRecord connection={0} nextRecord={1}", connection, queueRecord);
                    }
                    if (!done) continue;
                    return;
                }
                connectionQueue.setCurrentElement(queueRecord);
                if (isLogFine) {
                    AbstractNIOAsyncQueueWriter.doFineLog("AsyncQueueWriter.processAsync onReadyToWrite connection={0} peekRecord={1}", connection, queueRecord);
                }
                this.onReadyToWrite(connection);
                return;
            }
            if (!done) {
                this.onReadyToWrite(connection);
            }
        }
        catch (IOException e) {
            if (isLogFine) {
                logger.log(Level.FINEST, "AsyncQueueWriter.processAsync exception connection=" + connection + " peekRecord=" + queueRecord, e);
            }
            this.onWriteFailure(connection, queueRecord, e);
        }
    }

    private static void doFineLog(String msg, Object ... params) {
        logger.log(Level.FINEST, msg, params);
    }

    @Override
    public void onClose(Connection connection) {
        NIOConnection nioConnection = (NIOConnection)connection;
        TaskQueue<AsyncWriteQueueRecord> writeQueue = nioConnection.getAsyncWriteQueue();
        if (writeQueue != null) {
            AsyncWriteQueueRecord record;
            IOException error = this.cachedIOException;
            if (error == null) {
                this.cachedIOException = error = new IOException("Connection closed");
            }
            while ((record = writeQueue.obtainCurrentElementAndReserve()) != null) {
                this.failWriteRecord(record, error);
            }
        }
    }

    @Override
    public final void close() {
    }

    protected final void onWriteComplete(AsyncWriteQueueRecord record) throws IOException {
        WriteResult currentResult = (WriteResult)record.getCurrentResult();
        FutureImpl future = (FutureImpl)record.getFuture();
        CompletionHandler completionHandler = record.getCompletionHandler();
        Object originalMessage = record.getOriginalMessage();
        record.recycle();
        if (future != null) {
            future.result(currentResult);
        }
        if (completionHandler != null) {
            completionHandler.completed(currentResult);
        }
        if (originalMessage instanceof Buffer) {
            ((Buffer)originalMessage).tryDispose();
        }
    }

    protected final void onWriteIncomplete(AsyncWriteQueueRecord record) throws IOException {
        WriteResult currentResult = (WriteResult)record.getCurrentResult();
        CompletionHandler completionHandler = record.getCompletionHandler();
        if (completionHandler != null) {
            completionHandler.updated(currentResult);
        }
    }

    protected final void onWriteFailure(Connection connection, AsyncWriteQueueRecord failedRecord, IOException e) {
        this.failWriteRecord(failedRecord, e);
        try {
            connection.close().markForRecycle(true);
        }
        catch (IOException ignored) {
            // empty catch block
        }
    }

    protected final void failWriteRecord(AsyncWriteQueueRecord record, Throwable e) {
        boolean hasFuture;
        if (record == null) {
            return;
        }
        FutureImpl future = (FutureImpl)record.getFuture();
        boolean bl = hasFuture = future != null;
        if (!hasFuture || !future.isDone()) {
            CompletionHandler completionHandler = record.getCompletionHandler();
            if (completionHandler != null) {
                completionHandler.failed(e);
            }
            if (hasFuture) {
                future.failure(e);
            }
        }
    }

    private boolean isFinished(AsyncWriteQueueRecord queueRecord) {
        Buffer buffer = queueRecord.getOutputBuffer();
        return !buffer.hasRemaining();
    }

    protected abstract int write0(NIOConnection var1, AsyncWriteQueueRecord var2) throws IOException;

    protected abstract void onReadyToWrite(Connection var1) throws IOException;

    private Reenterant getWriteReenterants() {
        Thread t = Thread.currentThread();
        if (WorkerThread.class.isAssignableFrom(t.getClass())) {
            return this.reenterantsAttribute.get((WorkerThread)((Object)t));
        }
        return REENTERANTS_COUNTER.get();
    }

    private static final class Reenterant {
        private int counter;

        private Reenterant() {
        }

        public int incAndGet() {
            return ++this.counter;
        }

        public int decAndGet() {
            return --this.counter;
        }
    }
}

