/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.strategies;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.PostProcessor;
import org.glassfish.grizzly.ProcessorResult;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public abstract class AbstractIOStrategy
implements IOStrategy {
    private static final boolean[] isRegisterMap = new boolean[]{true, false, true, false, false, false, false};
    protected static final PostProcessor enableInterestPostProcessor = new EnableInterestPostProcessor();

    @Override
    public ThreadPoolConfig createDefaultWorkerPoolConfig(Transport transport) {
        ThreadPoolConfig config = ThreadPoolConfig.defaultConfig().clone();
        int coresCount = Runtime.getRuntime().availableProcessors();
        config.setCorePoolSize(coresCount * 2);
        config.setMaxPoolSize(coresCount * 2);
        config.setMemoryManager(transport.getMemoryManager());
        return config;
    }

    protected static boolean isReadWrite(IOEvent ioEvent) {
        return ioEvent == IOEvent.READ || ioEvent == IOEvent.WRITE;
    }

    protected static boolean isExecuteInWorkerThread(IOEvent ioEvent) {
        return AbstractIOStrategy.isReadWrite(ioEvent) || ioEvent == IOEvent.CLOSED;
    }

    protected static Executor getWorkerThreadPool(Connection c) {
        return c.getTransport().getWorkerThreadPool();
    }

    protected static void fireIOEvent(Connection connection, IOEvent ioEvent, PostProcessor pp, Logger logger) {
        try {
            connection.getTransport().fireIOEvent(ioEvent, connection, pp);
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Uncaught exception: ", e);
            try {
                connection.close().markForRecycle(true);
            }
            catch (IOException ee) {
                logger.log(Level.WARNING, "Exception occurred when closing the connection: ", ee);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Uncaught exception: ", e);
            try {
                connection.close().markForRecycle(true);
            }
            catch (IOException ee) {
                logger.log(Level.WARNING, "Exception occurred when closing the connection: ", ee);
            }
        }
    }

    private static class EnableInterestPostProcessor
    implements PostProcessor {
        private EnableInterestPostProcessor() {
        }

        @Override
        public void process(Context context, ProcessorResult.Status status) throws IOException {
            if (isRegisterMap[status.ordinal()]) {
                IOEvent ioEvent = context.getIoEvent();
                Connection connection = context.getConnection();
                connection.enableIOEvent(ioEvent);
            }
        }
    }
}

