/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.streams;

import java.io.IOException;
import java.util.concurrent.Future;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.streams.Output;
import org.glassfish.grizzly.streams.StreamWriter;

public class StreamOutput
implements Output {
    private final StreamWriter streamWriter;
    private Future<Integer> updateHandlerFuture;
    private final Object updateHandlerSync = new Object();

    public StreamOutput(StreamWriter streamWriter) {
        this.streamWriter = streamWriter;
    }

    @Override
    public void write(byte data) throws IOException {
        this.streamWriter.writeByte(data);
    }

    @Override
    public void write(Buffer buffer) throws IOException {
        this.streamWriter.writeBuffer(buffer);
    }

    @Override
    public boolean isBuffered() {
        return false;
    }

    @Override
    public void ensureBufferCapacity(int size) throws IOException {
    }

    @Override
    public Buffer getBuffer() {
        throw new UnsupportedOperationException("Buffer is not available in StreamOutput");
    }

    @Override
    public GrizzlyFuture<Integer> flush(CompletionHandler<Integer> completionHandler) throws IOException {
        return this.streamWriter.flush(completionHandler);
    }

    @Override
    public GrizzlyFuture<Integer> close(CompletionHandler<Integer> completionHandler) throws IOException {
        return this.streamWriter.close(completionHandler);
    }
}

