/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.impl.FutureImpl;

public class CompletionHandlerAdapter<A, B>
implements CompletionHandler<B> {
    private static final ResultAdapter DIRECT_ADAPTER = new ResultAdapter(){

        public Object adapt(Object result) {
            return result;
        }
    };
    private final ResultAdapter<A, B> adapter;
    private final FutureImpl<A> future;
    private final CompletionHandler<A> completionHandler;

    public CompletionHandlerAdapter(FutureImpl<A> future) {
        this(future, null);
    }

    public CompletionHandlerAdapter(FutureImpl<A> future, CompletionHandler<A> completionHandler) {
        this(future, completionHandler, null);
    }

    public CompletionHandlerAdapter(FutureImpl<A> future, CompletionHandler<A> completionHandler, ResultAdapter<A, B> adapter) {
        this.future = future;
        this.completionHandler = completionHandler;
        this.adapter = adapter != null ? adapter : CompletionHandlerAdapter.getDirectAdapter();
    }

    @Override
    public void cancelled() {
        this.future.cancel(false);
        if (this.completionHandler != null) {
            this.completionHandler.cancelled();
        }
    }

    @Override
    public void failed(Throwable throwable) {
        this.future.failure(throwable);
        if (this.completionHandler != null) {
            this.completionHandler.failed(throwable);
        }
    }

    @Override
    public void completed(B result) {
        A adaptedResult = this.adapt(result);
        this.future.result(adaptedResult);
        if (this.completionHandler != null) {
            this.completionHandler.completed(adaptedResult);
        }
    }

    @Override
    public void updated(B result) {
        A adaptedResult = this.adapter.adapt(result);
        if (this.completionHandler != null) {
            this.completionHandler.updated(adaptedResult);
        }
    }

    protected A adapt(B result) {
        return this.adapter.adapt(result);
    }

    private static <K, V> ResultAdapter<K, V> getDirectAdapter() {
        return DIRECT_ADAPTER;
    }

    public static interface ResultAdapter<K, V> {
        public K adapt(V var1);
    }
}

