/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.PostProcessor;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorResult;

public final class ProcessorExecutor {
    private static final Logger LOGGER = Grizzly.logger(ProcessorExecutor.class);

    public static boolean execute(Connection connection, IOEvent ioEvent, Processor processor, PostProcessor postProcessor) throws IOException {
        Context context = Context.create(connection, processor, ioEvent);
        context.setPostProcessor(postProcessor);
        return ProcessorExecutor.execute(context);
    }

    public static boolean execute(Context context) throws IOException {
        ProcessorResult.Status status;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "executing connection ({0}). IOEvent={1} processor={2}", new Object[]{context.getConnection(), context.getIoEvent(), context.getProcessor()});
        }
        block5: while (true) {
            ProcessorResult result = context.getProcessor().process(context);
            status = result.getStatus();
            Object resultContext = result.getContext();
            result.recycle();
            switch (status) {
                case TERMINATE: {
                    return false;
                }
                case RERUN: {
                    context = (Context)resultContext;
                    continue block5;
                }
                case REREGISTER: {
                    ProcessorExecutor.complete(context, status, false);
                    return true;
                }
            }
            break;
        }
        ProcessorExecutor.complete(context, status, true);
        return status == ProcessorResult.Status.COMPLETE;
    }

    public static boolean resume(Context context) throws IOException {
        return ProcessorExecutor.execute(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void complete(Context context, ProcessorResult.Status status, boolean isRecycleContext) throws IOException {
        PostProcessor postProcessor = context.getPostProcessor();
        try {
            if (postProcessor != null) {
                postProcessor.process(context, status);
            }
        }
        finally {
            if (isRecycleContext) {
                context.recycle();
            }
        }
    }
}

