/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.asyncqueue;

import java.util.concurrent.Future;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Interceptor;
import org.glassfish.grizzly.utils.DebugPoint;

public abstract class AsyncQueueRecord<R>
implements Cacheable {
    protected Connection connection;
    protected Object originalMessage;
    protected Object message;
    protected Future future;
    protected R currentResult;
    protected CompletionHandler completionHandler;
    protected Interceptor interceptor;
    protected boolean isRecycled = false;
    protected DebugPoint recycleTrack;

    public AsyncQueueRecord(Connection connection, Object originalMessage, Future future, R currentResult, CompletionHandler completionHandler, Interceptor interceptor) {
        this.set(connection, originalMessage, future, currentResult, completionHandler, interceptor);
    }

    protected final void set(Connection connection, Object originalMessage, Future future, R currentResult, CompletionHandler completionHandler, Interceptor interceptor) {
        this.checkRecycled();
        this.connection = connection;
        this.originalMessage = originalMessage;
        this.message = originalMessage;
        this.future = future;
        this.currentResult = currentResult;
        this.completionHandler = completionHandler;
        this.interceptor = interceptor;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Object getOriginalMessage() {
        this.checkRecycled();
        return this.originalMessage;
    }

    public final Object getMessage() {
        this.checkRecycled();
        return this.message;
    }

    public final void setMessage(Object message) {
        this.checkRecycled();
        this.message = message;
    }

    public final Future getFuture() {
        this.checkRecycled();
        return this.future;
    }

    public void setFuture(Future future) {
        this.checkRecycled();
        this.future = future;
    }

    public final R getCurrentResult() {
        this.checkRecycled();
        return this.currentResult;
    }

    public final CompletionHandler getCompletionHandler() {
        this.checkRecycled();
        return this.completionHandler;
    }

    public final Interceptor getInterceptor() {
        this.checkRecycled();
        return this.interceptor;
    }

    protected final void checkRecycled() {
        if (Grizzly.isTrackingThreadCache() && this.isRecycled) {
            DebugPoint track = this.recycleTrack;
            if (track != null) {
                throw new IllegalStateException("AsyncReadQueueRecord has been recycled at: " + track);
            }
            throw new IllegalStateException("AsyncReadQueueRecord has been recycled");
        }
    }
}

