/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectorHandler;
import org.glassfish.grizzly.nio.SelectorHandlerTask;
import org.glassfish.grizzly.nio.SelectorRunner;

public class DefaultSelectorHandler
implements SelectorHandler {
    private static final long DEFAULT_SELECT_TIMEOUT_MILLIS = 30000L;
    private static final Logger logger = Grizzly.logger(DefaultSelectorHandler.class);
    public static final boolean IS_WORKAROUND_SELECTOR_SPIN = System.getProperty("os.name").equalsIgnoreCase("linux") && !System.getProperty("java.version").startsWith("1.7");
    protected final long selectTimeout;
    private static final int SPIN_RATE_THRESHOLD = 2000;
    private long lastSpinTimestamp;
    private int emptySpinCounter;
    private final Map<Selector, Long> spinnedSelectorsHistory;
    private final Object spinSync;

    public DefaultSelectorHandler() {
        this(30000L, TimeUnit.MILLISECONDS);
    }

    public DefaultSelectorHandler(long selectTimeout, TimeUnit timeunit) {
        this.selectTimeout = TimeUnit.MILLISECONDS.convert(selectTimeout, timeunit);
        this.spinnedSelectorsHistory = new WeakHashMap<Selector, Long>();
        this.spinSync = new Object();
    }

    @Override
    public long getSelectTimeout() {
        return this.selectTimeout;
    }

    @Override
    public void preSelect(SelectorRunner selectorRunner) throws IOException {
        this.processPendingTasks(selectorRunner);
    }

    @Override
    public Set<SelectionKey> select(SelectorRunner selectorRunner) throws IOException {
        Selector selector = selectorRunner.getSelector();
        if (selectorRunner.getPostponedTasks().isEmpty()) {
            selector.select(this.selectTimeout);
        } else {
            selector.selectNow();
        }
        Set<SelectionKey> selectedKeys = selector.selectedKeys();
        if (IS_WORKAROUND_SELECTOR_SPIN) {
            if (!selectedKeys.isEmpty()) {
                this.resetSpinCounter();
            } else {
                long sr = this.getSpinRate();
                if (sr > 2000L) {
                    this.workaroundSelectorSpin(selectorRunner);
                }
            }
        }
        return selectedKeys;
    }

    @Override
    public void postSelect(SelectorRunner selectorRunner) throws IOException {
    }

    @Override
    public void registerKeyInterest(SelectorRunner selectorRunner, SelectionKey key, int interest) throws IOException {
        if (Thread.currentThread() == selectorRunner.getRunnerThread()) {
            this.registerKey0(key, interest);
        } else {
            RegisterKeyTask task = new RegisterKeyTask(key, interest);
            this.addPendingTask(selectorRunner, task);
        }
    }

    @Override
    public void deregisterKeyInterest(SelectorRunner selectorRunner, SelectionKey key, int interest) throws IOException {
        if (Thread.currentThread() == selectorRunner.getRunnerThread()) {
            this.deregisterKey0(key, interest);
        } else {
            DeRegisterKeyTask task = new DeRegisterKeyTask(key, interest);
            this.addPendingTask(selectorRunner, task);
        }
    }

    @Override
    public void registerChannel(SelectorRunner selectorRunner, SelectableChannel channel, int interest, Object attachment) throws IOException {
        GrizzlyFuture<RegisterChannelResult> future = this.registerChannelAsync(selectorRunner, channel, interest, attachment, null);
        try {
            future.get(this.selectTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public GrizzlyFuture<RegisterChannelResult> registerChannelAsync(SelectorRunner selectorRunner, SelectableChannel channel, int interest, Object attachment, CompletionHandler<RegisterChannelResult> completionHandler) throws IOException {
        SafeFutureImpl<RegisterChannelResult> future = SafeFutureImpl.create();
        if (Thread.currentThread() == selectorRunner.getRunnerThread()) {
            this.registerChannel0(selectorRunner, channel, interest, attachment, completionHandler, future);
        } else {
            RegisterChannelOperation task = new RegisterChannelOperation(channel, interest, attachment, future, completionHandler);
            this.addPendingTask(selectorRunner, task);
        }
        return future;
    }

    @Override
    public void deregisterChannel(SelectorRunner selectorRunner, SelectableChannel channel) throws IOException {
        GrizzlyFuture<RegisterChannelResult> future = this.deregisterChannelAsync(selectorRunner, channel, null);
        try {
            future.get(this.selectTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public GrizzlyFuture<RegisterChannelResult> deregisterChannelAsync(SelectorRunner selectorRunner, SelectableChannel channel, CompletionHandler<RegisterChannelResult> completionHandler) throws IOException {
        SafeFutureImpl<RegisterChannelResult> future = SafeFutureImpl.create();
        if (Thread.currentThread() == selectorRunner.getRunnerThread()) {
            this.deregisterChannel0(selectorRunner, channel, completionHandler, future);
        } else {
            DeregisterChannelOperation task = new DeregisterChannelOperation(channel, future, completionHandler);
            this.addPendingTask(selectorRunner, task);
        }
        return future;
    }

    @Override
    public GrizzlyFuture<Runnable> executeInSelectorThread(SelectorRunner selectorRunner, Runnable runnableTask, CompletionHandler<Runnable> completionHandler) {
        if (Thread.currentThread() == selectorRunner.getRunnerThread()) {
            try {
                runnableTask.run();
            }
            catch (Exception e) {
                if (completionHandler != null) {
                    completionHandler.failed(e);
                }
                return ReadyFutureImpl.create(e);
            }
            if (completionHandler != null) {
                completionHandler.completed(runnableTask);
            }
            return ReadyFutureImpl.create(runnableTask);
        }
        SafeFutureImpl<Runnable> future = SafeFutureImpl.create();
        RunnableTask task = new RunnableTask(runnableTask, future, completionHandler);
        this.addPendingTask(selectorRunner, task);
        return future;
    }

    private void addPendingTask(SelectorRunner selectorRunner, SelectorHandlerTask task) {
        Queue<SelectorHandlerTask> pendingTasks = selectorRunner.getPendingTasks();
        pendingTasks.offer(task);
        selectorRunner.wakeupSelector();
    }

    private void processPendingTasks(SelectorRunner selectorRunner) throws IOException {
        this.processPendingTaskQueue(selectorRunner, selectorRunner.getPostponedTasks());
        this.processPendingTaskQueue(selectorRunner, selectorRunner.getPendingTasks());
    }

    private void processPendingTaskQueue(SelectorRunner selectorRunner, Queue<SelectorHandlerTask> selectorHandlerTasks) throws IOException {
        SelectorHandlerTask selectorHandlerTask;
        while ((selectorHandlerTask = selectorHandlerTasks.poll()) != null) {
            selectorHandlerTask.run(selectorRunner);
        }
    }

    private void registerKey0(SelectionKey selectionKey, int interest) {
        int currentOps;
        if (selectionKey.isValid() && ((currentOps = selectionKey.interestOps()) & interest) != interest) {
            selectionKey.interestOps(currentOps | interest);
        }
    }

    private void deregisterKey0(SelectionKey selectionKey, int interest) {
        int currentOps;
        if (selectionKey.isValid() && ((currentOps = selectionKey.interestOps()) & interest) != 0) {
            selectionKey.interestOps(currentOps & ~interest);
        }
    }

    private void registerChannel0(SelectorRunner selectorRunner, SelectableChannel channel, int interest, Object attachment, CompletionHandler<RegisterChannelResult> completionHandler, FutureImpl<RegisterChannelResult> future) throws IOException {
        if (future == null || !future.isCancelled()) {
            try {
                if (channel.isOpen()) {
                    Selector selector = selectorRunner.getSelector();
                    SelectionKey key = channel.keyFor(selector);
                    if (key == null || key.isValid()) {
                        SelectionKey registeredSelectionKey = channel.register(selector, interest, attachment);
                        selectorRunner.getTransport().getSelectionKeyHandler().onKeyRegistered(registeredSelectionKey);
                        RegisterChannelResult result = new RegisterChannelResult(selectorRunner, registeredSelectionKey, channel);
                        if (completionHandler != null) {
                            completionHandler.completed(result);
                        }
                        if (future != null) {
                            future.result(result);
                        }
                        return;
                    }
                    selectorRunner.getPostponedTasks().add(new RegisterChannelOperation(channel, interest, attachment, future, completionHandler));
                } else {
                    ClosedChannelException error = new ClosedChannelException();
                    if (completionHandler != null) {
                        completionHandler.failed(error);
                    }
                    if (future != null) {
                        future.failure(error);
                    }
                }
            }
            catch (IOException e) {
                if (completionHandler != null) {
                    completionHandler.failed(e);
                }
                if (future != null) {
                    future.failure(e);
                }
                throw e;
            }
        }
    }

    private void deregisterChannel0(SelectorRunner selectorRunner, SelectableChannel channel, CompletionHandler<RegisterChannelResult> completionHandler, FutureImpl<RegisterChannelResult> future) throws IOException {
        if (future == null || !future.isCancelled()) {
            Exception error;
            if (channel.isOpen()) {
                Selector selector = selectorRunner.getSelector();
                SelectionKey key = channel.keyFor(selector);
                if (key != null) {
                    selectorRunner.getTransport().getSelectionKeyHandler().cancel(key);
                    selectorRunner.getTransport().getSelectionKeyHandler().onKeyDeregistered(key);
                    RegisterChannelResult result = new RegisterChannelResult(selectorRunner, key, channel);
                    if (completionHandler != null) {
                        completionHandler.completed(result);
                    }
                    if (future != null) {
                        future.result(result);
                    }
                    return;
                }
                error = new IllegalStateException("Channel is not registered");
            } else {
                error = new ClosedChannelException();
            }
            if (completionHandler != null) {
                completionHandler.failed(error);
            }
            if (future != null) {
                future.failure(error);
            }
        }
    }

    @Override
    public boolean onSelectorClosed(SelectorRunner selectorRunner) {
        try {
            this.workaroundSelectorSpin(selectorRunner);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void resetSpinCounter() {
        this.emptySpinCounter = 0;
    }

    private int getSpinRate() {
        if (this.emptySpinCounter++ == 0) {
            this.lastSpinTimestamp = System.nanoTime();
        } else if (this.emptySpinCounter == 1000) {
            long deltatime = System.nanoTime() - this.lastSpinTimestamp;
            int contspinspersec = (int)(1000000000000L / deltatime);
            this.emptySpinCounter = 0;
            return contspinspersec;
        }
        return 0;
    }

    private SelectionKey checkIfSpinnedKey(SelectorRunner selectorRunner, SelectionKey key) {
        if (!key.isValid() && key.channel().isOpen() && this.spinnedSelectorsHistory.containsKey(key.selector())) {
            SelectionKey newKey = key.channel().keyFor(selectorRunner.getSelector());
            newKey.attach(key.attachment());
            return newKey;
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workaroundSelectorSpin(SelectorRunner selectorRunner) throws IOException {
        Object object = this.spinSync;
        synchronized (object) {
            this.spinnedSelectorsHistory.put(selectorRunner.getSelector(), System.currentTimeMillis());
            selectorRunner.switchToNewSelector();
        }
    }

    protected static final class RunnableTask
    implements SelectorHandlerTask {
        private final Runnable task;
        private final FutureImpl<Runnable> future;
        private final CompletionHandler<Runnable> completionHandler;

        private RunnableTask(Runnable task, FutureImpl<Runnable> future, CompletionHandler<Runnable> completionHandler) {
            this.task = task;
            this.future = future;
            this.completionHandler = completionHandler;
        }

        @Override
        public void run(SelectorRunner selectorRunner) throws IOException {
            try {
                this.task.run();
                if (this.completionHandler != null) {
                    this.completionHandler.completed(this.task);
                }
                this.future.result(this.task);
            }
            catch (Throwable t) {
                logger.log(Level.FINEST, "doExecutePendiongIO failed.", t);
                if (this.completionHandler != null) {
                    this.completionHandler.completed(this.task);
                }
                this.future.failure(t);
            }
        }
    }

    protected final class DeregisterChannelOperation
    implements SelectorHandlerTask {
        private final SelectableChannel channel;
        private final FutureImpl<RegisterChannelResult> future;
        private final CompletionHandler<RegisterChannelResult> completionHandler;

        private DeregisterChannelOperation(SelectableChannel channel, FutureImpl<RegisterChannelResult> future, CompletionHandler<RegisterChannelResult> completionHandler) {
            this.channel = channel;
            this.future = future;
            this.completionHandler = completionHandler;
        }

        @Override
        public void run(SelectorRunner selectorRunner) throws IOException {
            DefaultSelectorHandler.this.deregisterChannel0(selectorRunner, this.channel, this.completionHandler, this.future);
        }
    }

    protected final class RegisterChannelOperation
    implements SelectorHandlerTask {
        private final SelectableChannel channel;
        private final int interest;
        private final Object attachment;
        private final FutureImpl<RegisterChannelResult> future;
        private final CompletionHandler<RegisterChannelResult> completionHandler;

        private RegisterChannelOperation(SelectableChannel channel, int interest, Object attachment, FutureImpl<RegisterChannelResult> future, CompletionHandler<RegisterChannelResult> completionHandler) {
            this.channel = channel;
            this.interest = interest;
            this.attachment = attachment;
            this.future = future;
            this.completionHandler = completionHandler;
        }

        @Override
        public void run(SelectorRunner selectorRunner) throws IOException {
            DefaultSelectorHandler.this.registerChannel0(selectorRunner, this.channel, this.interest, this.attachment, this.completionHandler, this.future);
        }
    }

    protected final class DeRegisterKeyTask
    implements SelectorHandlerTask {
        private final SelectionKey selectionKey;
        private final int interest;

        public DeRegisterKeyTask(SelectionKey selectionKey, int interest) {
            this.selectionKey = selectionKey;
            this.interest = interest;
        }

        @Override
        public void run(SelectorRunner selectorRunner) throws IOException {
            SelectionKey localSelectionKey = this.selectionKey;
            if (IS_WORKAROUND_SELECTOR_SPIN) {
                localSelectionKey = DefaultSelectorHandler.this.checkIfSpinnedKey(selectorRunner, this.selectionKey);
            }
            DefaultSelectorHandler.this.deregisterKey0(localSelectionKey, this.interest);
        }
    }

    protected final class RegisterKeyTask
    implements SelectorHandlerTask {
        private final SelectionKey selectionKey;
        private final int interest;

        public RegisterKeyTask(SelectionKey selectionKey, int interest) {
            this.selectionKey = selectionKey;
            this.interest = interest;
        }

        @Override
        public void run(SelectorRunner selectorRunner) throws IOException {
            SelectionKey localSelectionKey = this.selectionKey;
            if (IS_WORKAROUND_SELECTOR_SPIN) {
                localSelectionKey = DefaultSelectorHandler.this.checkIfSpinnedKey(selectorRunner, this.selectionKey);
            }
            DefaultSelectorHandler.this.registerKey0(localSelectionKey, this.interest);
        }
    }
}

