/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.AbstractSocketConnectorHandler;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.PostProcessor;
import org.glassfish.grizzly.ProcessorResult;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectionKeyHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public class TCPNIOConnectorHandler
extends AbstractSocketConnectorHandler {
    private static final Logger LOGGER = Grizzly.logger(TCPNIOConnectorHandler.class);
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    private final InstantConnectHandler instantConnectHandler;
    protected boolean isReuseAddress;
    protected volatile long connectionTimeoutMillis = 30000L;
    private static final boolean[] isRegisterMap = new boolean[]{true, false, true, false, false, false, true};

    protected TCPNIOConnectorHandler(TCPNIOTransport transport) {
        super(transport);
        this.connectionTimeoutMillis = transport.getConnectionTimeout();
        this.isReuseAddress = transport.isReuseAddress();
        this.instantConnectHandler = new InstantConnectHandler();
    }

    @Override
    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) throws IOException {
        if (!this.transport.isBlocking()) {
            return this.connectAsync(remoteAddress, localAddress, completionHandler);
        }
        return this.connectSync(remoteAddress, localAddress, completionHandler);
    }

    protected GrizzlyFuture<Connection> connectSync(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) throws IOException {
        GrizzlyFuture<Connection> future = this.connectAsync(remoteAddress, localAddress, completionHandler);
        this.waitNIOFuture(future);
        return future;
    }

    protected GrizzlyFuture<Connection> connectAsync(SocketAddress remoteAddress, SocketAddress localAddress, final CompletionHandler<Connection> completionHandler) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        Socket socket = socketChannel.socket();
        socket.setReuseAddress(this.isReuseAddress);
        if (localAddress != null) {
            socket.bind(localAddress);
        }
        socketChannel.configureBlocking(false);
        TCPNIOTransport nioTransport = (TCPNIOTransport)this.transport;
        final TCPNIOConnection newConnection = nioTransport.obtainNIOConnection(socketChannel);
        this.preConfigure(newConnection);
        newConnection.setProcessor(this.getProcessor());
        newConnection.setProcessorSelector(this.getProcessorSelector());
        try {
            final SafeFutureImpl<Connection> connectFuture = SafeFutureImpl.create();
            boolean isConnected = socketChannel.connect(remoteAddress);
            newConnection.setConnectHandler(new Callable<Connection>(){

                @Override
                public Connection call() throws Exception {
                    TCPNIOConnectorHandler.onConnectedAsync(newConnection, connectFuture, completionHandler);
                    return null;
                }
            });
            GrizzlyFuture<RegisterChannelResult> registerChannelFuture = isConnected ? nioTransport.getNIOChannelDistributor().registerChannelAsync(socketChannel, 0, newConnection, this.instantConnectHandler) : nioTransport.getNIOChannelDistributor().registerChannelAsync(socketChannel, 8, newConnection, nioTransport.selectorRegistrationHandler);
            registerChannelFuture.markForRecycle(false);
            return connectFuture;
        }
        catch (Exception e) {
            if (completionHandler != null) {
                completionHandler.failed(e);
            }
            return ReadyFutureImpl.create(e);
        }
    }

    protected static void onConnectedAsync(TCPNIOConnection connection, FutureImpl<Connection> connectFuture, CompletionHandler<Connection> completionHandler) throws IOException {
        try {
            TCPNIOTransport tcpTransport = (TCPNIOTransport)connection.getTransport();
            SocketChannel channel = (SocketChannel)connection.getChannel();
            if (!channel.isConnected()) {
                channel.finishConnect();
            }
            connection.resetProperties();
            connection.disableIOEvent(IOEvent.CLIENT_CONNECTED);
            tcpTransport.configureChannel(channel);
            tcpTransport.fireIOEvent(IOEvent.CONNECTED, connection, new EnableReadPostProcessor(connectFuture, completionHandler));
        }
        catch (Exception e) {
            if (completionHandler != null) {
                completionHandler.failed(e);
            }
            connectFuture.failure(e);
            throw new IOException("Connect exception", e);
        }
    }

    public boolean isReuseAddress() {
        return this.isReuseAddress;
    }

    public void setReuseAddress(boolean isReuseAddress) {
        this.isReuseAddress = isReuseAddress;
    }

    public long getSyncConnectTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void setSyncConnectTimeout(long timeout, TimeUnit timeUnit) {
        this.connectionTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }

    protected <E> E waitNIOFuture(Future<E> future) throws IOException {
        try {
            return future.get(this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException("Connection was interrupted!");
        }
        catch (TimeoutException e) {
            throw new IOException("Channel registration on Selector timeout!");
        }
        catch (ExecutionException e) {
            Throwable internalException = e.getCause();
            if (internalException instanceof IOException) {
                throw (IOException)internalException;
            }
            throw new IOException("Unexpected exception connection exception. " + internalException.getClass().getName() + ": " + internalException.getMessage());
        }
        catch (CancellationException e) {
            throw new IOException("Connection was cancelled!");
        }
    }

    public static Builder builder(TCPNIOTransport transport) {
        return new Builder(transport);
    }

    public static class Builder
    extends AbstractSocketConnectorHandler.Builder<Builder> {
        protected Builder(TCPNIOTransport transport) {
            super(new TCPNIOConnectorHandler(transport));
        }

        public TCPNIOConnectorHandler build() {
            return (TCPNIOConnectorHandler)this.connectorHandler;
        }

        public Builder setReuseAddress(boolean isReuseAddress) {
            ((TCPNIOConnectorHandler)this.connectorHandler).setReuseAddress(isReuseAddress);
            return this;
        }

        public Builder setSyncConnectTimeout(long timeout, TimeUnit timeunit) {
            ((TCPNIOConnectorHandler)this.connectorHandler).setSyncConnectTimeout(timeout, timeunit);
            return this;
        }
    }

    private static class EnableReadPostProcessor
    implements PostProcessor {
        private final FutureImpl<Connection> connectFuture;
        private final CompletionHandler<Connection> completionHandler;

        private EnableReadPostProcessor(FutureImpl<Connection> connectFuture, CompletionHandler<Connection> completionHandler) {
            this.connectFuture = connectFuture;
            this.completionHandler = completionHandler;
        }

        @Override
        public void process(Context context, ProcessorResult.Status status) throws IOException {
            if (isRegisterMap[status.ordinal()]) {
                NIOConnection connection = (NIOConnection)context.getConnection();
                if (this.completionHandler != null) {
                    this.completionHandler.completed(connection);
                }
                this.connectFuture.result(connection);
                if (!connection.isStandalone()) {
                    connection.enableIOEvent(IOEvent.READ);
                }
            }
        }
    }

    private class InstantConnectHandler
    extends EmptyCompletionHandler<RegisterChannelResult> {
        private InstantConnectHandler() {
        }

        @Override
        public void completed(RegisterChannelResult result) {
            TCPNIOTransport transport = (TCPNIOTransport)TCPNIOConnectorHandler.this.transport;
            transport.selectorRegistrationHandler.completed(result);
            SelectionKey selectionKey = result.getSelectionKey();
            SelectionKeyHandler selectionKeyHandler = transport.getSelectionKeyHandler();
            TCPNIOConnection connection = (TCPNIOConnection)selectionKeyHandler.getConnectionForKey(selectionKey);
            try {
                connection.onConnect();
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Exception happened, when trying to connect the channel", e);
            }
        }
    }
}

