/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;

public class UDPNIOConnection
extends NIOConnection {
    private static final Logger LOGGER = Grizzly.logger(UDPNIOConnection.class);
    private SocketAddress localSocketAddress;
    private SocketAddress peerSocketAddress;

    public UDPNIOConnection(UDPNIOTransport transport, DatagramChannel channel) {
        super(transport);
        this.channel = channel;
        this.resetProperties();
    }

    public boolean isConnected() {
        return this.channel != null && ((DatagramChannel)this.channel).isConnected();
    }

    public void register() throws IOException {
        GrizzlyFuture<RegisterChannelResult> future = this.transport.getNIOChannelDistributor().registerChannelAsync(this.channel, this.isStandalone() ? 0 : 1, this, ((UDPNIOTransport)this.transport).registerChannelCompletionHandler);
        try {
            future.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new IOException("Error registering server channel key", e);
        }
    }

    @Override
    protected void setSelectionKey(SelectionKey selectionKey) {
        super.setSelectionKey(selectionKey);
    }

    @Override
    protected void setSelectorRunner(SelectorRunner selectorRunner) {
        super.setSelectorRunner(selectorRunner);
    }

    @Override
    protected void preClose() {
        try {
            this.transport.fireIOEvent(IOEvent.CLOSED, this, null);
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Unexpected IOExcption occurred, when firing CLOSE event");
        }
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.peerSocketAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localSocketAddress;
    }

    protected final void resetProperties() {
        if (this.channel != null) {
            this.setReadBufferSize(this.transport.getReadBufferSize());
            this.setWriteBufferSize(this.transport.getWriteBufferSize());
            this.localSocketAddress = ((DatagramChannel)this.channel).socket().getLocalSocketAddress();
            this.peerSocketAddress = ((DatagramChannel)this.channel).socket().getRemoteSocketAddress();
        }
    }

    @Override
    public void setReadBufferSize(int readBufferSize) {
        DatagramSocket socket = ((DatagramChannel)this.channel).socket();
        try {
            int socketReadBufferSize = socket.getReceiveBufferSize();
            if (readBufferSize != -1) {
                if (readBufferSize > socketReadBufferSize) {
                    socket.setReceiveBufferSize(readBufferSize);
                }
                super.setReadBufferSize(readBufferSize);
            } else {
                super.setReadBufferSize(socketReadBufferSize);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error setting read buffer size", e);
        }
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        DatagramSocket socket = ((DatagramChannel)this.channel).socket();
        try {
            int socketWriteBufferSize = socket.getSendBufferSize();
            if (writeBufferSize != -1) {
                if (writeBufferSize > socketWriteBufferSize) {
                    socket.setSendBufferSize(writeBufferSize);
                }
                super.setWriteBufferSize(writeBufferSize);
            } else {
                super.setWriteBufferSize(socketWriteBufferSize);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error setting write buffer size", e);
        }
    }

    protected final void onConnect() throws IOException {
        UDPNIOConnection.notifyProbesConnect(this);
    }

    protected final void onRead(Buffer data, int size) {
        if (size > 0) {
            UDPNIOConnection.notifyProbesRead(this, data, size);
        }
        this.checkEmptyRead(size);
    }

    protected final void onWrite(Buffer data, int size) {
        UDPNIOConnection.notifyProbesWrite(this, data, size);
    }

    void setMonitoringProbes(ConnectionProbe[] monitoringProbes) {
        this.monitoringConfig.addProbes(monitoringProbes);
    }
}

