/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import org.glassfish.grizzly.utils.LinkedTransferQueue;
import org.glassfish.grizzly.utils.ObjectPool;
import org.glassfish.grizzly.utils.PoolableObject;

public abstract class ConcurrentQueuePool<E extends PoolableObject>
implements ObjectPool<E> {
    private final LinkedTransferQueue<E> pool = new LinkedTransferQueue();

    public abstract E newInstance();

    @Override
    public E poll() {
        PoolableObject object = (PoolableObject)this.pool.poll();
        if (object == null) {
            object = this.newInstance();
        }
        object.prepare();
        return (E)object;
    }

    @Override
    public void offer(E object) {
        object.release();
        this.pool.offer(object);
    }

    @Override
    public void clear() {
        this.pool.clear();
    }
}

