/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.GrizzlyTestCase;
import org.glassfish.grizzly.StandaloneProcessor;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.streams.AbstractStreamReader;
import org.glassfish.grizzly.streams.BufferedInput;
import org.glassfish.grizzly.streams.Input;
import org.glassfish.grizzly.streams.StreamReader;
import org.glassfish.grizzly.streams.StreamWriter;
import org.glassfish.grizzly.utils.DataStructures;
import org.glassfish.grizzly.utils.conditions.Condition;

public class ByteBufferStreamsTest
extends GrizzlyTestCase {
    public static final int PORT = 7778;
    private static final Logger LOGGER = Grizzly.logger(ByteBufferStreamsTest.class);
    private final FutureImpl<Boolean> poisonFuture = SafeFutureImpl.create();
    private Connection clientconnection = null;
    private TCPNIOTransport servertransport = null;
    private StreamWriter clientWriter = null;
    private final BlockingQueue<Checker> checkerQueue = DataStructures.getLTQInstance(Checker.class);
    private TCPNIOTransport clienttransport;

    private static Checker comp(Checker ... arg) {
        return new CompositeChecker(arg);
    }

    private static Checker rep(int count, Checker ch) {
        return new RepeatedChecker(count, ch);
    }

    private static Checker z(boolean arg) {
        return new BooleanChecker(arg);
    }

    private static Checker b(byte arg) {
        return new ByteChecker(arg);
    }

    private static Checker c(char arg) {
        return new CharChecker(arg);
    }

    private static Checker s(short arg) {
        return new ShortChecker(arg);
    }

    private static Checker i(int arg) {
        return new IntChecker(arg);
    }

    private static Checker l(long arg) {
        return new LongChecker(arg);
    }

    private static Checker f(float arg) {
        return new FloatChecker(arg);
    }

    private static Checker d(double arg) {
        return new DoubleChecker(arg);
    }

    private static Checker za(int size, boolean arg) {
        return new BooleanArrayChecker(size, arg);
    }

    private static Checker ba(int size, byte arg) {
        return new ByteArrayChecker(size, arg);
    }

    private static Checker ca(int size, char arg) {
        return new CharArrayChecker(size, arg);
    }

    private static Checker sa(int size, short arg) {
        return new ShortArrayChecker(size, arg);
    }

    private static Checker ia(int size, int arg) {
        return new IntArrayChecker(size, arg);
    }

    private static Checker la(int size, long arg) {
        return new LongArrayChecker(size, arg);
    }

    private static Checker fa(int size, float arg) {
        return new FloatArrayChecker(size, arg);
    }

    private static Checker da(int size, double arg) {
        return new DoubleArrayChecker(size, arg);
    }

    public void testStreaming() throws Exception {
        int REPEAT_COUNT = 4;
        Checker ch = ByteBufferStreamsTest.rep(REPEAT_COUNT, ByteBufferStreamsTest.comp(ByteBufferStreamsTest.z(true), ByteBufferStreamsTest.b((byte)46), ByteBufferStreamsTest.c('A'), ByteBufferStreamsTest.s((short)2343), ByteBufferStreamsTest.i(231231), ByteBufferStreamsTest.l(-789789789789L), ByteBufferStreamsTest.f(123.23f), ByteBufferStreamsTest.d(2321.3232213)));
        this.send(ch);
        ch = ByteBufferStreamsTest.rep(REPEAT_COUNT, ByteBufferStreamsTest.comp(ByteBufferStreamsTest.rep(10, ByteBufferStreamsTest.l(23L)), ByteBufferStreamsTest.rep(20, ByteBufferStreamsTest.l(32123L)), ByteBufferStreamsTest.rep(30, ByteBufferStreamsTest.l(7483848374L)), ByteBufferStreamsTest.rep(101, ByteBufferStreamsTest.l(0L))));
        this.send(ch);
        ch = ByteBufferStreamsTest.rep(REPEAT_COUNT, ByteBufferStreamsTest.b((byte)23));
        this.send(ch);
        ch = ByteBufferStreamsTest.rep(REPEAT_COUNT, ByteBufferStreamsTest.s((short)43));
        this.send(ch);
        ch = ByteBufferStreamsTest.rep(REPEAT_COUNT, ByteBufferStreamsTest.i(11));
        this.send(ch);
        ch = ByteBufferStreamsTest.rep(REPEAT_COUNT, ByteBufferStreamsTest.l(2378878L));
        this.send(ch);
        ch = ByteBufferStreamsTest.rep(REPEAT_COUNT, ByteBufferStreamsTest.z(true));
        this.send(ch);
        ch = ByteBufferStreamsTest.rep(REPEAT_COUNT, ByteBufferStreamsTest.z(false));
        this.send(ch);
        ch = ByteBufferStreamsTest.rep(REPEAT_COUNT, ByteBufferStreamsTest.comp(ByteBufferStreamsTest.la(913, 1234567879123456789L), ByteBufferStreamsTest.ba(5531, (byte)39), ByteBufferStreamsTest.ca(5792, 'A'), ByteBufferStreamsTest.sa(3324, (short)27456), ByteBufferStreamsTest.ia(479, 356789), ByteBufferStreamsTest.la(4123, 49384892348923489L), ByteBufferStreamsTest.fa(5321, 12.7f), ByteBufferStreamsTest.da(2435, 45921.45891)));
        this.send(ch);
        Future<Integer> future = this.send(new PoisonChecker());
        future.get(10L, TimeUnit.SECONDS);
        MemoryManager alloc = MemoryManager.DEFAULT_MEMORY_MANAGER;
        byte[] testdata = new byte[500];
        for (int ctr = 0; ctr < testdata.length; ++ctr) {
            testdata[ctr] = (byte)(ctr + 10 & 0xFF);
        }
        BufferedInput source = new BufferedInput(){

            protected void onOpenInputSource() throws IOException {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            protected void onCloseInputSource() throws IOException {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        AbstractStreamReader reader = new AbstractStreamReader(null, (Input)source){

            public GrizzlyFuture<Integer> notifyCondition(Condition condition, CompletionHandler<Integer> completionHandler) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        Buffer buffer1 = alloc.allocate(125);
        buffer1.put(testdata, 0, 125);
        Buffer buffer2 = alloc.allocate(125);
        buffer2.put(testdata, 125, 125);
        Buffer buffer3 = alloc.allocate(125);
        buffer3.put(testdata, 250, 125);
        Buffer buffer4 = alloc.allocate(125);
        buffer4.put(testdata, 375, 125);
        source.append(buffer1.flip());
        source.append(buffer2.flip());
        source.append(buffer3.flip());
        source.append(buffer4.flip());
        byte[] checkArray = new byte[500];
        try {
            reader.readByteArray(checkArray, 0, 500);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Data generate error", e);
        }
        Assert.assertTrue((boolean)Arrays.equals(checkArray, testdata));
    }

    @Override
    public void setUp() {
        this.setupServer();
        this.setupClient();
    }

    public void tearDown() {
        try {
            this.poisonFuture.get(20L, TimeUnit.SECONDS);
            this.clientWriter.close();
            this.clientconnection.close();
            this.servertransport.stop();
            this.clienttransport.stop();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Close", ex);
        }
    }

    public void setupServer() {
        this.servertransport = TCPNIOTransportBuilder.newInstance().build();
        this.servertransport.configureStandalone(true);
        try {
            TCPNIOServerConnection serverConnection = this.servertransport.bind(7778);
            this.servertransport.start();
            this.startEchoServerThread(this.servertransport, serverConnection);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Server start error", ex);
        }
    }

    private Future<Integer> send(Checker checker) throws IOException {
        this.checkerQueue.add(checker);
        checker.write(this.clientWriter);
        GrizzlyFuture result = this.clientWriter.flush();
        return result;
    }

    public void setupClient() {
        this.clienttransport = TCPNIOTransportBuilder.newInstance().build();
        try {
            this.clienttransport.start();
            this.clienttransport.configureBlocking(false);
            this.clienttransport.configureStandalone(true);
            GrizzlyFuture future = this.clienttransport.connect("localhost", 7778);
            this.clientconnection = (Connection)future.get(10L, TimeUnit.SECONDS);
            ByteBufferStreamsTest.assertTrue((this.clientconnection != null ? 1 : 0) != 0);
            this.clientconnection.configureStandalone(true);
            this.clientWriter = ((StandaloneProcessor)this.clientconnection.getProcessor()).getStreamWriter(this.clientconnection);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Client start error", ex);
        }
    }

    private void startEchoServerThread(final TCPNIOTransport transport, final TCPNIOServerConnection serverConnection) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!transport.isStopped()) {
                    try {
                        GrizzlyFuture acceptFuture = serverConnection.accept();
                        Connection connection = (Connection)acceptFuture.get(10L, TimeUnit.SECONDS);
                        Assert.assertTrue((boolean)acceptFuture.isDone());
                        connection.configureStandalone(true);
                        StreamReader reader = ((StandaloneProcessor)connection.getProcessor()).getStreamReader(connection);
                        try {
                            Checker checker;
                            while ((checker = (Checker)ByteBufferStreamsTest.this.checkerQueue.poll(30L, TimeUnit.SECONDS)) != null) {
                                if (checker instanceof PoisonChecker) {
                                    ByteBufferStreamsTest.this.poisonFuture.result((Object)Boolean.TRUE);
                                    return;
                                }
                                if (LOGGER.isLoggable(Level.FINEST)) {
                                    LOGGER.log(Level.FINEST, "reader.availableDataSize():{0},{1}", new Object[]{reader.available(), checker.byteSize()});
                                }
                                GrizzlyFuture f = reader.notifyAvailable((int)checker.byteSize());
                                try {
                                    f.get(10L, TimeUnit.SECONDS);
                                }
                                catch (Exception e) {
                                    ByteBufferStreamsTest.this.poisonFuture.failure((Throwable)new Exception("Exception waiting on checker: " + checker + " size: " + checker.byteSize(), e));
                                }
                                Assert.assertTrue((boolean)f.isDone());
                                checker.readAndCheck(reader);
                            }
                        }
                        catch (Throwable e) {
                            LOGGER.log(Level.WARNING, "Error working with accepted connection", e);
                        }
                        finally {
                            connection.close();
                        }
                    }
                    catch (Exception e) {
                        if (transport.isStopped()) continue;
                        LOGGER.log(Level.WARNING, "Error accepting connection", e);
                        Assert.assertTrue((String)"Error accepting connection", (boolean)false);
                    }
                }
            }
        }).start();
    }

    static class PoisonChecker
    extends CheckerBase {
        private byte data = 1;

        PoisonChecker() {
        }

        @Override
        public String value() {
            return "Poison";
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            writer.writeByte(this.data);
        }

        @Override
        public void readAndCheck(StreamReader reader) {
        }

        @Override
        public long byteSize() {
            return 1L;
        }
    }

    static class DoubleArrayChecker
    extends CheckerBase {
        private double data;
        private int size;

        @Override
        public String value() {
            return this.size + ":" + this.data;
        }

        public DoubleArrayChecker(int size, double arg) {
            this.size = size;
            this.data = arg;
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            double[] value = new double[this.size];
            for (int ctr = 0; ctr < this.size; ++ctr) {
                value[ctr] = this.data;
            }
            writer.writeDoubleArray(value);
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            this.rmsg();
            double[] value = new double[this.size];
            reader.readDoubleArray(value);
            try {
                for (int ctr = 0; ctr < this.size; ++ctr) {
                    Assert.assertEquals((Object)this.data, (Object)value[ctr]);
                }
            }
            catch (Error err) {
                this.rerrMsg(this.size, err);
                throw err;
            }
            catch (RuntimeException exc) {
                this.rerrMsg(this.size, exc);
                throw exc;
            }
        }

        @Override
        public long byteSize() {
            return 8 * this.size;
        }
    }

    static class FloatArrayChecker
    extends CheckerBase {
        private float data;
        private int size;

        @Override
        public String value() {
            return this.size + ":" + this.data;
        }

        public FloatArrayChecker(int size, float arg) {
            this.size = size;
            this.data = arg;
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            float[] value = new float[this.size];
            for (int ctr = 0; ctr < this.size; ++ctr) {
                value[ctr] = this.data;
            }
            writer.writeFloatArray(value);
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            this.rmsg();
            float[] value = new float[this.size];
            reader.readFloatArray(value);
            try {
                for (int ctr = 0; ctr < this.size; ++ctr) {
                    Assert.assertEquals((Object)Float.valueOf(this.data), (Object)Float.valueOf(value[ctr]));
                }
            }
            catch (Error err) {
                this.rerrMsg(this.size, err);
                throw err;
            }
            catch (RuntimeException exc) {
                this.rerrMsg(this.size, exc);
                throw exc;
            }
        }

        @Override
        public long byteSize() {
            return 4 * this.size;
        }
    }

    static class LongArrayChecker
    extends CheckerBase {
        private long data;
        private int size;

        @Override
        public String value() {
            return this.size + ":" + this.data;
        }

        public LongArrayChecker(int size, long arg) {
            this.size = size;
            this.data = arg;
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            long[] value = new long[this.size];
            try {
                for (int ctr = 0; ctr < this.size; ++ctr) {
                    value[ctr] = this.data;
                }
                writer.writeLongArray(value);
            }
            catch (Error err) {
                this.werrMsg(this.size, err);
                throw err;
            }
            catch (RuntimeException exc) {
                this.werrMsg(this.size, exc);
                throw exc;
            }
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            int ctr;
            this.rmsg();
            long[] value = new long[this.size];
            reader.readLongArray(value);
            try {
                for (ctr = 0; ctr < this.size; ++ctr) {
                    Assert.assertEquals((long)this.data, (long)value[ctr]);
                }
            }
            catch (Error err) {
                this.rerrMsg(ctr, err);
                throw err;
            }
            catch (RuntimeException exc) {
                this.rerrMsg(ctr, exc);
                throw exc;
            }
        }

        @Override
        public long byteSize() {
            return 8 * this.size;
        }
    }

    static class IntArrayChecker
    extends CheckerBase {
        private int data;
        private int size;

        @Override
        public String value() {
            return this.size + ":" + this.data;
        }

        public IntArrayChecker(int size, int arg) {
            this.size = size;
            this.data = arg;
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            int[] value = new int[this.size];
            for (int ctr = 0; ctr < this.size; ++ctr) {
                value[ctr] = this.data;
            }
            writer.writeIntArray(value);
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            this.rmsg();
            int[] value = new int[this.size];
            reader.readIntArray(value);
            try {
                for (int ctr = 0; ctr < this.size; ++ctr) {
                    Assert.assertEquals((int)this.data, (int)value[ctr]);
                }
            }
            catch (Error err) {
                this.rerrMsg(this.size, err);
                throw err;
            }
            catch (RuntimeException exc) {
                this.rerrMsg(this.size, exc);
                throw exc;
            }
        }

        @Override
        public long byteSize() {
            return 4 * this.size;
        }
    }

    static class ShortArrayChecker
    extends CheckerBase {
        private short data;
        private int size;

        @Override
        public String value() {
            return this.size + ":" + this.data;
        }

        public ShortArrayChecker(int size, short arg) {
            this.size = size;
            this.data = arg;
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            short[] value = new short[this.size];
            for (int ctr = 0; ctr < this.size; ++ctr) {
                value[ctr] = this.data;
            }
            writer.writeShortArray(value);
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            this.rmsg();
            short[] value = new short[this.size];
            reader.readShortArray(value);
            try {
                for (int ctr = 0; ctr < this.size; ++ctr) {
                    Assert.assertEquals((short)this.data, (short)value[ctr]);
                }
            }
            catch (Error err) {
                this.rerrMsg(this.size, err);
                throw err;
            }
            catch (RuntimeException exc) {
                this.rerrMsg(this.size, exc);
                throw exc;
            }
        }

        @Override
        public long byteSize() {
            return 2 * this.size;
        }
    }

    static class CharArrayChecker
    extends CheckerBase {
        private char data;
        private int size;

        @Override
        public String value() {
            return this.size + ":" + this.data;
        }

        public CharArrayChecker(int size, char arg) {
            this.size = size;
            this.data = arg;
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            char[] value = new char[this.size];
            for (int ctr = 0; ctr < this.size; ++ctr) {
                value[ctr] = this.data;
            }
            writer.writeCharArray(value);
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            this.rmsg();
            char[] value = new char[this.size];
            reader.readCharArray(value);
            try {
                for (int ctr = 0; ctr < this.size; ++ctr) {
                    Assert.assertEquals((char)this.data, (char)value[ctr]);
                }
            }
            catch (Error err) {
                this.rerrMsg(this.size, err);
                throw err;
            }
            catch (RuntimeException exc) {
                this.rerrMsg(this.size, exc);
                throw exc;
            }
        }

        @Override
        public long byteSize() {
            return 2 * this.size;
        }
    }

    static class ByteArrayChecker
    extends CheckerBase {
        private byte data;
        private int size;

        @Override
        public String value() {
            return this.size + ":" + this.data;
        }

        public ByteArrayChecker(int size, byte arg) {
            this.size = size;
            this.data = arg;
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            byte[] value = new byte[this.size];
            for (int ctr = 0; ctr < this.size; ++ctr) {
                value[ctr] = this.data;
            }
            writer.writeByteArray(value);
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            this.rmsg();
            byte[] value = new byte[this.size];
            reader.readByteArray(value);
            try {
                for (int ctr = 0; ctr < this.size; ++ctr) {
                    Assert.assertEquals((byte)this.data, (byte)value[ctr]);
                }
            }
            catch (Error err) {
                this.rerrMsg(this.size, err);
                throw err;
            }
            catch (RuntimeException exc) {
                this.rerrMsg(this.size, exc);
                throw exc;
            }
        }

        @Override
        public long byteSize() {
            return this.size;
        }
    }

    static class BooleanArrayChecker
    extends CheckerBase {
        private boolean data;
        private int size;

        @Override
        public String value() {
            return this.size + ":" + this.data;
        }

        public BooleanArrayChecker(int size, boolean arg) {
            this.size = size;
            this.data = arg;
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            boolean[] value = new boolean[this.size];
            for (int ctr = 0; ctr < this.size; ++ctr) {
                value[ctr] = this.data;
            }
            writer.writeBooleanArray(value);
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            this.rmsg();
            boolean[] value = new boolean[this.size];
            reader.readBooleanArray(value);
            for (int ctr = 0; ctr < this.size; ++ctr) {
                Assert.assertTrue((value[ctr] == this.data ? 1 : 0) != 0);
            }
        }

        @Override
        public long byteSize() {
            return this.size;
        }
    }

    static class DoubleChecker
    extends CheckerBase {
        private double data;

        @Override
        public String value() {
            return "" + this.data;
        }

        public DoubleChecker(double arg) {
            this.data = arg;
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            writer.writeDouble(this.data);
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            this.rmsg();
            double value = reader.readDouble();
            Assert.assertEquals((Object)this.data, (Object)value);
        }

        @Override
        public long byteSize() {
            return 8L;
        }
    }

    static class FloatChecker
    extends CheckerBase {
        private float data;

        @Override
        public String value() {
            return "" + this.data;
        }

        public FloatChecker(float arg) {
            this.data = arg;
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            writer.writeFloat(this.data);
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            this.rmsg();
            float value = reader.readFloat();
            Assert.assertEquals((Object)Float.valueOf(this.data), (Object)Float.valueOf(value));
        }

        @Override
        public long byteSize() {
            return 4L;
        }
    }

    static class LongChecker
    extends CheckerBase {
        private long data;

        @Override
        public String value() {
            return "" + this.data;
        }

        public LongChecker(long arg) {
            this.data = arg;
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            writer.writeLong(this.data);
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            this.rmsg();
            long value = reader.readLong();
            Assert.assertEquals((long)this.data, (long)value);
        }

        @Override
        public long byteSize() {
            return 8L;
        }
    }

    static class IntChecker
    extends CheckerBase {
        private int data;

        @Override
        public String value() {
            return "" + this.data;
        }

        public IntChecker(int arg) {
            this.data = arg;
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            writer.writeInt(this.data);
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            this.rmsg();
            int value = reader.readInt();
            Assert.assertEquals((int)this.data, (int)value);
        }

        @Override
        public long byteSize() {
            return 4L;
        }
    }

    static class ShortChecker
    extends CheckerBase {
        private short data;

        @Override
        public String value() {
            return "" + this.data;
        }

        public ShortChecker(short arg) {
            this.data = arg;
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            writer.writeShort(this.data);
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            this.rmsg();
            short value = reader.readShort();
            Assert.assertEquals((short)this.data, (short)value);
        }

        @Override
        public long byteSize() {
            return 2L;
        }
    }

    static class CharChecker
    extends CheckerBase {
        private char data;

        @Override
        public String value() {
            return "" + this.data;
        }

        public CharChecker(char arg) {
            this.data = arg;
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            writer.writeChar(this.data);
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            this.rmsg();
            char value = reader.readChar();
            Assert.assertEquals((char)this.data, (char)value);
        }

        @Override
        public long byteSize() {
            return 2L;
        }
    }

    static class BooleanChecker
    extends CheckerBase {
        private boolean data;

        @Override
        public String value() {
            return "" + this.data;
        }

        public BooleanChecker(boolean arg) {
            this.data = arg;
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            writer.writeBoolean(this.data);
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            this.rmsg();
            boolean value = reader.readBoolean();
            Assert.assertTrue((value == this.data ? 1 : 0) != 0);
        }

        @Override
        public long byteSize() {
            return 1L;
        }
    }

    static class ByteChecker
    extends CheckerBase {
        private byte data;

        @Override
        public String value() {
            return "" + this.data;
        }

        public ByteChecker(byte arg) {
            this.data = arg;
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            writer.writeByte(this.data);
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            this.rmsg();
            byte value = reader.readByte();
            Assert.assertEquals((byte)this.data, (byte)value);
        }

        @Override
        public long byteSize() {
            return 1L;
        }
    }

    static class RepeatedChecker
    extends CheckerBase {
        private int count;
        private Checker checker;

        @Override
        public String value() {
            return this.count + " " + this.checker.toString();
        }

        public RepeatedChecker(int count, Checker checker) {
            this.count = count;
            this.checker = checker;
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            int ctr = 0;
            try {
                for (ctr = 0; ctr < this.count; ++ctr) {
                    this.checker.write(writer);
                }
            }
            catch (Error err) {
                this.werrMsg(ctr, err);
                throw err;
            }
            catch (RuntimeException exc) {
                this.werrMsg(ctr, exc);
                throw exc;
            }
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            this.rmsg();
            int ctr = 0;
            try {
                for (ctr = 0; ctr < this.count; ++ctr) {
                    this.checker.readAndCheck(reader);
                }
            }
            catch (Error err) {
                this.rerrMsg(ctr, err);
                throw err;
            }
            catch (RuntimeException exc) {
                this.rerrMsg(ctr, exc);
                throw exc;
            }
        }

        @Override
        public long operations() {
            return (long)this.count * this.checker.operations();
        }

        @Override
        public long byteSize() {
            return (long)this.count * this.checker.byteSize();
        }
    }

    static class CompositeChecker
    extends CheckerBase {
        private List<Checker> checkers = new ArrayList<Checker>();

        @Override
        public String value() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Checker ch : this.checkers) {
                if (first) {
                    first = false;
                } else {
                    sb.append(' ');
                }
                sb.append(ch.toString());
            }
            return sb.toString();
        }

        public CompositeChecker(Checker ... args) {
            this.checkers.addAll(Arrays.asList(args));
        }

        public void add(Checker ch) {
            this.checkers.add(ch);
        }

        @Override
        public void write(StreamWriter writer) throws IOException {
            this.wmsg();
            Checker ch = null;
            try {
                Iterator<Checker> i$ = this.checkers.iterator();
                while (i$.hasNext()) {
                    Checker checker;
                    ch = checker = i$.next();
                    ch.write(writer);
                }
            }
            catch (Error err) {
                this.werrMsg(ch, err);
                throw err;
            }
            catch (RuntimeException exc) {
                this.werrMsg(ch, exc);
                throw exc;
            }
        }

        @Override
        public void readAndCheck(StreamReader reader) throws IOException {
            this.rmsg();
            Checker ch = null;
            try {
                Iterator<Checker> i$ = this.checkers.iterator();
                while (i$.hasNext()) {
                    Checker checker;
                    ch = checker = i$.next();
                    ch.readAndCheck(reader);
                }
            }
            catch (Error err) {
                this.rerrMsg(ch, err);
                throw err;
            }
            catch (RuntimeException exc) {
                this.rerrMsg(ch, exc);
                throw exc;
            }
        }

        @Override
        public long operations() {
            long sum = 0L;
            for (Checker ch : this.checkers) {
                sum += ch.operations();
            }
            return sum;
        }

        @Override
        public long byteSize() {
            long sum = 0L;
            for (Checker ch : this.checkers) {
                sum += ch.byteSize();
            }
            return sum;
        }
    }

    static abstract class CheckerBase
    implements Checker {
        private String name;

        public CheckerBase() {
            String className = this.getClass().getName();
            int index = className.indexOf(36);
            this.name = className.substring(index + 1);
        }

        public abstract String value();

        public String toString() {
            return this.name + "[" + this.value() + "]";
        }

        protected void werrMsg(Object obj, Throwable thr) {
            LOGGER.log(Level.SEVERE, "###Checker({0}).write: Caught {1} at parameter {2}", new Object[]{this.toString(), thr, obj});
        }

        protected void rerrMsg(Object obj, Throwable thr) {
            LOGGER.log(Level.SEVERE, "###Checker({0}).readAndCheck: Caught {1} at parameter {2}", new Object[]{this.toString(), thr, obj});
        }

        public void wmsg() {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.SEVERE, "Write:{0}", this.toString());
            }
        }

        public void rmsg() {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.SEVERE, "ReadAndCheck:{0}", this.toString());
            }
        }

        @Override
        public long operations() {
            return 1L;
        }
    }

    static interface Checker {
        public void write(StreamWriter var1) throws IOException;

        public void readAndCheck(StreamReader var1) throws IOException;

        public long operations();

        public long byteSize();
    }
}

