/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.GrizzlyTestCase;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.ByteBufferArray;
import org.glassfish.grizzly.memory.ByteBufferManager;
import org.glassfish.grizzly.memory.ByteBufferWrapper;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;

public class CompositeBufferTest
extends GrizzlyTestCase {
    public void testSingleBuffer() {
        ByteBufferManager manager = new ByteBufferManager();
        ByteBufferWrapper buffer = manager.allocate(29);
        CompositeBuffer compositeBuffer = this.createCompositeBuffer(new Buffer[]{buffer});
        byte v1 = 127;
        char v2 = 'c';
        short v3 = -1;
        int v4 = Integer.MIN_VALUE;
        long v5 = Long.MAX_VALUE;
        float v6 = 0.3f;
        double v7 = -0.5;
        compositeBuffer.put(v1);
        compositeBuffer.putChar(v2);
        compositeBuffer.putShort(v3);
        compositeBuffer.putInt(v4);
        compositeBuffer.putLong(v5);
        compositeBuffer.putFloat(v6);
        compositeBuffer.putDouble(v7);
        compositeBuffer.flip();
        CompositeBufferTest.assertEquals((byte)v1, (byte)compositeBuffer.get());
        CompositeBufferTest.assertEquals((char)v2, (char)compositeBuffer.getChar());
        CompositeBufferTest.assertEquals((short)v3, (short)compositeBuffer.getShort());
        CompositeBufferTest.assertEquals((int)v4, (int)compositeBuffer.getInt());
        CompositeBufferTest.assertEquals((long)v5, (long)compositeBuffer.getLong());
        CompositeBufferTest.assertEquals((Object)Float.valueOf(v6), (Object)Float.valueOf(compositeBuffer.getFloat()));
        CompositeBufferTest.assertEquals((Object)v7, (Object)compositeBuffer.getDouble());
    }

    public void testSingleBufferIndexedAccess() {
        ByteBufferManager manager = new ByteBufferManager();
        ByteBufferWrapper buffer = manager.allocate(29);
        CompositeBuffer compositeBuffer = this.createCompositeBuffer(new Buffer[]{buffer});
        byte v1 = 127;
        char v2 = 'c';
        short v3 = -1;
        int v4 = Integer.MIN_VALUE;
        long v5 = Long.MAX_VALUE;
        float v6 = 0.3f;
        double v7 = -0.5;
        compositeBuffer.put(0, v1);
        compositeBuffer.putChar(1, v2);
        compositeBuffer.putShort(3, v3);
        compositeBuffer.putInt(5, v4);
        compositeBuffer.putLong(9, v5);
        compositeBuffer.putFloat(17, v6);
        compositeBuffer.putDouble(21, v7);
        CompositeBufferTest.assertEquals((byte)v1, (byte)compositeBuffer.get(0));
        CompositeBufferTest.assertEquals((char)v2, (char)compositeBuffer.getChar(1));
        CompositeBufferTest.assertEquals((short)v3, (short)compositeBuffer.getShort(3));
        CompositeBufferTest.assertEquals((int)v4, (int)compositeBuffer.getInt(5));
        CompositeBufferTest.assertEquals((long)v5, (long)compositeBuffer.getLong(9));
        CompositeBufferTest.assertEquals((Object)Float.valueOf(v6), (Object)Float.valueOf(compositeBuffer.getFloat(17)));
        CompositeBufferTest.assertEquals((Object)v7, (Object)compositeBuffer.getDouble(21));
    }

    public void testBytes() {
        this.doTest(new Byte[]{(byte)-1, (byte)0, (byte)127, (byte)-127}, 4, 1, new Put<Byte>(){

            @Override
            public void put(CompositeBuffer buffer, Byte value) {
                buffer.put(value.byteValue());
            }
        }, new Get<Byte>(){

            @Override
            public Byte get(CompositeBuffer buffer) {
                return buffer.get();
            }
        });
    }

    public void testBytesIndexed() {
        this.doTestIndexed(new Byte[]{(byte)-1, (byte)0, (byte)127, (byte)-127}, 4, 1, new Put<Byte>(){

            @Override
            public void putIndexed(CompositeBuffer buffer, int index, Byte value) {
                buffer.put(index, value.byteValue());
            }
        }, new Get<Byte>(){

            @Override
            public Byte getIndexed(CompositeBuffer buffer, int index) {
                return buffer.get(index);
            }
        }, 1);
    }

    public void testChars() {
        this.doTest(new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d')}, 3, 3, new Put<Character>(){

            @Override
            public void put(CompositeBuffer buffer, Character value) {
                buffer.putChar(value.charValue());
            }
        }, new Get<Character>(){

            @Override
            public Character get(CompositeBuffer buffer) {
                return Character.valueOf(buffer.getChar());
            }
        });
    }

    public void testCharsIndexed() {
        this.doTestIndexed(new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d')}, 3, 3, new Put<Character>(){

            @Override
            public void putIndexed(CompositeBuffer buffer, int index, Character value) {
                buffer.putChar(index, value.charValue());
            }
        }, new Get<Character>(){

            @Override
            public Character getIndexed(CompositeBuffer buffer, int index) {
                return Character.valueOf(buffer.getChar(index));
            }
        }, 2);
    }

    public void testShort() {
        this.doTest(new Short[]{(short)Short.MIN_VALUE, (short)-1}, 3, 3, new Put<Short>(){

            @Override
            public void put(CompositeBuffer buffer, Short value) {
                buffer.putShort(value.shortValue());
            }
        }, new Get<Short>(){

            @Override
            public Short get(CompositeBuffer buffer) {
                return buffer.getShort();
            }
        });
    }

    public void testShortIndexed() {
        this.doTestIndexed(new Short[]{(short)Short.MIN_VALUE, (short)-1}, 3, 3, new Put<Short>(){

            @Override
            public void putIndexed(CompositeBuffer buffer, int index, Short value) {
                buffer.putShort(index, value.shortValue());
            }
        }, new Get<Short>(){

            @Override
            public Short getIndexed(CompositeBuffer buffer, int index) {
                return buffer.getShort(index);
            }
        }, 2);
    }

    public void testInt() {
        this.doTest(new Integer[]{Integer.MIN_VALUE, -1, Integer.MAX_VALUE, 0}, 4, 5, new Put<Integer>(){

            @Override
            public void put(CompositeBuffer buffer, Integer value) {
                buffer.putInt(value.intValue());
            }
        }, new Get<Integer>(){

            @Override
            public Integer get(CompositeBuffer buffer) {
                return buffer.getInt();
            }
        });
    }

    public void testIntIndexed() {
        this.doTestIndexed(new Integer[]{Integer.MIN_VALUE, -1, Integer.MAX_VALUE, 0}, 4, 5, new Put<Integer>(){

            @Override
            public void putIndexed(CompositeBuffer buffer, int index, Integer value) {
                buffer.putInt(index, value.intValue());
            }
        }, new Get<Integer>(){

            @Override
            public Integer getIndexed(CompositeBuffer buffer, int index) {
                return buffer.getInt(index);
            }
        }, 4);
    }

    public void testLong() {
        this.doTest(new Long[]{Long.MIN_VALUE, -1L, Long.MAX_VALUE, 0L}, 4, 9, new Put<Long>(){

            @Override
            public void put(CompositeBuffer buffer, Long value) {
                buffer.putLong(value.longValue());
            }
        }, new Get<Long>(){

            @Override
            public Long get(CompositeBuffer buffer) {
                return buffer.getLong();
            }
        });
    }

    public void testLongIndexed() {
        this.doTestIndexed(new Long[]{Long.MIN_VALUE, -1L, Long.MAX_VALUE, 0L}, 4, 9, new Put<Long>(){

            @Override
            public void putIndexed(CompositeBuffer buffer, int index, Long value) {
                buffer.putLong(index, value.longValue());
            }
        }, new Get<Long>(){

            @Override
            public Long getIndexed(CompositeBuffer buffer, int index) {
                return buffer.getLong(index);
            }
        }, 8);
    }

    public void testFloat() {
        this.doTest(new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(-1.0f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(0.0f)}, 4, 5, new Put<Float>(){

            @Override
            public void put(CompositeBuffer buffer, Float value) {
                buffer.putFloat(value.floatValue());
            }
        }, new Get<Float>(){

            @Override
            public Float get(CompositeBuffer buffer) {
                return Float.valueOf(buffer.getFloat());
            }
        });
    }

    public void testFloatIndexed() {
        this.doTestIndexed(new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(-1.0f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(0.0f)}, 4, 5, new Put<Float>(){

            @Override
            public void putIndexed(CompositeBuffer buffer, int index, Float value) {
                buffer.putFloat(index, value.floatValue());
            }
        }, new Get<Float>(){

            @Override
            public Float getIndexed(CompositeBuffer buffer, int index) {
                return Float.valueOf(buffer.getFloat(index));
            }
        }, 4);
    }

    public void testDouble() {
        this.doTest(new Double[]{Double.MIN_VALUE, -1.0, Double.MAX_VALUE, 0.0}, 4, 9, new Put<Double>(){

            @Override
            public void put(CompositeBuffer buffer, Double value) {
                buffer.putDouble(value.doubleValue());
            }
        }, new Get<Double>(){

            @Override
            public Double get(CompositeBuffer buffer) {
                return buffer.getDouble();
            }
        });
    }

    public void testDoubleIndexed() {
        this.doTestIndexed(new Double[]{Double.MIN_VALUE, -1.0, Double.MAX_VALUE, 0.0}, 4, 9, new Put<Double>(){

            @Override
            public void putIndexed(CompositeBuffer buffer, int index, Double value) {
                buffer.putDouble(index, value.doubleValue());
            }
        }, new Get<Double>(){

            @Override
            public Double getIndexed(CompositeBuffer buffer, int index) {
                return buffer.getDouble(index);
            }
        }, 8);
    }

    public void testBuffers() {
        ByteBufferManager manager = new ByteBufferManager();
        Buffer sampleBuffer = Buffers.wrap((MemoryManager)manager, (byte[])new byte[]{-1, 0, 1, 1, 2, 3, 4});
        ByteBufferWrapper b1 = manager.allocate(3);
        ByteBufferWrapper b2 = manager.allocate(4);
        CompositeBuffer compositeBuffer = this.createCompositeBuffer(new Buffer[]{b1, b2});
        compositeBuffer.put(sampleBuffer);
        compositeBuffer.flip();
        sampleBuffer.flip();
        while (sampleBuffer.hasRemaining()) {
            CompositeBufferTest.assertEquals((byte)sampleBuffer.get(), (byte)compositeBuffer.get());
        }
    }

    public void testEmptyBufferPrepend() {
        ByteBufferManager manager = new ByteBufferManager();
        Buffer buffer1 = Buffers.wrap((MemoryManager)manager, (String)"1234");
        buffer1.position(3);
        ByteBufferWrapper buffer2 = manager.allocate(0);
        CompositeBuffer compositeBuffer = this.createCompositeBuffer(buffer1);
        CompositeBufferTest.assertEquals((char)'4', (char)((char)compositeBuffer.get(0)));
        Buffer resultBuffer = Buffers.appendBuffers((MemoryManager)manager, (Buffer)buffer2, (Buffer)compositeBuffer);
        CompositeBufferTest.assertEquals((String)resultBuffer.toStringContent(), (String)"4");
    }

    public void testSplit() {
        this.doTestSplit(100);
    }

    public void testToByteBufferArray() {
        ByteBufferManager manager = new ByteBufferManager();
        byte[] bytes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ArrayList<ByteBufferWrapper> bufferList = new ArrayList<ByteBufferWrapper>();
        for (byte b : bytes) {
            ByteBufferWrapper buffer = manager.allocate(1);
            buffer.put(0, b);
            bufferList.add(buffer);
        }
        Buffer[] buffers = bufferList.toArray(new Buffer[0]);
        CompositeBuffer composite = CompositeBuffer.newBuffer((MemoryManager)manager, (Buffer[])buffers);
        for (int i = 0; i < bytes.length; ++i) {
            for (int j = i; j < bytes.length; ++j) {
                ByteBufferArray bbArray = composite.toByteBufferArray(i, j);
                int bytesChecked = 0;
                ByteBuffer[] bbs = (ByteBuffer[])bbArray.getArray();
                for (int k = 0; k < bbArray.size(); ++k) {
                    ByteBuffer bb = bbs[k];
                    while (bb.hasRemaining()) {
                        byte got = bb.get();
                        CompositeBufferTest.assertEquals((String)("Testcase [pos=" + i + " lim=" + j + " bytenumber=" + bytesChecked + "]"), (byte)bytes[i + bytesChecked], (byte)got);
                        ++bytesChecked;
                    }
                }
                CompositeBufferTest.assertEquals((int)(j - i), (int)bytesChecked);
                bbArray.restore();
            }
        }
    }

    public void testToByteBuffer() {
        ByteBufferManager manager = new ByteBufferManager();
        byte[] bytes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ArrayList<ByteBufferWrapper> bufferList = new ArrayList<ByteBufferWrapper>();
        for (byte b : bytes) {
            ByteBufferWrapper buffer = manager.allocate(1);
            buffer.put(0, b);
            bufferList.add(buffer);
        }
        Buffer[] buffers = bufferList.toArray(new Buffer[0]);
        CompositeBuffer composite = CompositeBuffer.newBuffer((MemoryManager)manager, (Buffer[])buffers);
        for (int i = 0; i < bytes.length; ++i) {
            for (int j = i; j < bytes.length; ++j) {
                ByteBuffer bb = composite.toByteBuffer(i, j);
                int bytesChecked = 0;
                while (bb.hasRemaining()) {
                    byte got = bb.get();
                    CompositeBufferTest.assertEquals((String)("Testcase [pos=" + i + " lim=" + j + " bytenumber=" + bytesChecked + "]"), (byte)bytes[i + bytesChecked], (byte)got);
                    ++bytesChecked;
                }
                CompositeBufferTest.assertEquals((int)(j - i), (int)bytesChecked);
            }
        }
    }

    public void testToStringContent() {
        ByteBufferManager manager = new ByteBufferManager();
        CompositeBuffer composite = CompositeBuffer.newBuffer((MemoryManager)manager, (Buffer[])new Buffer[]{Buffers.wrap((MemoryManager)manager, (String)"hello"), Buffers.wrap((MemoryManager)manager, (String)" world")});
        CompositeBufferTest.assertEquals((String)"hello world", (String)composite.toStringContent());
    }

    public void testToStringContent2() {
        ByteBufferManager manager = new ByteBufferManager();
        Charset utf16 = Charset.forName("UTF-16");
        String msg = "\u043f\u0440\u0438\u0432\u0435\u0442";
        Buffer msgBuffer = Buffers.wrap((MemoryManager)manager, (String)"\u043f\u0440\u0438\u0432\u0435\u0442", (Charset)utf16);
        Buffer b1 = msgBuffer.duplicate();
        Buffer b2 = b1.split(3);
        CompositeBuffer composite = CompositeBuffer.newBuffer((MemoryManager)manager, (Buffer[])new Buffer[]{b1, b2});
        CompositeBufferTest.assertTrue((boolean)composite.equals(msgBuffer));
        CompositeBufferTest.assertEquals((String)"\u043f\u0440\u0438\u0432\u0435\u0442", (String)composite.toStringContent(utf16));
    }

    public void testBulk() {
        ByteBufferManager manager = new ByteBufferManager();
        Charset ascii = Charset.forName("ASCII");
        CompositeBuffer composite = CompositeBuffer.newBuffer((MemoryManager)manager, (Buffer[])new Buffer[]{Buffers.wrap((MemoryManager)manager, (String)"hello", (Charset)ascii), Buffers.wrap((MemoryManager)manager, (String)" world", (Charset)ascii)});
        composite.bulk(new CompositeBuffer.BulkOperation(){

            public boolean processByte(byte value, CompositeBuffer.Setter setter) {
                setter.set((byte)Character.toUpperCase(value));
                return false;
            }
        });
        CompositeBufferTest.assertEquals((String)"HELLO WORLD", (String)composite.toStringContent(ascii));
    }

    private <E> void doTest(E[] testData, int buffersNum, int bufferSize, Put<E> put, Get<E> get) {
        int i;
        ByteBufferManager manager = new ByteBufferManager();
        Buffer[] buffers = new Buffer[buffersNum];
        for (int i2 = 0; i2 < buffers.length; ++i2) {
            buffers[i2] = manager.allocate(bufferSize);
        }
        CompositeBuffer compositeBuffer = this.createCompositeBuffer(buffers);
        for (i = 0; i < testData.length; ++i) {
            put.put(compositeBuffer, testData[i]);
        }
        compositeBuffer.flip();
        for (i = 0; i < testData.length; ++i) {
            CompositeBufferTest.assertEquals(testData[i], get.get(compositeBuffer));
        }
    }

    private <E> void doTestIndexed(E[] testData, int buffersNum, int bufferSize, Put<E> put, Get<E> get, int eSizeInBytes) {
        int i;
        ByteBufferManager manager = new ByteBufferManager();
        Buffer[] buffers = new Buffer[buffersNum];
        for (int i2 = 0; i2 < buffers.length; ++i2) {
            buffers[i2] = manager.allocate(bufferSize);
        }
        CompositeBuffer compositeBuffer = this.createCompositeBuffer(buffers);
        for (i = 0; i < testData.length; ++i) {
            put.putIndexed(compositeBuffer, i * eSizeInBytes, testData[i]);
        }
        for (i = 0; i < testData.length; ++i) {
            CompositeBufferTest.assertEquals(testData[i], get.getIndexed(compositeBuffer, i * eSizeInBytes));
        }
    }

    private void doTestSplit(int size) {
        ByteBufferManager manager = new ByteBufferManager();
        for (int i = 1; i <= size; ++i) {
            int j;
            int num = size / i;
            int remainder = size - num * i;
            try {
                for (j = 1; j <= size; ++j) {
                    Buffer[] buffers = new Buffer[num];
                    for (int k = 0; k < buffers.length; ++k) {
                        buffers[k] = manager.allocate(i);
                    }
                    if (remainder > 0) {
                        buffers = Arrays.copyOf(buffers, num + 1);
                        buffers[num] = manager.allocate(remainder);
                    }
                    CompositeBuffer compositeBuffer = this.createCompositeBuffer(buffers);
                    for (int k = 0; k < compositeBuffer.remaining(); ++k) {
                        compositeBuffer.put(k, (byte)(k % 127));
                    }
                    CompositeBuffer slice1 = compositeBuffer;
                    Buffer slice2 = slice1.split(j);
                    CompositeBufferTest.assertEquals((String)"Slice1 unexpected length", (int)j, (int)slice1.remaining());
                    CompositeBufferTest.assertEquals((String)"Slice2  unexpected length", (int)(size - j), (int)slice2.remaining());
                }
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException("Exception happened. size=" + size + " chunkSize=" + i + " splitPos=" + j, e);
            }
        }
    }

    private CompositeBuffer createCompositeBuffer(Buffer ... buffers) {
        return CompositeBuffer.newBuffer((MemoryManager)MemoryManager.DEFAULT_MEMORY_MANAGER, (Buffer[])buffers);
    }

    private static class Get<E> {
        private Get() {
        }

        public E get(CompositeBuffer buffer) {
            return null;
        }

        public E getIndexed(CompositeBuffer buffer, int index) {
            return null;
        }
    }

    private static class Put<E> {
        private Put() {
        }

        public void put(CompositeBuffer buffer, E value) {
        }

        public void putIndexed(CompositeBuffer buffer, int index, E value) {
        }
    }
}

