/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.utils.DataStructures;
import org.glassfish.grizzly.utils.EchoFilter;
import org.glassfish.grizzly.utils.StringEncoder;
import org.glassfish.grizzly.utils.StringFilter;

public class FilterChainReadTest
extends TestCase {
    public static int PORT = 7785;
    private static final Logger logger = Grizzly.logger(FilterChainReadTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBlockingRead() throws Exception {
        final String[] clientMsgs = new String[]{"Hello", "from", "client"};
        Connection connection = null;
        int messageNum = 3;
        final BlockingQueue intermResultQueue = DataStructures.getLTQInstance(String.class);
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new StringFilter());
        filterChainBuilder.add((Filter)new BaseFilter(){

            public NextAction handleRead(FilterChainContext ctx) throws IOException {
                String message = (String)ctx.getMessage();
                logger.log(Level.INFO, "First chunk come: {0}", message);
                intermResultQueue.add(message);
                Connection connection = ctx.getConnection();
                connection.setReadTimeout(10L, TimeUnit.SECONDS);
                for (int i = 0; i < clientMsgs.length - 1; ++i) {
                    ReadResult rr = ctx.read();
                    String blckMsg = (String)rr.getMessage();
                    rr.recycle();
                    logger.log(Level.INFO, "Blocking chunk come: {0}", blckMsg);
                    intermResultQueue.add(blckMsg);
                    message = message + blckMsg;
                }
                ctx.setMessage((Object)message);
                return ctx.getInvokeAction();
            }
        });
        filterChainBuilder.add((Filter)new EchoFilter());
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(PORT);
            transport.start();
            final BlockingQueue resultQueue = DataStructures.getLTQInstance(String.class);
            GrizzlyFuture future = transport.connect("localhost", PORT);
            connection = (Connection)future.get(10L, TimeUnit.SECONDS);
            FilterChainReadTest.assertTrue((connection != null ? 1 : 0) != 0);
            FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
            clientFilterChainBuilder.add((Filter)new TransportFilter());
            clientFilterChainBuilder.add((Filter)new StringFilter());
            clientFilterChainBuilder.add((Filter)new BaseFilter(){

                public NextAction handleRead(FilterChainContext ctx) throws IOException {
                    resultQueue.add((String)ctx.getMessage());
                    return ctx.getStopAction();
                }
            });
            FilterChain clientFilterChain = clientFilterChainBuilder.build();
            connection.setProcessor((Processor)clientFilterChain);
            for (int i = 0; i < messageNum; ++i) {
                String clientMessage = "";
                for (int j = 0; j < clientMsgs.length; ++j) {
                    String msg = clientMsgs[j] + "-" + i;
                    GrizzlyFuture writeFuture = connection.write((Object)msg);
                    FilterChainReadTest.assertTrue((String)("Write timeout loop: " + i), (writeFuture.get(10L, TimeUnit.SECONDS) != null ? 1 : 0) != 0);
                    String srvInterm = (String)intermResultQueue.poll(10L, TimeUnit.SECONDS);
                    FilterChainReadTest.assertEquals((String)("Unexpected interm. response (" + i + ", " + j + ")"), (String)msg, (String)srvInterm);
                    clientMessage = clientMessage + msg;
                }
                String message = (String)resultQueue.poll(10L, TimeUnit.SECONDS);
                FilterChainReadTest.assertEquals((String)("Unexpected response (" + i + ")"), (String)clientMessage, (String)message);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBlockingReadWithRemainder() throws Exception {
        final String[] clientMsgs = new String[]{"Hello", "from", "client"};
        Connection connection = null;
        int messageNum = 3;
        final BlockingQueue intermResultQueue = DataStructures.getLTQInstance(String.class);
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new StringFilter());
        filterChainBuilder.add((Filter)new BaseFilter(){

            public NextAction handleRead(FilterChainContext ctx) throws IOException {
                String message = (String)ctx.getMessage();
                logger.log(Level.INFO, "First chunk come: {0}", message);
                intermResultQueue.add(message);
                Connection connection = ctx.getConnection();
                connection.setReadTimeout(10L, TimeUnit.SECONDS);
                for (int i = 0; i < clientMsgs.length - 1; ++i) {
                    ReadResult rr = ctx.read();
                    String blckMsg = (String)rr.getMessage();
                    rr.recycle();
                    logger.log(Level.INFO, "Blocking chunk come: {0}", blckMsg);
                    intermResultQueue.add(blckMsg);
                    message = message + blckMsg;
                }
                ctx.setMessage((Object)message);
                return ctx.getInvokeAction();
            }
        });
        filterChainBuilder.add((Filter)new EchoFilter());
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(PORT);
            transport.start();
            final BlockingQueue resultQueue = DataStructures.getLTQInstance(String.class);
            GrizzlyFuture future = transport.connect("localhost", PORT);
            connection = (Connection)future.get(10L, TimeUnit.SECONDS);
            FilterChainReadTest.assertTrue((connection != null ? 1 : 0) != 0);
            FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
            clientFilterChainBuilder.add((Filter)new TransportFilter());
            clientFilterChainBuilder.add((Filter)new StringFilter());
            clientFilterChainBuilder.add((Filter)new BaseFilter(){

                public NextAction handleRead(FilterChainContext ctx) throws IOException {
                    resultQueue.add((String)ctx.getMessage());
                    return ctx.getStopAction();
                }
            });
            FilterChain clientFilterChain = clientFilterChainBuilder.build();
            connection.setProcessor((Processor)clientFilterChain);
            for (int i = 0; i < messageNum; ++i) {
                String clientMessage = "";
                CompositeBuffer bb = CompositeBuffer.newBuffer((MemoryManager)transport.getMemoryManager());
                for (int j = 0; j < clientMsgs.length; ++j) {
                    String msg = clientMsgs[j] + "-" + i;
                    clientMessage = clientMessage + msg;
                    StringEncoder stringEncoder = new StringEncoder();
                    TransformationResult result = stringEncoder.transform((AttributeStorage)connection, (Object)msg);
                    Buffer buffer = (Buffer)result.getMessage();
                    bb.append((Object)buffer);
                }
                GrizzlyFuture writeFuture = transport.getAsyncQueueIO().getWriter().write(connection, (Buffer)bb);
                FilterChainReadTest.assertTrue((String)("Write timeout loop: " + i), (writeFuture.get(10L, TimeUnit.SECONDS) != null ? 1 : 0) != 0);
                for (int j = 0; j < clientMsgs.length; ++j) {
                    String msg = clientMsgs[j] + "-" + i;
                    String srvInterm = (String)intermResultQueue.poll(10L, TimeUnit.SECONDS);
                    FilterChainReadTest.assertEquals((String)("Unexpected interm. response (" + i + ", " + j + ")"), (String)msg, (String)srvInterm);
                }
                String message = (String)resultQueue.poll(10L, TimeUnit.SECONDS);
                FilterChainReadTest.assertEquals((String)("Unexpected response (" + i + ")"), (String)clientMessage, (String)message);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBlockingReadError() throws Exception {
        Connection connection = null;
        final BlockingQueue intermResultQueue = DataStructures.getLTQInstance(Object.class);
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new StringFilter());
        filterChainBuilder.add((Filter)new BaseFilter(){

            public NextAction handleRead(FilterChainContext ctx) throws IOException {
                String message = (String)ctx.getMessage();
                logger.log(Level.INFO, "First chunk come: {0}", message);
                intermResultQueue.add(message);
                Connection connection = ctx.getConnection();
                connection.setReadTimeout(10L, TimeUnit.SECONDS);
                try {
                    ReadResult rr = ctx.read();
                    intermResultQueue.add(rr);
                }
                catch (Exception e) {
                    intermResultQueue.add(e);
                }
                return ctx.getStopAction();
            }
        });
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(PORT);
            transport.start();
            GrizzlyFuture future = transport.connect("localhost", PORT);
            connection = (Connection)future.get(10L, TimeUnit.SECONDS);
            FilterChainReadTest.assertTrue((connection != null ? 1 : 0) != 0);
            FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
            clientFilterChainBuilder.add((Filter)new TransportFilter());
            clientFilterChainBuilder.add((Filter)new StringFilter());
            FilterChain clientFilterChain = clientFilterChainBuilder.build();
            connection.setProcessor((Processor)clientFilterChain);
            String msg = "Hello";
            GrizzlyFuture writeFuture = connection.write((Object)msg);
            FilterChainReadTest.assertTrue((String)"Write timeout", (writeFuture.get(10L, TimeUnit.SECONDS) != null ? 1 : 0) != 0);
            String srvInterm = (String)intermResultQueue.poll(10L, TimeUnit.SECONDS);
            FilterChainReadTest.assertEquals((String)"Unexpected interm. response", (String)msg, (String)srvInterm);
            connection.close();
            connection = null;
            Exception e = (Exception)intermResultQueue.poll(10L, TimeUnit.SECONDS);
            FilterChainReadTest.assertTrue((String)("Unexpected response. Exception: " + e.getClass() + ": " + e.getMessage()), (boolean)(e instanceof EOFException));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }
}

