/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.asyncqueue;

import java.util.concurrent.Future;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Interceptor;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.asyncqueue.AsyncQueueRecord;
import org.glassfish.grizzly.utils.DebugPoint;

public final class AsyncReadQueueRecord
extends AsyncQueueRecord<ReadResult> {
    private static final ThreadCache.CachedTypeIndex<AsyncReadQueueRecord> CACHE_IDX = ThreadCache.obtainIndex(AsyncReadQueueRecord.class, 2);
    protected Object originalMessage;
    protected Interceptor interceptor;
    private Buffer remainderBuffer;

    public static AsyncReadQueueRecord create(Connection connection, Buffer message, Future future, ReadResult currentResult, CompletionHandler completionHandler, Interceptor<ReadResult> interceptor) {
        AsyncReadQueueRecord asyncReadQueueRecord = ThreadCache.takeFromCache(CACHE_IDX);
        if (asyncReadQueueRecord != null) {
            asyncReadQueueRecord.isRecycled = false;
            asyncReadQueueRecord.originalMessage = message;
            asyncReadQueueRecord.interceptor = interceptor;
            asyncReadQueueRecord.set(connection, message, future, currentResult, completionHandler);
            return asyncReadQueueRecord;
        }
        return new AsyncReadQueueRecord(connection, message, future, currentResult, completionHandler, interceptor);
    }

    private AsyncReadQueueRecord(Connection connection, Buffer message, Future future, ReadResult currentResult, CompletionHandler completionHandler, Interceptor<ReadResult> interceptor) {
        super(connection, message, future, currentResult, completionHandler);
        this.originalMessage = message;
        this.interceptor = interceptor;
    }

    public Buffer getRemainderBuffer() {
        this.checkRecycled();
        return this.remainderBuffer;
    }

    public void setRemainderBuffer(Buffer remainderBuffer) {
        this.checkRecycled();
        this.remainderBuffer = remainderBuffer;
    }

    public Object getOriginalMessage() {
        this.checkRecycled();
        return this.originalMessage;
    }

    public final Interceptor getInterceptor() {
        this.checkRecycled();
        return this.interceptor;
    }

    protected final void reset() {
        this.set(null, null, null, null, null);
        this.remainderBuffer = null;
        this.originalMessage = null;
        this.interceptor = null;
    }

    @Override
    public void recycle() {
        this.checkRecycled();
        this.reset();
        this.isRecycled = true;
        if (Grizzly.isTrackingThreadCache()) {
            this.recycleTrack = new DebugPoint(new Exception(), Thread.currentThread().getName());
        }
        ThreadCache.putToCache(CACHE_IDX, this);
    }
}

