/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.nio.channels.spi.SelectorProvider;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.NIOChannelDistributor;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.SelectionKeyHandler;
import org.glassfish.grizzly.nio.SelectorHandler;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public abstract class NIOTransportBuilder<T extends NIOTransportBuilder> {
    protected NIOTransport transport;

    protected NIOTransportBuilder(Class<? extends NIOTransport> transportClass, IOStrategy strategy) throws IllegalAccessException, InstantiationException {
        this.transport = transportClass.newInstance();
        ThreadPoolConfig workerConfig = strategy.createDefaultWorkerPoolConfig(this.transport);
        ThreadPoolConfig selectorConfig = this.configSelectorPool(workerConfig != null ? workerConfig.copy() : ThreadPoolConfig.defaultConfig().copy());
        this.transport.setSelectorHandler(SelectorHandler.DEFAULT_SELECTOR_HANDLER);
        this.transport.setSelectionKeyHandler(SelectionKeyHandler.DEFAULT_SELECTION_KEY_HANDLER);
        this.transport.setMemoryManager(MemoryManager.DEFAULT_MEMORY_MANAGER);
        this.transport.setAttributeBuilder(AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER);
        this.transport.setIOStrategy(strategy);
        this.transport.setReadBufferSize(65536);
        this.transport.setWorkerThreadPoolConfig(workerConfig);
        this.transport.setKernelThreadPoolConfig(selectorConfig);
        this.transport.setSelectorRunnersCount(selectorConfig.getMaxPoolSize());
    }

    public ThreadPoolConfig getWorkerThreadPoolConfig() {
        return this.transport.getWorkerThreadPoolConfig();
    }

    public ThreadPoolConfig getSelectorThreadPoolConfig() {
        return this.transport.getKernelThreadPoolConfig();
    }

    public IOStrategy getIOStrategy() {
        return this.transport.getIOStrategy();
    }

    public T setIOStrategy(IOStrategy strategy) {
        this.transport.setIOStrategy(strategy);
        return this.getThis();
    }

    public MemoryManager getMemoryManager() {
        return this.transport.getMemoryManager();
    }

    public T setMemoryManager(MemoryManager memoryManager) {
        this.transport.setMemoryManager(memoryManager);
        return this.getThis();
    }

    public SelectorHandler getSelectorHandler() {
        return this.transport.getSelectorHandler();
    }

    public T setSelectorHandler(SelectorHandler selectorHandler) {
        this.transport.setSelectorHandler(selectorHandler);
        return this.getThis();
    }

    public SelectionKeyHandler getSelectionKeyHandler() {
        return this.transport.getSelectionKeyHandler();
    }

    public T setSelectionKeyHandler(SelectionKeyHandler selectionKeyHandler) {
        this.transport.setSelectionKeyHandler(selectionKeyHandler);
        return this.getThis();
    }

    public AttributeBuilder getAttributeBuilder() {
        return this.transport.getAttributeBuilder();
    }

    public T setAttributeBuilder(AttributeBuilder attributeBuilder) {
        this.transport.setAttributeBuilder(attributeBuilder);
        return this.getThis();
    }

    public NIOChannelDistributor getNIOChannelDistributor() {
        return this.transport.getNIOChannelDistributor();
    }

    public T setNIOChannelDistributor(NIOChannelDistributor nioChannelDistributor) {
        this.transport.setNIOChannelDistributor(nioChannelDistributor);
        return this.getThis();
    }

    public SelectorProvider getSelectorProvider() {
        return this.transport.getSelectorProvider();
    }

    public T setSelectorProvider(SelectorProvider selectorProvider) {
        this.transport.setSelectorProvider(selectorProvider);
        return this.getThis();
    }

    public String getName() {
        return this.transport.getName();
    }

    public T setName(String name) {
        this.transport.setName(name);
        return this.getThis();
    }

    public Processor getProcessor() {
        return this.transport.getProcessor();
    }

    public T setProcessor(Processor processor) {
        this.transport.setProcessor(processor);
        return this.getThis();
    }

    public ProcessorSelector getProcessorSelector() {
        return this.transport.getProcessorSelector();
    }

    public T setProcessorSelector(ProcessorSelector processorSelector) {
        this.transport.setProcessorSelector(processorSelector);
        return this.getThis();
    }

    public int getReadBufferSize() {
        return this.transport.getReadBufferSize();
    }

    public T setReadBufferSize(int readBufferSize) {
        this.transport.setReadBufferSize(readBufferSize);
        return this.getThis();
    }

    public int getWriteBufferSize() {
        return this.transport.getWriteBufferSize();
    }

    public T setWriteBufferSize(int writeBufferSize) {
        this.transport.setWriteBufferSize(writeBufferSize);
        return this.getThis();
    }

    public NIOTransport build() {
        return this.transport;
    }

    protected ThreadPoolConfig configSelectorPool(ThreadPoolConfig config) {
        int runnerCount = this.getRunnerCount();
        return config.setCorePoolSize(runnerCount).setMaxPoolSize(runnerCount);
    }

    protected abstract T getThis();

    private int getRunnerCount() {
        return Runtime.getRuntime().availableProcessors();
    }
}

