/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.NIOTransportBuilder;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorIO;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;

public class TCPNIOTransportBuilder
extends NIOTransportBuilder<TCPNIOTransportBuilder> {
    protected TCPNIOTransport tcpTransport;

    protected TCPNIOTransportBuilder(Class<? extends TCPNIOTransport> transportClass, IOStrategy strategy) throws IllegalAccessException, InstantiationException {
        super(transportClass, strategy);
        this.tcpTransport = (TCPNIOTransport)this.transport;
    }

    public static TCPNIOTransportBuilder newInstance() {
        try {
            return new TCPNIOTransportBuilder((Class<? extends TCPNIOTransport>)TCPNIOTransport.class, (IOStrategy)WorkerThreadIOStrategy.getInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public int getClientSocketSoTimeout() {
        return this.tcpTransport.getClientSocketSoTimeout();
    }

    public TCPNIOTransportBuilder setClientSocketSoTimeout(int clientSocketSoTimeout) {
        this.tcpTransport.setClientSocketSoTimeout(clientSocketSoTimeout);
        return this.getThis();
    }

    public int getConnectionTimeout() {
        return this.tcpTransport.getConnectionTimeout();
    }

    public TCPNIOTransportBuilder setConnectionTimeout(int connectionTimeout) {
        this.tcpTransport.setConnectionTimeout(connectionTimeout);
        return this.getThis();
    }

    public boolean isKeepAlive() {
        return this.tcpTransport.isKeepAlive();
    }

    public TCPNIOTransportBuilder setKeepAlive(boolean keepAlive) {
        this.tcpTransport.setKeepAlive(keepAlive);
        return this.getThis();
    }

    public int getLinger() {
        return this.tcpTransport.getLinger();
    }

    public TCPNIOTransportBuilder setLinger(int linger) {
        this.tcpTransport.setLinger(linger);
        return this.getThis();
    }

    public boolean isReuseAddress() {
        return this.tcpTransport.isReuseAddress();
    }

    public TCPNIOTransportBuilder setReuseAddress(boolean reuseAddress) {
        this.tcpTransport.setReuseAddress(reuseAddress);
        return this.getThis();
    }

    public int getServerConnectionBackLog() {
        return this.tcpTransport.getServerConnectionBackLog();
    }

    public TCPNIOTransportBuilder setServerConnectionBackLog(int serverConnectionBackLog) {
        this.tcpTransport.setServerConnectionBackLog(serverConnectionBackLog);
        return this.getThis();
    }

    public int getServerSocketSoTimeout() {
        return this.tcpTransport.getServerSocketSoTimeout();
    }

    public TCPNIOTransportBuilder setServerSocketSoTimeout(int serverSocketSoTimeout) {
        this.tcpTransport.setServerSocketSoTimeout(serverSocketSoTimeout);
        return this.getThis();
    }

    public boolean isTcpNoDelay() {
        return this.tcpTransport.isTcpNoDelay();
    }

    public TCPNIOTransportBuilder setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpTransport.setTcpNoDelay(tcpNoDelay);
        return this.getThis();
    }

    public boolean isOptimizedForMultiplexing() {
        return this.tcpTransport.isOptimizedForMultiplexing();
    }

    public TCPNIOTransportBuilder setOptimizedForMultiplexing(boolean isOptimizedForMultiplexing) {
        this.tcpTransport.setOptimizedForMultiplexing(isOptimizedForMultiplexing);
        return this;
    }

    public int getMaxAsyncWriteQueueSizeInBytes() {
        return this.tcpTransport.getAsyncQueueIO().getWriter().getMaxPendingBytesPerConnection();
    }

    public TCPNIOTransportBuilder setMaxAsyncWriteQueueSizeInBytes(int size) {
        this.tcpTransport.getAsyncQueueIO().getWriter().setMaxPendingBytesPerConnection(size);
        return this;
    }

    public TemporarySelectorIO getTemporarySelectorIO() {
        return this.tcpTransport.getTemporarySelectorIO();
    }

    @Override
    public TCPNIOTransport build() {
        return (TCPNIOTransport)super.build();
    }

    @Override
    protected TCPNIOTransportBuilder getThis() {
        return this;
    }
}

