/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventProcessingHandler;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorResult;

public final class ProcessorExecutor {
    private static final Logger LOGGER = Grizzly.logger(ProcessorExecutor.class);

    public static void execute(Connection connection, IOEvent ioEvent, Processor processor, IOEventProcessingHandler processingHandler) {
        ProcessorExecutor.execute(Context.create(connection, processor, ioEvent, processingHandler));
    }

    public static void execute(Context context) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "executing connection ({0}). IOEvent={1} processor={2}", new Object[]{context.getConnection(), context.getIoEvent(), context.getProcessor()});
        }
        try {
            ProcessorResult result;
            ProcessorResult.Status status;
            boolean isRerun;
            do {
                boolean bl = isRerun = (status = (result = context.getProcessor().process(context)).getStatus()) == ProcessorResult.Status.RERUN;
                if (!isRerun) continue;
                Context newContext = (Context)result.getData();
                ProcessorExecutor.rerun(context, newContext);
                context = newContext;
            } while (isRerun);
            switch (status) {
                case COMPLETE: {
                    ProcessorExecutor.complete(context, result.getData());
                    break;
                }
                case LEAVE: {
                    ProcessorExecutor.leave(context);
                    break;
                }
                case TERMINATE: {
                    ProcessorExecutor.terminate(context);
                    break;
                }
                case REREGISTER: {
                    ProcessorExecutor.reregister(context, result.getData());
                    break;
                }
                case ERROR: {
                    ProcessorExecutor.error(context, result.getData());
                    break;
                }
                case NOT_RUN: {
                    ProcessorExecutor.notRun(context);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (Throwable t) {
            try {
                ProcessorExecutor.error(context, t);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
    }

    public static void resume(Context context) throws IOException {
        ProcessorExecutor.execute(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void complete(Context context, Object data) throws IOException {
        IOEventProcessingHandler processingHandler = context.getProcessingHandler();
        try {
            if (processingHandler != null) {
                processingHandler.onComplete(context, data);
            }
        }
        finally {
            context.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void leave(Context context) throws IOException {
        IOEventProcessingHandler processingHandler = context.getProcessingHandler();
        try {
            if (processingHandler != null) {
                processingHandler.onLeave(context);
            }
        }
        finally {
            context.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reregister(Context context, Object data) throws IOException {
        Context realContext = (Context)data;
        IOEventProcessingHandler processingHandler = context.getProcessingHandler();
        try {
            if (processingHandler != null) {
                processingHandler.onReregister(realContext);
            }
        }
        finally {
            realContext.recycle();
        }
    }

    private static void terminate(Context context) throws IOException {
        IOEventProcessingHandler processingHandler = context.getProcessingHandler();
        if (processingHandler != null) {
            processingHandler.onTerminate(context);
        }
    }

    private static void rerun(Context context, Context newContext) throws IOException {
        IOEventProcessingHandler processingHandler = context.getProcessingHandler();
        if (processingHandler != null) {
            processingHandler.onRerun(context, newContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void error(Context context, Object description) throws IOException {
        IOEventProcessingHandler processingHandler = context.getProcessingHandler();
        try {
            if (processingHandler != null) {
                processingHandler.onError(context, description);
            }
        }
        finally {
            context.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notRun(Context context) throws IOException {
        IOEventProcessingHandler processingHandler = context.getProcessingHandler();
        try {
            if (processingHandler != null) {
                processingHandler.onNotRun(context);
            }
        }
        finally {
            context.recycle();
        }
    }
}

